/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.util.SaxReader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.InvalidXPathException;
import org.dom4j.Namespace;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.AbstractElement;
import org.xml.sax.SAXException;

public final class FormQueryUtil {
    public static final List<Element> selectNodes(Document doc, String xpathQuery, boolean removeNamespace) {
        List<Object> list = new ArrayList<Element>();
        if (removeNamespace) {
            FormQueryUtil.removeNamespaces(doc);
        }
        try {
            XPath xpathSelector = DocumentHelper.createXPath((String)xpathQuery);
            list = xpathSelector.selectNodes((Object)doc);
        }
        catch (InvalidXPathException invalidXPathException) {
            // empty catch block
        }
        return list;
    }

    public static final void removeNamespaces(Document doc) {
        FormQueryUtil.setDefaultNamespace((AbstractElement)doc.getRootElement(), null);
    }

    public static final void setDefaultNamespace(AbstractElement element, String namespace) {
        List elements = element.elements();
        for (int i = 0; i < elements.size(); ++i) {
            FormQueryUtil.setDefaultNamespace((AbstractElement)elements.get(i), namespace);
        }
        if (namespace == null || namespace.trim().length() == 0) {
            element.setNamespace(null);
        } else {
            element.setNamespace(Namespace.get((String)namespace));
        }
    }

    public static Document getFormAsDom4JDocument(ApplicationForm form) throws SelfServiceException {
        try {
            SAXReader reader = SaxReader.createReader();
            ByteArrayInputStream is = new ByteArrayInputStream(form.getStream());
            Document doc = reader.read((InputStream)is);
            is.close();
            return doc;
        }
        catch (DocumentException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SAXException ex) {
            throw new SelfServiceException(ex);
        }
    }
}

