/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.json.bind.annotation.JsonbTransient;
import net.gopro.selfservice.EngineFactory;
import net.gopro.selfservice.ICollaborationLookupProvider;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.communications.Messenger;
import net.gopro.selfservice.communications.Translator;
import net.gopro.selfservice.data.AccessControl;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.CaseException;
import net.gopro.selfservice.exceptions.CommunicationException;
import net.gopro.selfservice.exceptions.MessageException;
import net.gopro.selfservice.filters.MetaDataSearchFilter;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.SearchService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.ImpersonationUtil;
import net.gopro.selfservice.util.LocaleUtil;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.json.JSONException;
import org.json.JSONObject;

public class CollaborationHelper {
    public static final String SUBMIT_KEY = "collaboration.submit";
    public static final String USER_KEY = "collaboration.user";
    public static final String INVITE_KEY = "collaboration.invite";
    public static final String INVITE_DATA = "collaboration.invite.data";
    private static final Logger logger = Logger.getLogger(CollaborationHelper.class);
    private BaseCase baseCase;

    public CollaborationHelper(BaseCase bc) {
        this.baseCase = bc;
    }

    public boolean isCollaborationUser(String userId) {
        for (MetaData meta : this.baseCase.getMetadata()) {
            if (!USER_KEY.equals(meta.getKey()) || !userId.equals(meta.getUserId())) continue;
            return true;
        }
        return false;
    }

    public boolean isPendingInvitation(String inviteEmail) {
        for (MetaData meta : this.baseCase.getMetadata()) {
            if (!INVITE_KEY.equals(meta.getKey()) || meta.isDeleted() || !meta.getValue().equals(inviteEmail)) continue;
            return true;
        }
        return false;
    }

    public boolean removeCollaborator(String userId) throws SelfServiceException {
        try {
            if (this.isCollaborationUser(userId)) {
                for (MetaData meta : this.baseCase.getMetadata()) {
                    if (USER_KEY.equals(meta.getKey()) && userId.equals(meta.getUserId()) && !meta.isDeleted()) {
                        meta.setDeleted(true);
                    }
                    if (!SUBMIT_KEY.equals(meta.getKey()) || !userId.equals(meta.getUserId()) || meta.isDeleted()) continue;
                    meta.setDeleted(true);
                }
                Iterator<AccessControl> it = this.baseCase.getAccessControlList().iterator();
                while (it.hasNext()) {
                    AccessControl acl = it.next();
                    if (!acl.getEntityId().equals(userId)) continue;
                    it.remove();
                }
                CaseService.updateCase(this.baseCase);
                ApplicationForm form = ((FormCase)this.baseCase).getApplicationForm();
                it = form.getAccessControlList().iterator();
                while (it.hasNext()) {
                    AccessControl acl = it.next();
                    if (!acl.getEntityId().equals(userId)) continue;
                    it.remove();
                }
                CaseService.updateAccessControl(form);
                List<SubDocument> caseDocuments = CaseService.getCaseDocuments(this.baseCase.getId(), false);
                for (SubDocument sub : caseDocuments) {
                    it = sub.getAccessControlList().iterator();
                    while (it.hasNext()) {
                        AccessControl acl = it.next();
                        if (!acl.getEntityId().equals(userId)) continue;
                        it.remove();
                    }
                    CaseService.updateAccessControl(sub);
                }
                return true;
            }
            return false;
        }
        catch (CaseException ex) {
            throw new SelfServiceException(ex);
        }
    }

    public static void checkInvitations(User user) throws SelfServiceException {
        try {
            ImpersonationUtil.impersonate();
            MetaDataSearchFilter filter = new MetaDataSearchFilter(INVITE_KEY, user.getEmail());
            filter.addDocumentType(FormCase.class);
            List<BaseDocument> documentList = SearchService.searchDocumentsByMetadata(filter);
            logger.debug((Object)String.format("Metadata search found %d invite records for email %s", documentList.size(), user.getEmail()));
            for (BaseDocument doc : documentList) {
                BaseCase bc;
                if (!(doc instanceof FormCase) || doc.isDeleted() || (bc = CaseService.getCase(doc.getId())) == null) continue;
                logger.debug((Object)String.format("Case %s has been shared ..", bc.getSubject()));
                for (MetaData meta : bc.getMetadata()) {
                    if (!INVITE_KEY.equals(meta.getKey()) || !user.getEmail().equalsIgnoreCase(meta.getValue())) continue;
                    logger.debug((Object)String.format("Found the invite key on email %s ", meta.getValue()));
                    meta.setDeleted(true);
                    MetaData metaConfiguration = CollaborationHelper.findCollaborationData(meta, bc.getMetadata());
                    if (metaConfiguration != null) {
                        JSONObject json = new JSONObject(metaConfiguration.getValue());
                        boolean submit = json.has("submit") ? json.getBoolean("submit") : false;
                        String access = json.has("access") ? json.getString("access") : "read";
                        metaConfiguration.setDeleted(true);
                        MetaData mUser = new MetaData(USER_KEY, user.getFullname(), user.getId());
                        MetaData mSubmit = new MetaData(SUBMIT_KEY, String.valueOf(submit), user.getId());
                        mUser.setReferenceId(bc.getId());
                        mSubmit.setReferenceId(bc.getId());
                        ConfigService.createMetaData(mUser);
                        ConfigService.createMetaData(mSubmit);
                        AccessControl acl = new AccessControl(bc.getId(), user.getId());
                        acl.setEntityType(AccessControl.AccessControlType.USER);
                        acl.setBitmask("write".equals(access) ? AccessControl.Permission.WRITE.getValue() : AccessControl.Permission.READ.getValue());
                        bc.getAccessControlList().add(acl);
                        ApplicationForm applicationForm = ((FormCase)bc).getApplicationForm();
                        applicationForm.getAccessControlList().add(acl);
                        CaseService.updateCase(bc);
                        CaseService.updateAccessControl(applicationForm);
                        List<SubDocument> caseDocuments = CaseService.getCaseDocuments(bc.getId(), false);
                        acl.setBitmask(AccessControl.Permission.READ.getValue());
                        for (SubDocument sub : caseDocuments) {
                            sub.getAccessControlList().add(acl);
                            CaseService.updateAccessControl(sub);
                        }
                        User caseOwner = UserService.getUser(bc.getCreatedById());
                        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages", caseOwner.getLocale());
                        String participantSubject = rb.getString("collaboration.invitation.subject");
                        String participantBody = Translator.translate(Arrays.asList(caseOwner, bc), rb.getString(INVITE_KEY));
                        Messenger.sendMessage(user, participantSubject, participantBody, true);
                        String ownerSubject = rb.getString("collaboration.accepted.subject");
                        String ownerBody = Translator.translate(Arrays.asList(user, bc), rb.getString("collaboration.accepted.body"));
                        Messenger.sendMessage(caseOwner, ownerSubject, ownerBody, true);
                        continue;
                    }
                    logger.warn((Object)("Found invite key, but no invite data for email: " + user.getEmail()));
                }
            }
        }
        catch (CaseException ex) {
            throw new SelfServiceException(ex);
        }
        catch (CommunicationException ex) {
            throw new SelfServiceException(ex);
        }
        catch (MessageException ex) {
            throw new SelfServiceException(ex);
        }
        finally {
            ImpersonationUtil.destroy();
        }
    }

    public List<Collaborator> getUserList() {
        ArrayList<Collaborator> list = new ArrayList<Collaborator>();
        for (MetaData meta : this.baseCase.getMetadata()) {
            if (!USER_KEY.equals(meta.getKey()) || meta.isDeleted()) continue;
            String userId = meta.getUserId();
            AccessControl acl = this.findAccessControl(userId, this.baseCase.getAccessControlList());
            if (acl != null) {
                boolean isSubmit = this.isSubmitEnabled(userId, this.baseCase.getMetadata());
                Collaborator coll = new Collaborator(acl, meta.getDateCreated(), isSubmit);
                list.add(coll);
                continue;
            }
            logger.warn((Object)String.format("Could not find ACL entry for Collaborator on case %s for user %s", this.baseCase.getId(), userId));
        }
        return list;
    }

    public List<CollaborationRestriction> getRestrictions() {
        if (SelfServiceEngine.getConfig(ICollaborationLookupProvider.class.getName()) != null) {
            try {
                logger.info((Object)("Invoking custom collaboration class: " + SelfServiceEngine.getConfig(ICollaborationLookupProvider.class.getName())));
                ICollaborationLookupProvider customLookup = EngineFactory.getCustomEngine(ICollaborationLookupProvider.class);
                return customLookup.getRestrictions();
            }
            catch (SelfServiceException ex) {
                logger.error((Object)ex);
            }
        }
        return new ArrayList<CollaborationRestriction>();
    }

    private boolean isSubmitEnabled(String userId, List<MetaData> metaList) {
        for (MetaData meta : metaList) {
            if (meta.getUserId() == null || !meta.getUserId().equals(userId) || !SUBMIT_KEY.equals(meta.getKey()) || meta.isDeleted()) continue;
            return Boolean.valueOf(meta.getValue());
        }
        return false;
    }

    private AccessControl findAccessControl(String userId, List<AccessControl> aclList) {
        for (AccessControl acl : aclList) {
            if (!acl.getEntityId().equals(userId)) continue;
            return acl;
        }
        return null;
    }

    private static MetaData findCollaborationData(MetaData inviteMeta, List<MetaData> metadataList) {
        for (MetaData meta : metadataList) {
            if (!INVITE_DATA.equals(meta.getKey()) || meta.isDeleted()) continue;
            try {
                String refId;
                JSONObject json = new JSONObject(meta.getValue());
                String email = json.has("email") ? json.getString("email") : null;
                String string = refId = json.has("ref") ? json.getString("ref") : null;
                if (email == null || refId == null || !email.equals(inviteMeta.getValue()) || !refId.equals(inviteMeta.getId())) continue;
                return meta;
            }
            catch (JSONException ex) {
                logger.error((Object)("Invalid JSON payload for entry: " + meta.getId()));
            }
        }
        return null;
    }

    public class Collaborator {
        private String userId;
        private String fullname;
        private int permission;
        private boolean canSubmit = false;
        private long dateCreated;

        public String getFullname() {
            return this.fullname;
        }

        public boolean isCanSubmit() {
            return this.canSubmit;
        }

        public Collaborator(AccessControl acl, long dateCreated, boolean submit) {
            this.userId = acl.getEntityId();
            this.fullname = acl.getEntityReference() != null ? acl.getEntityReference().getName() : null;
            this.permission = acl.getBitmask();
            this.dateCreated = dateCreated;
            this.canSubmit = submit;
        }

        public Collaborator(User caseOwner, BaseCase bc) {
            this.userId = caseOwner.getId();
            this.fullname = caseOwner.getFullname();
            this.permission = AccessControl.Permission.WRITE.getValue();
            this.dateCreated = bc.getDateCreated();
            this.canSubmit = true;
        }

        public String getUserId() {
            return this.userId;
        }

        @JsonIgnore
        @JsonbTransient
        public Element getXml() {
            Element el = DocumentHelper.createElement((String)"collaborator");
            el.addElement("id").setText(this.userId);
            el.addElement("name").setText(this.fullname);
            el.addElement("submit").setText(String.valueOf(this.canSubmit));
            el.addElement("permission").setText(String.valueOf(this.permission));
            el.addElement("added").setText(LocaleUtil.formatDateShort(this.dateCreated));
            return el;
        }
    }

    public class CollaborationRestriction {
        private String templateId;
        private boolean readOnlyRestriction = false;
        private boolean inheritAccess = true;

        public CollaborationRestriction(String templateId, boolean readonly, boolean inherit) {
            this.templateId = templateId;
            this.readOnlyRestriction = readonly;
            this.inheritAccess = inherit;
        }

        public String getTemplateId() {
            return this.templateId;
        }

        public boolean isReadOnlyRestriction() {
            return this.readOnlyRestriction;
        }

        public boolean isInheritAccess() {
            return this.inheritAccess;
        }

        @JsonIgnore
        @JsonbTransient
        public Element getXml() {
            Element el = DocumentHelper.createElement((String)"restriction");
            el.addElement("id").setText(this.templateId);
            el.addElement("readonly").setText(String.valueOf(this.readOnlyRestriction));
            el.addElement("inherit").setText(String.valueOf(this.inheritAccess));
            return el;
        }
    }
}

