/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.util;

import is.hugvit.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Normalizer;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.AccessControl;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.Memo;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.DocumentSecurityException;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.util.DocumentSecurityUtil;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class CaseExportUtil {
    private static final Logger logger = Logger.getLogger(CaseExportUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final File getCaseFiles(String caseId, boolean includeAllDocuments) throws SelfServiceException {
        Iterator<SubDocument> ex2;
        String caseFolderName;
        String fName;
        String baseFolder;
        ZipOutputStream out = null;
        File zipFolder = null;
        try {
            BaseCase bc = CaseService.getCase(caseId);
            if (bc != null && bc.getSubDocumentCount() > 0) {
                File tempFolder = Util.getTempDirectory();
                baseFolder = tempFolder.getAbsolutePath();
                if (!baseFolder.endsWith(File.separator)) {
                    baseFolder = baseFolder + File.separator;
                }
                if (!StringUtil.isValid(fName = bc.getReferenceNumber().replace("/", "-"))) {
                    fName = bc.getId();
                }
                if ((zipFolder = new File(caseFolderName = baseFolder + fName + File.separator)).exists()) {
                    try {
                        FileUtils.cleanDirectory((File)zipFolder);
                    }
                    catch (IOException ex2) {
                        logger.warn((Object)"Could not clean directory for zipped case data.", (Throwable)ex2);
                    }
                } else if (!zipFolder.mkdir()) {
                    logger.error((Object)("Could not create working directory while exporting files.  Check folder permissions on folder: " + baseFolder));
                    throw new SelfServiceException("Could not create working directory while exporting files.  Check folder permissions on folder: " + baseFolder);
                }
            } else {
                File file = null;
                return file;
            }
            ex2 = bc.getSubDocuments().iterator();
        }
        catch (FileNotFoundException ex3) {
            throw new SelfServiceException(ex3);
        }
        catch (IOException ex4) {
            throw new SelfServiceException(ex4);
        }
        finally {
            if (zipFolder != null) {
                try {
                    FileUtils.deleteDirectory(zipFolder);
                }
                catch (IOException ex5) {
                    logger.warn((Object)"Could not delete temp directory after zipping case data.", (Throwable)ex5);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex6) {
                    throw new SelfServiceException(ex6);
                }
            }
        }
        while (ex2.hasNext()) {
            SubDocument subDoc = ex2.next();
            if (subDoc instanceof Memo) {
                Memo memo = (Memo)subDoc;
                CaseExportUtil.writeFile(StringUtil.sanitizeFileName(memo.getSubject() + ".txt"), caseFolderName, memo.getBody().getBytes());
                continue;
            }
            if (!(subDoc instanceof ExternalDocument)) continue;
            ExternalDocument doc = CaseService.getExternalDocument(subDoc.getId(), true);
            if (!includeAllDocuments && doc instanceof ApplicationForm || doc == null) continue;
            CaseExportUtil.writeFile(StringUtil.sanitizeFileName(doc.getFilename()), caseFolderName, doc.getStream());
        }
        String zipFile = baseFolder + fName + ".zip";
        out = new ZipOutputStream(new FileOutputStream(zipFile));
        CaseExportUtil.zipFolder(zipFolder, out, baseFolder);
        File file = new File(zipFile);
        if (zipFolder != null) {
            try {
                FileUtils.deleteDirectory((File)zipFolder);
            }
            catch (IOException ex7) {
                logger.warn((Object)"Could not delete temp directory after zipping case data.", (Throwable)ex7);
            }
        }
        if (out == null) return file;
        try {
            out.close();
            return file;
        }
        catch (IOException ex8) {
            throw new SelfServiceException(ex8);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final File getCaseFiles(String caseId, boolean includeAllDocuments, User user) throws SelfServiceException {
        Iterator<SubDocument> ex2;
        String caseFolderName;
        String fName;
        String baseFolder;
        ZipOutputStream out = null;
        File zipFolder = null;
        try {
            BaseCase bc = CaseService.getCase(caseId);
            if (bc != null && bc.getSubDocumentCount() > 0) {
                File tempFolder = Util.getTempDirectory();
                baseFolder = tempFolder.getAbsolutePath();
                if (!baseFolder.endsWith(File.separator)) {
                    baseFolder = baseFolder + File.separator;
                }
                if (!StringUtil.isValid(fName = bc.getReferenceNumber().replace("/", "-"))) {
                    fName = bc.getId();
                }
                if ((zipFolder = new File(caseFolderName = baseFolder + fName + File.separator)).exists()) {
                    try {
                        FileUtils.cleanDirectory((File)zipFolder);
                    }
                    catch (IOException ex2) {
                        logger.warn((Object)"Could not clean directory for zipped case data.", (Throwable)ex2);
                    }
                } else if (!zipFolder.mkdir()) {
                    logger.error((Object)("Could not create working directory while exporting files.  Check folder permissions on folder: " + baseFolder));
                    throw new SelfServiceException("Could not create working directory while exporting files.  Check folder permissions on folder: " + baseFolder);
                }
            } else {
                File file = null;
                return file;
            }
            ex2 = bc.getSubDocuments().iterator();
        }
        catch (FileNotFoundException ex3) {
            throw new SelfServiceException(ex3);
        }
        catch (IOException ex4) {
            throw new SelfServiceException(ex4);
        }
        finally {
            if (zipFolder != null) {
                try {
                    FileUtils.deleteDirectory(zipFolder);
                }
                catch (IOException ex5) {
                    logger.warn((Object)"Could not delete temp directory after zipping case data.", (Throwable)ex5);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex6) {
                    throw new SelfServiceException(ex6);
                }
            }
        }
        while (ex2.hasNext()) {
            SubDocument subDoc = ex2.next();
            try {
                DocumentSecurityUtil.validatePermission(subDoc, user, AccessControl.Permission.READ);
                if (subDoc instanceof Memo) {
                    Memo memo = (Memo)subDoc;
                    CaseExportUtil.writeFile(StringUtil.sanitizeFileName(memo.getSubject() + ".txt"), caseFolderName, memo.getBody().getBytes());
                    continue;
                }
                if (!(subDoc instanceof ExternalDocument)) continue;
                ExternalDocument doc = CaseService.getExternalDocument(subDoc.getId(), true);
                if (!includeAllDocuments && doc instanceof ApplicationForm || doc == null) continue;
                CaseExportUtil.writeFile(StringUtil.sanitizeFileName(doc.getFilename()), caseFolderName, doc.getStream());
            }
            catch (DocumentSecurityException doc) {}
        }
        String zipFile = baseFolder + fName + ".zip";
        out = new ZipOutputStream(new FileOutputStream(zipFile));
        CaseExportUtil.zipFolder(zipFolder, out, baseFolder);
        File file = new File(zipFile);
        if (zipFolder != null) {
            try {
                FileUtils.deleteDirectory((File)zipFolder);
            }
            catch (IOException ex7) {
                logger.warn((Object)"Could not delete temp directory after zipping case data.", (Throwable)ex7);
            }
        }
        if (out == null) return file;
        try {
            out.close();
            return file;
        }
        catch (IOException ex8) {
            throw new SelfServiceException(ex8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeFile(String filename, String basepath, byte[] data) throws IOException {
        try (FileOutputStream fos = null;){
            String path = basepath + filename;
            File file = new File(path);
            if (file.exists() && file.isFile()) {
                String extension = FilenameUtils.getExtension((String)filename);
                String baseName = FilenameUtils.getBaseName((String)filename);
                int iterationCounter = 2;
                String newFileName = String.format("%s_%d.%s", baseName, iterationCounter, extension);
                file = new File(basepath + newFileName);
                while (file.exists()) {
                    newFileName = String.format("%s_%d.%s", baseName, ++iterationCounter, extension);
                    file = new File(basepath + newFileName);
                }
                path = basepath + newFileName;
                fos = new FileOutputStream(path);
                fos.write(data);
            } else {
                fos = new FileOutputStream(path);
                fos.write(data);
            }
        }
    }

    private static final void zipFolder(File folder, ZipOutputStream zip, String baseName) throws IOException {
        File[] files;
        for (File file : files = folder.listFiles()) {
            if (file.isDirectory()) {
                CaseExportUtil.zipFolder(file, zip, baseName);
                continue;
            }
            String normalizer = Normalizer.normalize(file.getAbsolutePath().substring(baseName.length()), Normalizer.Form.NFD);
            Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
            String name = pattern.matcher(normalizer).replaceAll("").replaceAll("[^\\p{ASCII}]", "");
            ZipEntry zipEntry = new ZipEntry(name);
            zip.putNextEntry(zipEntry);
            IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)zip);
            zip.closeEntry();
        }
    }
}

