/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.twofactor;

import com.authy.AuthyApiClient;
import com.authy.AuthyException;
import com.authy.api.Error;
import com.authy.api.Hash;
import com.authy.api.Token;
import com.authy.api.Tokens;
import com.authy.api.User;
import com.authy.api.Users;
import java.io.IOException;
import java.util.ArrayList;
import javax.json.JsonException;
import net.gopro.selfservice.ITwoFactorAuthProvider;
import net.gopro.selfservice.SelfServiceException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class AuthyImpl
implements ITwoFactorAuthProvider {
    private AuthyApiClient client;
    private String apiKey;
    private Error error;
    private String apiEmailUrl = "https://api.authy.com/protected/json/email/%s";
    private static final Logger logger = Logger.getLogger(AuthyImpl.class);

    @Override
    public String getProviderName() throws SelfServiceException {
        return "Authy (http.//authy.com)";
    }

    @Override
    public void setApiKey(String apiKey) throws SelfServiceException {
        this.apiKey = apiKey;
    }

    @Override
    public String createUser(String email, String phoneNumber, String countryCode) throws SelfServiceException {
        try {
            logger.debug((Object)String.format("Create user: email: %s and phonenumber: +%s %s", email, countryCode, phoneNumber));
            this.error = null;
            Users users = this.getClient().getUsers();
            User authyUser = users.createUser(email, phoneNumber, countryCode);
            if (authyUser.isOk()) {
                logger.debug((Object)String.format("All Ok. Authy userid: %s", authyUser.getId()));
                return String.valueOf(authyUser.getId());
            }
            logger.debug((Object)String.format("Error occurred: %s", authyUser.getError().getMessage()));
            this.error = authyUser.getError();
            throw new SelfServiceException("Error creating user. " + this.error.getMessage());
        }
        catch (Exception ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public boolean verify(String userReferenceId, String authToken) throws SelfServiceException {
        this.error = null;
        try {
            Tokens tokens = this.getClient().getTokens();
            Token verification = tokens.verify(Integer.parseInt(userReferenceId), authToken);
            boolean isVerified = verification.isOk();
            if (!isVerified) {
                this.error = verification.getError();
            }
            return isVerified;
        }
        catch (NumberFormatException ex) {
            this.error = new Error();
            this.error.setMessage("Only numbers can be used in the authentication token");
            return false;
        }
        catch (Exception ex) {
            this.error = new Error();
            this.error.setMessage(ex.getMessage());
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public boolean requestOTP(String userReferenceId, ITwoFactorAuthProvider.OneTimePassword type) throws SelfServiceException {
        try {
            Users users = this.getClient().getUsers();
            if (type.equals((Object)ITwoFactorAuthProvider.OneTimePassword.SMS)) {
                Hash response = users.requestSms(Integer.parseInt(userReferenceId));
                if (response.isOk()) {
                    return true;
                }
                this.error = response.getError();
                return false;
            }
            if (type.equals((Object)ITwoFactorAuthProvider.OneTimePassword.VOICE)) {
                Hash response = users.requestCall(Integer.parseInt(userReferenceId));
                if (response.isOk()) {
                    return true;
                }
                this.error = response.getError();
                return false;
            }
            if (type.equals((Object)ITwoFactorAuthProvider.OneTimePassword.EMAIL)) {
                String result = this.sendTokenEmail(userReferenceId, true);
                try {
                    boolean success;
                    JSONObject job = new JSONObject(result);
                    boolean bl = success = job.has("success") ? job.getBoolean("success") : false;
                    if (success) {
                        return true;
                    }
                    if (job.has("error_code")) {
                        Error err = new Error();
                        if (job.has("message")) {
                            err.setMessage(job.getString("message"));
                        } else {
                            err.setMessage(job.getString("error_code"));
                        }
                        this.error = err;
                    }
                    return false;
                }
                catch (JsonException ex) {
                    logger.error((Object)"Response is not JSON");
                    return false;
                }
            }
            return false;
        }
        catch (NumberFormatException ex) {
            this.error = new Error();
            this.error.setMessage("Only numbers can be used in the authentication token");
            return false;
        }
        catch (Exception ex) {
            this.error = new Error();
            this.error.setMessage(ex.getMessage());
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public boolean deleteUser(String userReferenceId) throws SelfServiceException {
        try {
            if (StringUtils.isNumeric((String)userReferenceId)) {
                Hash response = this.getClient().getUsers().deleteUser(Integer.parseInt(userReferenceId));
                if (response.isOk()) {
                    return true;
                }
                this.error = response.getError();
                return false;
            }
            this.error = new Error();
            this.error.setMessage("The user reference number must be numeric");
            return false;
        }
        catch (AuthyException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
    }

    @Override
    public String getAuthenticationError() throws SelfServiceException {
        if (this.error != null) {
            return this.error.getMessage();
        }
        return null;
    }

    private String sendTokenEmail(String authyId, boolean force) throws IOException {
        String result = "";
        String url = String.format(this.apiEmailUrl, authyId);
        if (force) {
            url = url + "?force=true";
        }
        logger.debug((Object)String.format("Creating url request: %s ", url));
        HttpPost post = new HttpPost(url);
        post.setHeader("X-Authy-API-Key", this.apiKey);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        return result;
    }

    @Override
    public String updateEmailAddress(String authyId, String email) throws SelfServiceException {
        try {
            String url = String.format("https://api.authy.com/protected/json/users/%s/update", authyId);
            String result = "";
            HttpPost post = new HttpPost(url);
            post.setHeader("X-Authy-API-Key", this.apiKey);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("email", email));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            return result;
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private AuthyApiClient getClient() {
        if (this.client == null) {
            logger.debug((Object)String.format("Creating new Authy client with API key: %s", this.apiKey));
            this.client = new AuthyApiClient(this.apiKey);
        }
        return this.client;
    }
}

