/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.servlets;

import java.io.IOException;
import java.security.Principal;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.services.UserService;
import org.apache.log4j.Logger;

public class TwoFactorEnforcementFilter
implements Filter {
    private static Logger logger = Logger.getLogger(TwoFactorEnforcementFilter.class);
    private boolean isTwoFactorAuthenticatationEnabled = false;
    private Timer timer;
    private int loadingDelay = 5;

    public void init(FilterConfig config) throws ServletException {
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                String configEnabled = SelfServiceEngine.getConfig("security.twofactor.enabled");
                if (configEnabled != null && "true".equalsIgnoreCase(configEnabled)) {
                    TwoFactorEnforcementFilter.this.isTwoFactorAuthenticatationEnabled = true;
                    logger.debug((Object)"Two Factor authentication is enabled");
                }
                this.cancel();
            }
        }, this.loadingDelay * 1000);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isTwoFactorAuthenticatationEnabled) {
            try {
                User currentUser = this.getCurrentUser((HttpServletRequest)request);
                if (this.isTwoFactorAuthenticationEnabled(currentUser)) {
                    HttpSession session;
                    Object attribute;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Two Factor Authentication is enabled for user: " + currentUser.getFullname()));
                    }
                    if ((attribute = (session = ((HttpServletRequest)request).getSession()).getAttribute("twofactorauth")) != null && Boolean.TRUE.equals(attribute)) {
                        session.removeAttribute("twofactor.pending");
                        chain.doFilter(request, response);
                    }
                    session.setAttribute("twofactor.pending", (Object)Boolean.TRUE);
                    String path = "/web/twofactor.html";
                    RequestDispatcher dispatcher = request.getRequestDispatcher("/web/twofactor.html");
                    dispatcher.forward(request, response);
                }
                chain.doFilter(request, response);
            }
            catch (SelfServiceException ex) {
                throw new ServletException((Throwable)ex);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private boolean isTwoFactorAuthenticationEnabled(User user) {
        MetaData metaTwoFactor = user.getMetaDataByKey("authentication.twofactor");
        return metaTwoFactor != null && !metaTwoFactor.isDeleted() && "true".equalsIgnoreCase(metaTwoFactor.getValue());
    }

    private User getCurrentUser(HttpServletRequest request) throws SelfServiceException {
        Principal principal = request.getUserPrincipal();
        if (principal == null) {
            throw new SelfServiceException("User is not Authenticated !");
        }
        return UserService.getUserByUsername(principal.getName());
    }
}

