/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.servlets;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.services.LogService;
import net.gopro.selfservice.services.UserService;

public class LoginFilter
implements Filter {
    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        chain.doFilter(request, response);
        if (req.getUserPrincipal() != null) {
            try {
                User user = UserService.getUserByUsername(req.getUserPrincipal().getName());
                if (user != null) {
                    AuditLogEntry entry = new AuditLogEntry();
                    entry.setAction(AuditLogEntry.Action.LOGIN);
                    entry.setDataType(AuditLogEntry.DataType.USER);
                    entry.setUserId(user.getId());
                    entry.setDocumentId(user.getId());
                    entry.setIp(request.getRemoteAddr());
                    LogService.createLogEntry(entry);
                }
            }
            catch (Exception ex) {
                SelfServiceEngine.getLogger().error(ex.getMessage());
            }
        }
    }

    public void destroy() {
    }
}

