/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.services;

import java.util.List;
import net.gopro.selfservice.IQueueEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.routing.BrokerRelationEntry;
import net.gopro.selfservice.data.routing.PickUpQueueEntry;
import net.gopro.selfservice.data.routing.QueueLogEntry;
import net.gopro.selfservice.data.routing.RoutingQueueEntry;
import net.gopro.selfservice.data.routing.RoutingQueueInformationEntry;
import net.gopro.selfservice.filters.RoutingLogFilter;
import net.gopro.selfservice.services.BaseService;

public class QueueService
extends BaseService {
    public static final List<RoutingQueueEntry> getRoutingQueue() throws SelfServiceException {
        return QueueService.QueueEngine().getRoutingQueue();
    }

    public static boolean createRoutingQueueEntry(RoutingQueueEntry entry) throws SelfServiceException {
        return QueueService.QueueEngine().createRoutingQueueEntry(entry);
    }

    public static final RoutingQueueEntry getRoutingQueueEntry(String queueId) throws SelfServiceException {
        return QueueService.QueueEngine().getRoutingQueueEntry(queueId);
    }

    public static final BrokerRelationEntry getBrokerRelationEntry(String queueId) throws SelfServiceException {
        return QueueService.QueueEngine().getBrokerRelationEntry(queueId);
    }

    public static final void createDocumentRelation(String queueId, String remoteGoProId) throws SelfServiceException {
        QueueService.QueueEngine().createDocumentRelation(queueId, remoteGoProId);
    }

    public static final void createCaseRelation(String queueId, String goproDocumentId, String goproCaseId) throws SelfServiceException {
        QueueService.QueueEngine().createCaseRelation(queueId, goproDocumentId, goproCaseId);
    }

    public static final void removeRoutingQueueEntry(String queueId) throws SelfServiceException {
        QueueService.QueueEngine().removeRoutingQueueEntry(queueId);
    }

    public static void updateRoutingQueueEntry(RoutingQueueEntry entry) throws SelfServiceException {
        QueueService.QueueEngine().updateRoutingQueueEntry(entry);
    }

    public static List<RoutingQueueInformationEntry> getRoutingQueueStatus(RoutingLogFilter filter) throws SelfServiceException {
        return QueueService.QueueEngine().getRoutingQueueStatus(filter);
    }

    public static void createQueueLogEntry(QueueLogEntry entry) throws SelfServiceException {
        QueueService.QueueEngine().createQueueLogEntry(entry);
    }

    public static List<QueueLogEntry> getQueueLog(String queueId) throws SelfServiceException {
        return QueueService.QueueEngine().getQueueLog(queueId);
    }

    public static void createBrokerRelationEntry(BrokerRelationEntry entry) throws SelfServiceException {
        QueueService.QueueEngine().createBrokerRelationEntry(entry);
    }

    public static List<BrokerRelationEntry> getBrokerRelations(IQueueEngine.BrokerDocumentType type, IQueueEngine.BrokerRelationStatus status) throws SelfServiceException {
        return QueueService.QueueEngine().getBrokerRelations(type, status);
    }

    public static void updateBrokerRelation(BrokerRelationEntry entry) throws SelfServiceException {
        QueueService.QueueEngine().updateBrokerRelation(entry);
    }

    public static void updateDocumentRelation(BaseDocument doc) throws SelfServiceException {
        QueueService.QueueEngine().updateDocumentRelation(doc);
    }

    public static List<PickUpQueueEntry> getPickUpQueue(RoutingLogFilter filter) throws SelfServiceException {
        return QueueService.QueueEngine().getPickUpQueue(filter);
    }

    public static List<RoutingQueueEntry> findEntries(String documentId) throws SelfServiceException {
        return QueueService.QueueEngine().findEntries(documentId);
    }
}

