/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.services;

import java.util.Hashtable;
import java.util.List;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.AccessControl;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.CaseList;
import net.gopro.selfservice.data.CaseTemplate;
import net.gopro.selfservice.data.CheckoutTicket;
import net.gopro.selfservice.data.Email;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.IAccessControlled;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.exceptions.CaseException;
import net.gopro.selfservice.exceptions.SaveConflictException;
import net.gopro.selfservice.filters.CaseListFilter;
import net.gopro.selfservice.services.BaseService;
import net.gopro.selfservice.services.VirusScanService;

public class CaseService
extends BaseService {
    public static final void createCase(BaseCase bc) throws SelfServiceException, CaseException {
        CaseService.CaseEngine().createCase(bc);
    }

    public static final BaseCase getCase(String caseId) throws SelfServiceException {
        return CaseService.CaseEngine().getCase(caseId);
    }

    public static final BaseCase getCaseByGoProId(String goproDocumentId, String organizationId) throws SelfServiceException {
        return CaseService.CaseEngine().getCaseByGoProId(goproDocumentId, organizationId);
    }

    public static SubDocument getSubDocument(String documentId, boolean includeStream) throws SelfServiceException {
        return CaseService.CaseEngine().getSubDocument(documentId, includeStream);
    }

    public static SubDocument getSubDocumentByGoProId(String goproDocumentId) throws SelfServiceException {
        return CaseService.CaseEngine().getSubDocumentByGoProId(goproDocumentId);
    }

    public static void createSubDocument(SubDocument doc) throws CaseException, SelfServiceException {
        if (doc instanceof Attachment) {
            VirusScanService.virusScan((Attachment)doc);
        }
        CaseService.CaseEngine().createSubDocument(doc);
    }

    public static List<BaseCase> getCases() throws SelfServiceException {
        return CaseService.CaseEngine().getCases();
    }

    public static List<BaseCase> getCases(String userId) throws SelfServiceException {
        return CaseService.CaseEngine().getCases(userId);
    }

    public static CaseList getCases(String userId, CaseListFilter filter) throws SelfServiceException {
        return CaseService.CaseEngine().getCases(userId, filter);
    }

    public static List<FormCase> getCasesByFormTemplate(String userId, String templateId) throws SelfServiceException {
        return CaseService.CaseEngine().getCasesByFormTemplate(userId, templateId);
    }

    public static List<FormCase> getCasesByFormTemplate(String templateId) throws SelfServiceException {
        return CaseService.CaseEngine().getCasesByFormTemplate(templateId);
    }

    public static List<BaseCase> getCasesByCaseTemplate(String templateId, String userId) throws SelfServiceException {
        return CaseService.CaseEngine().getCasesByCaseTemplate(templateId, userId);
    }

    public static List<BaseCase> getCasesByOrganization(String organizationId) throws SelfServiceException {
        return CaseService.CaseEngine().getCasesByOrganization(organizationId);
    }

    public static List<BaseCase> getCasesByCompany(String companyId) throws SelfServiceException {
        return CaseService.CaseEngine().getCasesByCompany(companyId);
    }

    public static ExternalDocument getExternalDocument(String documentId, boolean includeStream) throws SelfServiceException {
        return CaseService.CaseEngine().getExternalDocument(documentId, includeStream);
    }

    public static Email getEmail(String documentId, boolean includeStream) throws SelfServiceException {
        return CaseService.CaseEngine().getEmail(documentId, includeStream);
    }

    public static void updateCase(BaseCase bc) throws CaseException, SelfServiceException {
        CaseService.CaseEngine().updateCase(bc);
    }

    public static void updateSubDocument(SubDocument doc) throws CaseException, SaveConflictException, SelfServiceException {
        CaseService.CaseEngine().updateSubDocument(doc);
    }

    public static void updateSubdocumentStatus(SubDocument doc) throws SelfServiceException {
        CaseService.CaseEngine().updateSubdocumentStatus(doc);
    }

    public static List<SubDocument> getCaseDocuments(String caseId, boolean includeStream) throws SelfServiceException {
        return CaseService.CaseEngine().getCaseDocuments(caseId, includeStream);
    }

    public static void deleteSubDocument(String documentId) throws CaseException, SaveConflictException, SelfServiceException {
        CaseService.CaseEngine().deleteSubDocument(documentId);
    }

    public static void deleteCase(String caseId) throws CaseException, SaveConflictException, SelfServiceException {
        CaseService.CaseEngine().deleteCase(caseId);
    }

    public static Hashtable<String, String> getCaseTypesInUse(String userId) throws SelfServiceException {
        return CaseService.CaseEngine().getCaseTypesInUse(userId);
    }

    public static List<SubDocument> getSubdocuments(String userId) throws SelfServiceException {
        return CaseService.CaseEngine().getSubdocuments(userId);
    }

    public static void createCaseTemplate(CaseTemplate ct) throws CaseException, SelfServiceException {
        CaseService.CaseEngine().createCaseTemplate(ct);
    }

    public static void updateCaseTemplate(CaseTemplate ct) throws CaseException, SelfServiceException {
        CaseService.CaseEngine().updateCaseTemplate(ct);
    }

    public static CaseTemplate getCaseTemplate(String caseTemplateId) throws SelfServiceException {
        return CaseService.CaseEngine().getCaseTemplate(caseTemplateId);
    }

    public static List<CaseTemplate> getCaseTemplates() throws SelfServiceException {
        return CaseService.CaseEngine().getCaseTemplates();
    }

    public static List<CaseTemplate> getPrimaryCaseTemplates() throws SelfServiceException {
        return CaseService.CaseEngine().getPrimaryCaseTemplates();
    }

    public static void deleteCaseTemplate(String caseTemplateId) throws CaseException, SelfServiceException {
        CaseService.CaseEngine().deleteCaseTemplate(caseTemplateId);
    }

    public static String cloneCase(String caseId, boolean copyResponseDocuments) throws SelfServiceException, CaseException {
        return CaseService.CaseEngine().cloneCase(caseId, copyResponseDocuments);
    }

    public static CheckoutTicket checkOutDocument(String documentId, String userId) throws SelfServiceException {
        return CaseService.CaseEngine().checkOutDocument(documentId, userId);
    }

    public static boolean checkInDocument(String documentId) throws SelfServiceException {
        return CaseService.CaseEngine().checkInDocument(documentId);
    }

    public static List<SubDocument> getCheckedOutDocuments() throws SelfServiceException {
        return CaseService.CaseEngine().getCheckedOutDocuments();
    }

    public static void updateAccessControl(IAccessControlled doc) throws SelfServiceException {
        CaseService.CaseEngine().updateAccessControl(doc);
    }

    public static void createAccessControlEntry(AccessControl acl) throws SelfServiceException {
        CaseService.CaseEngine().createAccessControlEntry(acl);
    }

    public static List<BaseCase> getCasesByParentId(String parentId) throws SelfServiceException {
        return CaseService.CaseEngine().getCasesByParentId(parentId);
    }

    public static void updateCaseStatus(BaseCase bc) throws SelfServiceException {
        CaseService.CaseEngine().updateCaseStatus(bc);
    }
}

