/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.routing;

import is.hugvit.log.Log;
import java.util.List;
import net.gopro.broker.client.BrokerClientService;
import net.gopro.broker.client.data.DocumentType;
import net.gopro.broker.client.data.RoutingStatus;
import net.gopro.broker.client.data.types.RoutingStatusType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.selfservice.IQueueEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.gopro.Endpoint;
import net.gopro.selfservice.data.routing.BrokerRelationEntry;
import net.gopro.selfservice.exceptions.GoProDataStoreException;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.QueueService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.StringUtil;

public class BrokerRouter {
    private static final String BASE = "services/BrokerService";
    private static Log logger;

    public static synchronized void processCaseRelations(Log log) throws SelfServiceException, GoProDataStoreException {
        logger = log;
        List<BrokerRelationEntry> routingQueue = QueueService.getBrokerRelations(IQueueEngine.BrokerDocumentType.CASE, IQueueEngine.BrokerRelationStatus.PENDING);
        if (routingQueue != null && routingQueue.size() > 0) {
            log.info("Cases waiting confirmation from Broker: " + routingQueue.size());
            List<Organization> oList = ConfigService.getOrganizations();
            for (BrokerRelationEntry entry : routingQueue) {
                if (!BrokerRouter.isOrganizationEnabled(oList, entry.getOrganizationId())) continue;
                Organization org = (Organization)BaseDocumentUtil.getDocumentFromList(entry.getOrganizationId(), oList);
                try {
                    entry.incrementIterationCount();
                    String transactionId = entry.getTransactionId();
                    String serviceUrl = BrokerRouter.getServiceUrl(org);
                    BrokerClientService service = new BrokerClientService(serviceUrl);
                    RoutingStatus status = service.getRoutingStatus(transactionId);
                    if (status == null || !RoutingStatusType.FINISHED.equals(status.getStatus())) continue;
                    DocumentType caseDoc = null;
                    for (DocumentType doc : status.getDocuments().getDocumentTypes()) {
                        if (!entry.getId().equals(doc.getDocumentId())) continue;
                        caseDoc = doc;
                        break;
                    }
                    if (caseDoc == null) {
                        log.error("The Case is marked delivered, but no reference to it was included in the Broker message.");
                        continue;
                    }
                    entry.setGoproId(caseDoc.getDestinationId());
                    entry.setCompleted(true);
                    BaseCase bc = CaseService.getCase(caseDoc.getDocumentId());
                    bc.setGoProId(caseDoc.getDestinationId());
                    if (StringUtil.isValid(caseDoc.getCaseNumber())) {
                        bc.setGoProCaseNumber(caseDoc.getCaseNumber());
                    }
                    QueueService.updateDocumentRelation(bc);
                }
                catch (GoProDataStoreException ex) {
                    throw ex;
                }
                catch (GdfServiceException ex) {
                    throw new GoProDataStoreException((Exception)((Object)ex));
                }
                finally {
                    QueueService.updateBrokerRelation(entry);
                }
            }
        }
    }

    public static synchronized void processDocumentRelations(Log log) throws SelfServiceException, GoProDataStoreException {
        logger = log;
        List<BrokerRelationEntry> routingQueue = QueueService.getBrokerRelations(IQueueEngine.BrokerDocumentType.SUBDOCUMENT, IQueueEngine.BrokerRelationStatus.PENDING);
        if (routingQueue != null && routingQueue.size() > 0) {
            log.info("Documents waiting confirmation from Broker: " + routingQueue.size());
            List<Organization> oList = ConfigService.getOrganizations();
            for (BrokerRelationEntry entry : routingQueue) {
                if (!BrokerRouter.isOrganizationEnabled(oList, entry.getOrganizationId())) continue;
                Organization org = (Organization)BaseDocumentUtil.getDocumentFromList(entry.getOrganizationId(), oList);
                try {
                    entry.incrementIterationCount();
                    String transactionId = entry.getTransactionId();
                    String serviceUrl = BrokerRouter.getServiceUrl(org);
                    BrokerClientService service = new BrokerClientService(serviceUrl);
                    RoutingStatus status = service.getRoutingStatus(transactionId);
                    if (status == null || !RoutingStatusType.FINISHED.equals(status.getStatus())) continue;
                    DocumentType subDoc = null;
                    for (DocumentType doc : status.getDocuments().getDocumentTypes()) {
                        if (!entry.getId().equals(doc.getDocumentId())) continue;
                        subDoc = doc;
                        break;
                    }
                    if (subDoc == null) {
                        log.error("The sub document is marked delivered, but no reference to it was included in the Broker message.");
                        continue;
                    }
                    entry.setGoproId(subDoc.getDestinationId());
                    entry.setCompleted(true);
                    SubDocument ss = CaseService.getSubDocument(subDoc.getDocumentId(), false);
                    ss.setGoProId(subDoc.getDestinationId());
                    QueueService.updateDocumentRelation(ss);
                }
                catch (GoProDataStoreException ex) {
                    throw ex;
                }
                catch (GdfServiceException ex) {
                    throw new GoProDataStoreException((Exception)((Object)ex));
                }
                finally {
                    QueueService.updateBrokerRelation(entry);
                }
            }
        }
    }

    private static final String getServiceUrl(Organization org) throws GoProDataStoreException {
        Endpoint endpoint = org.getEndpoint();
        if (endpoint == null) {
            throw new GoProDataStoreException("The Organization Endpoint is missing");
        }
        return endpoint.getHostname() + BASE + "?wsdl";
    }

    private static final boolean isOrganizationEnabled(List<Organization> list, String organizationId) {
        Organization org;
        BaseDocument doc = BaseDocumentUtil.getDocumentFromList(organizationId, list);
        return doc instanceof Organization && (org = (Organization)doc).isEnabled() && !org.isDeleted();
    }
}

