/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.portal;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.AccessControl;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.Memo;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.DocumentSecurityException;
import net.gopro.selfservice.pages.BasePage;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.LogService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.DocumentSecurityUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Element;

public class MemoPage
extends BasePage {
    public static final String pageName = "memo.html";

    @Override
    public void doGet(WebContext context) throws BirdException {
        boolean isValidRequest = false;
        String memoId = context.getRequest().getParameter("id");
        try {
            SubDocument doc;
            if (StringUtil.isValid(memoId) && (doc = CaseService.getSubDocument(memoId, false)) != null && doc instanceof Memo) {
                User currentUser = this.getCurrentUser(context);
                DocumentSecurityUtil.validatePermission(doc, currentUser, AccessControl.Permission.READ);
                BaseCase bc = CaseService.getCase(doc.getCaseId());
                if (bc != null) {
                    boolean isEditable = DocumentSecurityUtil.getDocumentPermission(AccessControl.Permission.WRITE, currentUser, doc);
                    Element el = doc.getXml();
                    el.addAttribute("edit", String.valueOf(isEditable));
                    if (doc.isFromGoPro()) {
                        Organization org = ConfigService.getOrganization(bc.getOrganizationId());
                        String caseWorkerTitle = LocaleUtil.getResourceBundle("portal.common", context.getRequest()).getString("sub.caseworker") + " " + org.getSubject();
                        el.addElement("author").setText(caseWorkerTitle);
                    } else if (!currentUser.getId().equals(doc.getCreatedById())) {
                        User author = UserService.getUser(doc.getCreatedById());
                        if (author != null) {
                            el.addElement("author").setText(author.getFullname());
                        }
                    } else {
                        el.addElement("author").setText(currentUser.getFullname());
                    }
                    this.dataroot.add(el);
                    isValidRequest = true;
                    int otherCount = bc.getResponseCount();
                    this.dataroot.addAttribute("othercount", String.valueOf(otherCount));
                    this.dataroot.add(bc.getXml());
                }
            }
            if (!isValidRequest) {
                this.redirect(context, "mycases.html");
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (DocumentSecurityException ex) {
            AuditLogEntry entry = new AuditLogEntry(memoId, AuditLogEntry.DataType.MEMO, AuditLogEntry.Action.ILLEGAL_DOCUMENT_ACCESS);
            try {
                LogService.createLogEntry(entry);
            }
            catch (SelfServiceException sex) {
                throw new BirdException((Exception)sex);
            }
            log.warn(ex.getMessage());
            this.redirect(context, "mycases.html");
        }
    }

    @Override
    public void doPost(WebContext context) throws BirdException {
    }
}

