/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.portal;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.SelfServicePrincipal;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.Message;
import net.gopro.selfservice.data.Task;
import net.gopro.selfservice.pages.BasePage;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.services.MessageService;
import net.gopro.selfservice.services.TaskService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Element;

public class HomePage
extends BasePage {
    private static final boolean isTasksEnabled = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("tasks.enabled"));
    private static final int MAX_RECORDS = 10;
    private static final int MAX_SUBJECT = 30;
    public static final String pageName = "home.html";

    @Override
    public void doGet(WebContext context) throws BirdException {
        SelfServicePrincipal p = this.getPrincipal(context);
        try {
            List<BaseCase> caseList = CaseService.getCases(p.getUserId());
            BaseDocumentUtil.removeDeletedDocuments(caseList);
            this.showCaseList(caseList, 10);
            List<Message> messageList = MessageService.getMessages(p.getUserId());
            BaseDocumentUtil.removeDeletedDocuments(messageList);
            this.showList(messageList, 10);
            if (isTasksEnabled) {
                List<Task> taskList = TaskService.getTasksByResponsibleUser(p.getUserId());
                BaseDocumentUtil.removeDeletedDocuments(taskList);
                this.showTaskList(taskList, 10);
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    public void doPost(WebContext context) throws BirdException {
    }

    @Override
    protected void showList(Collection<? extends BaseDocument> list, int maxRecords) throws BirdException {
        Iterator<? extends BaseDocument> it = list.iterator();
        for (int counter = 0; it.hasNext() && counter < maxRecords; ++counter) {
            BaseDocument doc = it.next();
            Element el = doc.getXml();
            if (doc instanceof BaseCase) {
                Dom4JUtil.addElement(el, "subject_short", StringUtil.shortenText(((BaseCase)doc).getSubject(), 30));
            } else if (doc instanceof Message) {
                Dom4JUtil.addElement(el, "subject_short", StringUtil.shortenText(((Message)doc).getSubject(), 30));
            }
            this.dataroot.add(el);
        }
    }

    protected void showTaskList(List<Task> list, int maxRecords) throws SelfServiceException {
        Iterator<Task> it = list.iterator();
        for (int counter = 0; it.hasNext() && counter < maxRecords; ++counter) {
            Task task = it.next();
            this.dataroot.add(task.getXml());
        }
    }

    protected void showCaseList(Collection<? extends BaseDocument> list, int maxRecords) throws BirdException, SelfServiceException {
        List<FormTemplate> formTemplateList = FormService.getFormTemplates();
        Iterator<? extends BaseDocument> it = list.iterator();
        for (int counter = 0; it.hasNext() && counter < maxRecords; ++counter) {
            BaseDocument doc = it.next();
            Element el = this.getXmlElement(doc, formTemplateList);
            Dom4JUtil.addElement(el, "subject_short", StringUtil.shortenText(((BaseCase)doc).getSubject(), 30));
            this.dataroot.add(el);
        }
    }

    private Element getXmlElement(BaseDocument doc, List<FormTemplate> templateList) {
        FormTemplate ft;
        Element el = doc.getXml();
        if (doc instanceof FormCase && (ft = (FormTemplate)BaseDocumentUtil.getDocumentFromList(((FormCase)doc).getFormtemplateId(), templateList)) != null && ft.isDateRestricted()) {
            DateFormat df = LocaleUtil.getTimeFormat();
            el.addElement("is_deadline").setText("true");
            el.addElement("is_expired").setText(String.valueOf(!ft.isWithinDateRestriction()));
            el.addElement("deadline").setText(df.format(ft.getDateValidTo()));
        }
        return el;
    }
}

