/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.communications.Messenger;
import net.gopro.selfservice.data.SimpleMessage;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.excel.ExcelData;
import net.gopro.selfservice.excel.ExcelDataRow;
import net.gopro.selfservice.excel.ExcelWriter;
import net.gopro.selfservice.exceptions.CommunicationException;
import net.gopro.selfservice.exceptions.MessageException;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.filters.UserFilter;
import net.gopro.selfservice.pages.admin.WebBaseList;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Element;

public class WebUserList
extends WebBaseList {
    @Override
    public void doGet(WebContext context) throws BirdException {
        super.doGet(context);
        boolean isAdminActivation = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("registration.administrator.confirmation"));
        this.getRootElement().addAttribute("activation", String.valueOf(isAdminActivation));
        if (!this.isFilter()) {
            // empty if block
        }
        Element el = this.getStaticElement();
        for (String s : this.getAlphabet(context.getSession().getLocale())) {
            el.addElement("char").setText(s);
        }
    }

    public void doPost(WebContext context) throws BirdException {
        int confirmedCount = 0;
        try {
            String[] ids = context.getRequest().getParameterValues("user_id");
            if (ids != null && ids.length > 0) {
                ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages");
                String subject = rb.getString("user.confirmation.subject");
                String body = rb.getString("user.confirmation.body");
                for (String userId : ids) {
                    User user = UserService.getUser(userId);
                    user.setVerified(true);
                    UserService.updateUser(user);
                    Messenger.sendMessage(user, new SimpleMessage(subject, body), User.Communications.EMAIL, false);
                    ++confirmedCount;
                }
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (UserException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (CommunicationException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (MessageException ex) {
            throw new BirdException((Exception)ex);
        }
        String params = "filter=true&filterkey=unconfirmed&filtervalue=true&confirmcount=" + confirmedCount;
        context.setRedirectPage("ss:userlist", params);
    }

    @Override
    protected void doDelete(WebContext context, String documentId) throws BirdException {
        try {
            User user = UserService.getUser(documentId);
            if (user != null && !user.isInRole("A2AAC04696D89CBC6C56EF934F892410")) {
                UserService.deleteUser(user.getId());
            }
            context.setRedirectURL(context.getRequest().getHeader("Referer"));
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (UserException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    @Override
    protected void doFilter(WebContext context, String filter, String key) throws BirdException {
        try {
            boolean isExcel;
            List<User> userList;
            UserFilter userFilter;
            if ("letter".equals(filter) && StringUtil.isValid(key)) {
                userFilter = new UserFilter();
                if (!"all".equals(key)) {
                    userFilter.setLetterStartsWith(Character.valueOf(key.charAt(0)));
                }
                userList = UserService.getUsers(userFilter);
                BaseDocumentUtil.removeDeletedDocuments(userList);
                this.showList(userList);
            } else if ("search".equals(filter) && StringUtil.isValid(key)) {
                userFilter = new UserFilter();
                userFilter.setSearchString(key);
                userList = UserService.getUsers(userFilter);
                BaseDocumentUtil.removeDeletedDocuments(userList);
                this.showList(userList);
            } else if ("unconfirmed".equals(filter)) {
                userFilter = new UserFilter();
                userFilter.setVerifiedStatus(UserFilter.VerifiedStatus.NOT_VERIFIED);
                userList = UserService.getUsers(userFilter);
                BaseDocumentUtil.removeDeletedDocuments(userList);
                this.showList(userList);
            }
            boolean bl = isExcel = context.getRequest().getParameter("excel") != null;
            if (isExcel) {
                ResourceBundle rb = LocaleUtil.getResourceBundle("admin.admin", context.getSession().getLocale());
                ExcelData excel = new ExcelData(rb.getString("users.title"));
                excel.setSheetName(rb.getString("users.title"));
                ArrayList<ExcelDataRow> rl = new ArrayList<ExcelDataRow>();
                rl.add(new ExcelDataRow("fullname", rb.getString("user.fullname")));
                rl.add(new ExcelDataRow("username", rb.getString("user.username")));
                rl.add(new ExcelDataRow("email", rb.getString("user.email")));
                rl.add(new ExcelDataRow("mobilephone", rb.getString("user.mobile")));
                rl.add(new ExcelDataRow("homephone", rb.getString("user.phone")));
                rl.add(new ExcelDataRow("created", rb.getString("list.created"), ExcelDataRow.RowType.DATE));
                List excelList = this.getRootElement().selectNodes("//user", "fullname");
                excel.loadFromXml(rl, excelList);
                ExcelWriter.write(context, excel);
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    protected List<String> getAlphabet(Locale locale) {
        ArrayList<String> list = new ArrayList<String>();
        for (char i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            list.add(Character.valueOf(i).toString());
        }
        if ("is".equals(locale.getLanguage())) {
            char[] ice;
            for (char c : ice = new char[]{'\u00c1', '\u00c9', '\u00cd', '\u00d3', '\u00da', '\u00dd', '\u00d6', '\u00c6', '\u00de'}) {
                list.add(Character.valueOf(c).toString());
            }
            Collator icelandicCollator = Collator.getInstance(new Locale("is_IS"));
            Collections.sort(list, icelandicCollator);
        }
        return list;
    }
}

