/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdFile;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.gopro.selfservice.FormTemplateFactory;
import net.gopro.selfservice.IPDFSigningProvider;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.FormGuidance;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateExtras;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.data.GoProFormTemplate;
import net.gopro.selfservice.data.ListItem;
import net.gopro.selfservice.data.LotusFormTemplate;
import net.gopro.selfservice.data.MessageTemplate;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SecondaryForm;
import net.gopro.selfservice.data.StatusList;
import net.gopro.selfservice.data.StatusListItem;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.exceptions.FormException;
import net.gopro.selfservice.exceptions.FormTemplateException;
import net.gopro.selfservice.exceptions.TargetGroupException;
import net.gopro.selfservice.forms.util.FormsUtil;
import net.gopro.selfservice.pdf.FOPTransformer;
import net.gopro.selfservice.pdf.PDFProperties;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.services.TargetgroupService;
import net.gopro.selfservice.util.AdminUtil;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.BirdUtil;
import net.gopro.selfservice.util.FormQueryUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.ModuleHelper;
import net.gopro.selfservice.util.SignatureUtil;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebFormTemplate
extends WebForm {
    public WebFormTemplate() {
        this.add(new Field("name", true));
        this.add(new Field("description"));
        this.add(new Field("category"));
        this.add(new Field("formtype", true));
        this.add(new Field("is-visible", 2));
        this.add(new Field("is-internal-xsl", 2));
        this.add(new Field("is-memo-allowed", 2));
        this.add(new Field("is-file-allowed", 2));
        this.add(new Field("is-date-restricted", 2));
        this.add(new Field("is-viewfilter", 2));
        this.add(new Field("is-subject-preserved", 2));
        this.add(new Field("is-resend", 2));
        this.add(new Field("is-signature-required", 2));
        this.add(new Field("is-personal-sensitive", 2));
        this.add(new Field("from-date", 4));
        this.add(new Field("from-hour", 1));
        this.add(new Field("from-minute", 1));
        this.add(new Field("to-date", 4));
        this.add(new Field("to-hour", 1));
        this.add(new Field("to-minute", 1));
        this.add(new Field("from-date-string", 0));
        this.add(new Field("to-date-string", 0));
        this.add(new Field("resend-status", 0));
        this.add(new Field("organizations", 5));
        this.add(new Field("statuses", 5));
        this.add(new Field("min-attachments", 1));
        this.add(new Field("custom-class"));
        this.add(new Field("restriction", 1));
        this.add(new Field("file1", 6));
        this.add(new Field("file2", 6));
        this.add(new Field("file3", 6));
        this.add(new Field("message-id"));
        this.add(new Field("gopro-alias"));
        this.add(new Field("gopro-agent"));
        this.add(new Field("jsfile"));
        this.add(new Field("targetgroup"));
        this.add(new Field("pdf-version", 0));
        this.add(new Field("is-payment-required", 2));
        this.add(new Field("payment-currency", 0));
        this.add(new Field("payment-amount", 1));
        this.add(new Field("is-secondary-enabled", 2));
        this.add(new Field("secondary-handling", 1));
        this.add(new Field("secondary-payload", 0));
        this.add(new Field("saveaction"));
    }

    public void doGet(WebContext context) throws BirdException {
        super.doGet(context);
        String param = context.getRequest().getParameter("download");
        if (param != null) {
            String templateId = context.getRequest().getParameter("tid");
            String typeParam = context.getRequest().getParameter("type");
            if (typeParam != null && "pdf".equals(typeParam)) {
                String orgId = context.getRequest().getParameter("oid");
                if (templateId != null && orgId != null) {
                    try {
                        this.doPdfDownload(context, templateId, orgId);
                    }
                    catch (Exception exception) {}
                }
            } else {
                String fileId = context.getRequest().getParameter("fid");
                if (templateId != null && fileId != null) {
                    try {
                        this.doDownload(context, templateId, fileId);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void doSave(WebContext context, Form data) throws BirdException {
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", context.getSession().getLocale());
        try {
            FormTemplate ft = null;
            FormTemplateExtras fex = null;
            if (data.isCreate()) {
                ft = FormTemplateFactory.getInstance(data.getString("formtype"));
                fex = new FormTemplateExtras();
            } else if (data.isEdit()) {
                ft = FormService.getFormTemplate(data.getID(), true);
                fex = ft.getExtendedData() == null ? new FormTemplateExtras() : ft.getExtendedData();
            }
            if ((data.isCreate() || data.isEdit()) && ft != null) {
                Object errorMessage;
                boolean isDateRestricted = data.getBoolean("is-date-restricted");
                boolean isInternalXsl = data.getBoolean("is-internal-xsl");
                ft.setSubject(data.getString("name"));
                ft.setCategory(data.getString("category"));
                ft.setDescription(data.getString("description", null));
                ft.setAttachmentVisible(data.getBoolean("is-file-allowed"));
                ft.setMemoVisible(data.getBoolean("is-memo-allowed"));
                ft.setVisible(data.getBoolean("is-visible"));
                ft.setPostSendUsingViewFilter(data.getBoolean("is-viewfilter"));
                ft.setResendEnabled(data.getBoolean("is-resend"));
                ft.setResendStatusId(data.getString("resend-status", null));
                ft.setSignatureRequired(data.getBoolean("is-signature-required"));
                ft.setPersonalSensitive(data.getBoolean("is-personal-sensitive"));
                ft.setRestriction(FormTemplate.Restriction.of(data.getInt("restriction")));
                ft.setSecondaryEnabled(data.getBoolean("is-secondary-enabled"));
                ft.setSecondaryHandling(FormTemplate.SecondaryCaseHandling.of(data.getInt("secondary-handling")));
                ft.setMessageTemplateId(data.getString("message-id"));
                ft.getSecondaryReferences().clear();
                ft.getSecondaryReferences().addAll(this.getSecondaryApplications(data));
                Vector vOrganizations = data.getVector("organizations");
                ft.getOrganizations().clear();
                for (String organizationId : vOrganizations) {
                    Organization org = ConfigService.getOrganization(organizationId);
                    ft.getOrganizations().add(org);
                }
                fex.setGoproAgent(data.getString("gopro-agent", null));
                fex.setGoproAlias(data.getString("gopro-alias", null));
                fex.setRequiredAttachmentCount(data.getInt("min-attachments"));
                fex.setCustomClass(data.getString("custom-class", null));
                fex.setJavascriptFilePath(data.getString("jsfile", null));
                fex.setTargetGroupId(data.getString("targetgroup", null));
                fex.setPdfFoType(FormTemplateExtras.XSLFoType.valueOf(data.getString("pdf-version").toUpperCase()));
                fex.setGoproSubject(data.getBoolean("is-subject-preserved"));
                boolean isPayment = data.getBoolean("is-payment-required");
                fex.setFormFeeAmount(isPayment ? (double)data.getInt("payment-amount") : 0.0);
                fex.setFormFeeCurrency(data.getString("payment-currency"));
                Vector vStatuses = data.getVector("statuses");
                fex.getCaseStatusList().clear();
                if (vStatuses != null && vStatuses.size() > 0) {
                    StatusList statusList = (StatusList)ConfigService.getList("00ED1DFEB2098F050000012274E564AF");
                    for (String statusId : vStatuses) {
                        ListItem item = statusList.getListItem(statusId);
                        if (item == null) continue;
                        fex.getCaseStatusList().add((StatusListItem)item);
                    }
                }
                if (isDateRestricted) {
                    String start = data.getString("from-date");
                    String end = data.getString("to-date");
                    Date dateFrom = this.parseDate(context, start);
                    Date dateTo = this.parseDate(context, end);
                    if (dateFrom != null && dateTo != null) {
                        Calendar calFrom = Calendar.getInstance();
                        Calendar calTo = Calendar.getInstance();
                        calFrom.setTime(dateFrom);
                        calFrom.set(11, data.getInt("from-hour"));
                        calFrom.set(12, data.getInt("from-minute"));
                        calTo.setTime(dateTo);
                        calTo.set(11, data.getInt("to-hour"));
                        calTo.set(12, data.getInt("to-minute"));
                        ft.setDateValidFrom(calFrom.getTimeInMillis());
                        ft.setDateValidTo(calTo.getTimeInMillis());
                        MetaData m = ft.getMetaDataByKey("start-date");
                        if (m != null) {
                            m.setValue(start);
                            m.setDirty(true);
                        } else {
                            ft.getMetadata().add(new MetaData("start-date", start));
                        }
                        m = ft.getMetaDataByKey("end-date");
                        if (m != null) {
                            m.setValue(end);
                            m.setDirty(true);
                        } else {
                            ft.getMetadata().add(new MetaData("end-date", end));
                        }
                    }
                } else {
                    ft.setDateValidFrom(0L);
                    ft.setDateValidTo(0L);
                }
                this.setFormTemplateFiles(ft, context, data);
                FormTemplateFile file = ft.getFormTemplateFile(FormTemplateFile.Tag.DATA);
                if (file != null) {
                    try {
                        double schemaVersion = FormsUtil.getSchemaVersion(file);
                        ft.setSchemaVersion(schemaVersion);
                    }
                    catch (FormException ex) {
                        ex.printStackTrace();
                        errorMessage = rb.getString("form.validate");
                        data.setError((String)errorMessage + "<br/>" + ex.getMessage());
                        return;
                    }
                }
                if (data.isCreate() && ft instanceof GoProFormTemplate && isInternalXsl) {
                    FormsUtil.FormType formType = ft.getSchemaVersion() < 2.0 ? FormsUtil.FormType.GOPRO_FORM_V1 : FormsUtil.FormType.GOPRO_FORM_V2;
                    ft.getTemplateFiles().add(FormsUtil.getInternalXslFile(FormTemplateFile.Tag.READ, formType));
                    ft.getTemplateFiles().add(FormsUtil.getInternalXslFile(FormTemplateFile.Tag.EDIT, formType));
                }
                ft.setExtendedData(fex);
                if (ft instanceof GoProFormTemplate && file != null) {
                    try {
                        FormsUtil.getInstance(ft).validateForm(file);
                        List<MetaData> schemaMetaData = FormsUtil.getSchemaMetadata(file);
                        for (MetaData m : schemaMetaData) {
                            MetaData curr = ft.getMetaDataByKey(m.getKey());
                            if (curr != null) {
                                curr.setValue(m.getValue());
                                curr.setDirty(true);
                                continue;
                            }
                            ft.getMetadata().add(m);
                        }
                    }
                    catch (FormException ex) {
                        ex.printStackTrace();
                        errorMessage = rb.getString("form.validate");
                        data.setError((String)errorMessage + "<br/>" + ex.getMessage());
                        return;
                    }
                }
                if (data.isCreate()) {
                    FormService.createFormTemplate(ft);
                } else if (data.isEdit()) {
                    FormService.updateFormTemplate(ft);
                }
            }
            if ("save".equals(data.getString("saveaction"))) {
                context.setRedirectPage("ss:formtemplate", "edit&id=" + ft.getId() + "&reload=true");
            } else {
                context.setRedirectPage("ss:formtemplatelist");
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (FormTemplateException ex) {
            data.setError(ex.getMessage());
        }
        catch (IOException ex) {
            data.setError(ex.getMessage());
        }
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        Element el = context.getRootElement().addElement("static");
        try {
            Class[] classTypes;
            String isLocalization = SelfServiceEngine.getConfig("goproforms.translations");
            if (isLocalization != null && "true".equals(isLocalization)) {
                el.addElement("translations-enabled").setText("true");
            } else {
                el.addElement("translations-enabled").setText("false");
            }
            String isPayment = SelfServiceEngine.getConfig("goproforms.payments");
            el.addElement("payments-enabled").setText(isPayment != null && "true".equalsIgnoreCase(isPayment) ? "true" : "false");
            List<Organization> organizationList = ConfigService.getOrganizations();
            BaseDocumentUtil.removeDeletedDocuments(organizationList);
            for (Organization o : organizationList) {
                el.add(o.getXml());
            }
            net.gopro.selfservice.data.List currencyList = ConfigService.getList("7F63541BFEB1F0CE0000014D675180FC");
            Element elCurrencyList = el.addElement("currencies");
            for (ListItem listItem : currencyList.getListItems()) {
                if (listItem.isDeleted()) continue;
                Element elCurr = listItem.getXml();
                elCurr.addElement("default").setText(listItem.getId().equalsIgnoreCase(currencyList.getDefaultId()) ? "true" : "false");
                elCurrencyList.add(elCurr);
            }
            net.gopro.selfservice.data.List caseStatusList = ConfigService.getList("00ED1DFEB2098F050000012274E564AF");
            for (ListItem item : caseStatusList.getListItems()) {
                if (item.isDeleted()) continue;
                el.add(item.getXml());
            }
            Element element = el.addElement("templatetypes");
            for (Class clazz : classTypes = new Class[]{GoProFormTemplate.class, LotusFormTemplate.class}) {
                Element cel = element.addElement("type");
                cel.setText(clazz.getSimpleName());
                cel.addAttribute("id", clazz.getName());
            }
            List<String> jsfiles = BirdUtil.getCustomFiles(context, "js");
            if (jsfiles.size() > 0) {
                Element elJs = el.addElement("birdfiles");
                for (String string : jsfiles) {
                    elJs.addElement("file").setText("files/" + string);
                }
            }
            List<FormTemplate> formTemplates = FormService.getFormTemplates();
            BaseDocumentUtil.removeDeletedDocuments(formTemplates);
            if (formTemplates.size() > 1) {
                Element elSec = el.addElement("secondaries");
                for (FormTemplate ft : formTemplates) {
                    Element els = elSec.addElement("form");
                    els.addAttribute("id", ft.getId());
                    els.setText(ft.getSubject());
                }
            }
            List<TargetGroup> targetGroups = TargetgroupService.getTargetGroups();
            if (data.isCreate()) {
                BaseDocumentUtil.removeDeletedDocuments(targetGroups);
            } else {
                FormTemplate formTemplate = FormService.getFormTemplate(data.getID(), false);
                if (formTemplate.getExtendedData() != null && StringUtil.isValid(formTemplate.getExtendedData().getTargetGroupId())) {
                    Iterator<TargetGroup> it = targetGroups.iterator();
                    while (it.hasNext()) {
                        TargetGroup tg = it.next();
                        if (!tg.isDeleted() || tg.getId().equals(formTemplate.getExtendedData().getTargetGroupId())) continue;
                        it.remove();
                    }
                } else {
                    BaseDocumentUtil.removeDeletedDocuments(targetGroups);
                }
            }
            if (targetGroups.size() > 0) {
                for (TargetGroup tg : targetGroups) {
                    el.add(tg.getXml());
                }
            }
            List<MessageTemplate> list = ConfigService.getMessageTemplates();
            BaseDocumentUtil.removeDeletedDocuments(list);
            if (list.size() > 0) {
                Hashtable htmt = new Hashtable();
                for (MessageTemplate mt : list) {
                    if (htmt.containsKey(mt.getCategoryName())) {
                        ((List)htmt.get(mt.getCategoryName())).add(mt);
                        continue;
                    }
                    ArrayList<MessageTemplate> list2 = new ArrayList<MessageTemplate>();
                    list2.add(mt);
                    htmt.put(mt.getCategoryName(), list2);
                }
                Iterator<FormGuidance> messageCategoryKeys = htmt.keys();
                Element elMTemplates = el.addElement("messagetemplates");
                while (messageCategoryKeys.hasMoreElements()) {
                    String category = (String)messageCategoryKeys.nextElement();
                    Element elmc = elMTemplates.addElement("category");
                    elmc.addAttribute("title", category);
                    List mcList = (List)htmt.get(category);
                    for (MessageTemplate mt : mcList) {
                        Element elmm = elmc.addElement("item");
                        elmm.addAttribute("id", mt.getId());
                        elmm.setText(mt.getTitle());
                    }
                }
            }
            if (data.isEdit()) {
                FormTemplate ft;
                ft = FormService.getFormTemplate(data.getID(), true);
                for (FormTemplateFile ftf : ft.getTemplateFiles()) {
                    el.add(ftf.getXml());
                }
                for (FormGuidance fg : ft.getGuidances()) {
                    el.add(fg.getXml());
                }
                int order = 1;
                Element statusEl = el.addElement("case-status");
                LinkedList<StatusListItem> statusList = ft.getExtendedData().getCaseStatusList();
                for (StatusListItem item : statusList) {
                    Element sel = item.getXml();
                    sel.addAttribute("order", "" + order++);
                    statusEl.add(sel);
                }
                List<SecondaryForm> secondaryReferences = ft.getSecondaryReferences();
                for (SecondaryForm sf : secondaryReferences) {
                    ListItem listItem;
                    BaseDocument bd = BaseDocumentUtil.getDocumentFromList(sf.getTemplateId(), formTemplates);
                    if (bd != null) {
                        sf.setStatusName(((FormTemplate)bd).getSubject());
                    }
                    if ((listItem = caseStatusList.getListItem(sf.getStatusId())) != null) {
                        sf.setStatusName(listItem.getSubject());
                    }
                    el.add(sf.getXml());
                }
            }
            boolean isSigning = ModuleHelper.isClassAvailable(SelfServiceEngine.getConfig(IPDFSigningProvider.class.getName()));
            el.addElement("signing").setText(Boolean.toString(isSigning));
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (TargetGroupException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        super.queryOpen(context, data);
        try {
            if (data.isOpen() || data.isEdit()) {
                FormTemplateExtras fex;
                FormTemplate ft = FormService.getFormTemplate(data.getID(), true);
                if (ft == null) return false;
                data.put("name", ft.getSubject());
                data.put("category", ft.getCategory());
                data.put("description", ft.getDescription());
                data.put("formtype", ft.getClass().getSimpleName());
                data.put("is-internal-xsl", (Object)true);
                data.put("is-visible", (Object)ft.isVisible());
                data.put("is-personal-sensitive", (Object)ft.isPersonalSensitive());
                data.put("is-memo-allowed", (Object)ft.isMemoVisible());
                data.put("is-file-allowed", (Object)ft.isAttachmentVisible());
                data.put("is-date-restricted", (Object)ft.isDateRestricted());
                data.put("is-viewfilter", (Object)ft.isPostSendUsingViewFilter());
                data.put("is-resend", (Object)ft.isResendEnabled());
                data.put("resend-status", ft.getResendStatusId());
                data.put("restriction", ft.getRestriction().getCode());
                data.put("is-signature-required", (Object)ft.isSignatureRequired());
                data.put("message-id", ft.getMessageTemplateId());
                data.put("is-secondary-enabled", (Object)ft.isSecondaryEnabled());
                data.put("secondary-handling", ft.getSecondaryHandling().getCode());
                data.put("organizations", BaseDocumentUtil.getCollectionIds(ft.getOrganizations()));
                if (ft.isDateRestricted()) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(ft.getDateValidFrom());
                    data.put("from-hour", cal.get(11));
                    data.put("from-minute", cal.get(12));
                    cal.setTimeInMillis(ft.getDateValidTo());
                    data.put("to-hour", cal.get(11));
                    data.put("to-minute", cal.get(12));
                    MetaData mStart = ft.getMetaDataByKey("start-date");
                    MetaData mEnd = ft.getMetaDataByKey("end-date");
                    if (mStart != null && mEnd != null) {
                        data.put("from-date-string", mStart.getValue());
                        data.put("to-date-string", mEnd.getValue());
                    } else {
                        DateFormat df = LocaleUtil.getDateFormat();
                        data.put("from-date-string", df.format(new Date(ft.getDateValidFrom())));
                        data.put("to-date-string", df.format(new Date(ft.getDateValidTo())));
                    }
                }
                if ((fex = ft.getExtendedData()) != null) {
                    data.put("gopro-alias", fex.getGoproAlias());
                    data.put("gopro-agent", fex.getGoproAgent());
                    data.put("min-attachments", fex.getRequiredAttachmentCount());
                    data.put("custom-class", fex.getCustomClass());
                    data.put("jsfile", fex.getJavascriptFilePath());
                    data.put("targetgroup", fex.getTargetGroupId());
                    data.put("pdf-version", fex.getPdfFoType().toString().toLowerCase());
                    data.put("is-subject-preserved", (Object)fex.isGoproSubject());
                    data.put("payment-currency", fex.getFormFeeCurrency());
                    data.put("payment-amount", Double.valueOf(fex.getFormFeeAmount()).intValue());
                    data.put("is-payment-required", (Object)(fex.getFormFeeAmount() > 0.0 ? 1 : 0));
                    data.put("statuses", BaseDocumentUtil.getCollectionIds(fex.getCaseStatusList()));
                }
            } else if (data.isCreate()) {
                net.gopro.selfservice.data.List caseStatusList = ConfigService.getList("00ED1DFEB2098F050000012274E564AF");
                MetaData metaNotSubmitted = caseStatusList.getMetaDataByKey("caselist.notsubmitted");
                MetaData metaSubmitted = caseStatusList.getMetaDataByKey("caselist.submitted");
                if (metaNotSubmitted != null && metaSubmitted != null) {
                    ListItem listItemNotSubmitted = caseStatusList.getListItem(metaNotSubmitted.getValue());
                    ListItem listItemSubmitted = caseStatusList.getListItem(metaSubmitted.getValue());
                    if (listItemNotSubmitted != null && listItemSubmitted != null) {
                        Vector<String> defaultCaseStatuses = new Vector<String>(Arrays.asList(listItemNotSubmitted.getId(), listItemSubmitted.getId()));
                        data.put("statuses", defaultCaseStatuses);
                    }
                }
            }
            List<Organization> organizationList = ConfigService.getOrganizations();
            BaseDocumentUtil.removeDeletedDocuments(organizationList);
            if (organizationList != null && organizationList.size() != 0) return true;
            ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", context.getSession().getLocale());
            data.setError(rb.getString("form.orgs"));
            return true;
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public boolean querySave(WebContext context, Form data) throws BirdException {
        String[] booleanKeys;
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.exception", context.getSession().getLocale());
        if (data.getBoolean("is-date-restricted")) {
            DateFormat df = LocaleUtil.getDateFormat();
            String[] ddf = this.parseDate(context, context.getRequest().getParameter("from-date"));
            Date ddt = this.parseDate(context, context.getRequest().getParameter("to-data"));
            if (ddf != null) {
                data.put("from-date-string", df.format((Date)ddf));
            }
            if (ddt != null) {
                data.put("to-date-string", df.format(ddt));
            }
        }
        data.put("message-id", data.getString("message-id"));
        data.put("statuses", data.getVector("statuses"));
        for (String key : booleanKeys = new String[]{"is-internal-xsl", "is-memo-allowed", "is-file-allowed", "is-secondary-enabled", "is-visible", "is-subject-preserved", "is-resend", "is-payment-required", "is-personal-sensitive"}) {
            data.put(key, (Object)data.getBoolean(key));
        }
        if (data.getBoolean("is-secondary-enabled")) {
            if (!ModuleHelper.isValidLicense("Secondary Applications Module")) {
                data.setError("You cannot use the secondary forms functionality.  No license for that module was found or the license is no longer valid!");
                return false;
            }
            List<SecondaryForm> secList = this.getSecondaryApplications(data);
            if (secList.isEmpty()) {
                data.setError("You must select at least 1 secondary application, when the secondary option is enabled.");
                return false;
            }
        }
        try {
            int amount = data.getInt("payment-amount");
            if (data.getBoolean("is-payment-required") && amount <= 0) {
                data.setError("Payment amount must be greater than 0 " + data.getString("payment-currency"));
                return false;
            }
        }
        catch (NumberFormatException ex) {
            data.setError("Payment amount must only contain numbers");
            return false;
        }
        if (data.getString("name").equals("")) {
            data.setError(rb.getString("form.name"));
            return false;
        }
        if (data.getString("category").equals("")) {
            data.setError(rb.getString("form.category"));
            return false;
        }
        Vector v = data.getVector("organizations");
        if (v == null || v.size() == 0) {
            data.setError(rb.getString("form.organization"));
            return false;
        }
        Vector s = data.getVector("statuses");
        if (s == null || s.size() < 2) {
            data.setError(rb.getString("form.statuses"));
            return false;
        }
        if (data.isCreate()) {
            int fileCount = 0;
            for (int i = 1; i <= 3; ++i) {
                String filename = "file" + i;
                InputStream is = null;
                try {
                    is = data.getInputStream(filename);
                    if (is == null) continue;
                    ++fileCount;
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (fileCount == 0) {
                data.setError(rb.getString("form.filecount"));
                return false;
            }
        }
        return true;
    }

    private List<SecondaryForm> getSecondaryApplications(Form data) {
        ArrayList<SecondaryForm> list = new ArrayList<SecondaryForm>();
        if (data.getBoolean("is-secondary-enabled") == Boolean.TRUE.booleanValue() && data.contains("secondary-payload")) {
            String secondaryRefJson = data.getString("secondary-payload");
            JSONArray arr = new JSONArray(secondaryRefJson);
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject jo = arr.getJSONObject(i);
                list.add(new SecondaryForm(jo.getString("id"), jo.getString("sid"), jo.getInt("limit")));
            }
        }
        return list;
    }

    private void setFormTemplateFiles(FormTemplate ft, WebContext context, Form data) throws IOException {
        for (int i = 1; i <= 3; ++i) {
            String filename = "file" + i;
            String filetype = "filetype" + i;
            String filetag = "filetag" + i;
            InputStream is = data.getInputStream(filename);
            if (is == null) continue;
            Hashtable h = data.getHashtable();
            FormTemplateFile ff = null;
            FormTemplateFile.Tag tag = FormTemplateFile.Tag.valueOf((String)h.get(filetag));
            FormTemplateFile.Type type = FormTemplateFile.Type.valueOf((String)h.get(filetype));
            if (data.isCreate()) {
                ff = new FormTemplateFile();
                ff.setTag(tag);
                ff.setType(type);
            } else {
                ff = ft.getFormTemplateFile(tag);
                ff.setDirty(true);
            }
            ff.setFilename(data.getFilename(filename));
            byte[] stream = IOUtils.toByteArray((InputStream)is);
            ff.setStream(stream);
            if (!data.isCreate()) continue;
            ft.getTemplateFiles().add(ff);
        }
    }

    private Date parseDate(WebContext context, String s) {
        return AdminUtil.parseDateString(s, context.getSession().getLocale());
    }

    private final void doDownload(WebContext context, String templateId, String fileId) throws ServletException {
        try {
            FormTemplateFile file = null;
            FormTemplate ft = FormService.getFormTemplate(templateId, true);
            if (ft != null) {
                file = ft.getFormTemplateFile(fileId);
            }
            if (file != null) {
                HttpServletResponse response = context.getResponseExclusive();
                response.setContentLength(file.getStream().length);
                response.setHeader("Content-Disposition", "attachment; filename=\"" + file.getFilename() + "\"");
                response.setHeader("Pragma", "public");
                response.setHeader("Cache-Control", "private, max-age=15");
                response.getOutputStream().write(file.getStream());
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
        }
        catch (SocketException file) {
        }
        catch (SelfServiceException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    private void doPdfDownload(WebContext context, String templateId, String organizationId) throws ServletException, BirdException {
        block12: {
            try {
                String xpathQuery;
                List<Element> list;
                BirdFile bf;
                FormTemplateFile file = null;
                Organization org = ConfigService.getOrganization(organizationId);
                FormTemplate ft = FormService.getFormTemplate(templateId, true);
                if (ft != null) {
                    file = ft.getFormTemplateFile(FormTemplateFile.Tag.DATA);
                }
                if (file == null || org == null) break block12;
                Document xmlDoc = FormsUtil.createDocument(file.getStream());
                MetaData md = org.getMetaDataByKey("image.id");
                if (md != null && (bf = BirdUtil.getFile(context, md.getValue())) != null) {
                    HttpServletRequest req = context.getRequest();
                    String base = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort();
                    String imagePath = base + context.getRequest().getContextPath() + "/web/files/" + bf.getName() + "/" + bf.getFilename();
                    xmlDoc.getRootElement().addAttribute("IMAGE-LOGO", imagePath);
                }
                if ((list = FormQueryUtil.selectNodes(xmlDoc, xpathQuery = "//SECTIONS/SECTION/FIELDS//VALUE", false)) != null && list.size() > 0) {
                    for (Element el : list) {
                        String val = el.getText();
                        if (val == null || !val.startsWith("[") || !val.endsWith("]")) continue;
                        el.setText("");
                    }
                }
                DateFormat df = LocaleUtil.getTimeFormat();
                xmlDoc.getRootElement().addAttribute("SUBMITTED", df.format(new Date()));
                xmlDoc.getRootElement().addAttribute("ORGANIZATION", org.getSubject());
                xmlDoc.getRootElement().addAttribute("TEMPLATE-ID", ft.getId());
                GoProFormTemplate.GoProFormType formType = ft.getSchemaVersion() < 2.0 ? GoProFormTemplate.GoProFormType.GOPRO_FORM_V1 : GoProFormTemplate.GoProFormType.GOPRO_FORM_V2;
                PDFProperties props = new PDFProperties();
                props.setSubject(ft.getSubject());
                props.setTitle(ft.getSubject());
                FOPTransformer trans = new FOPTransformer(props);
                byte[] pdfStream = trans.transFormToPDF(xmlDoc, ft.getExtendedData().getPdfFoType(), formType);
                if (org.isSigning()) {
                    try {
                        pdfStream = SignatureUtil.signDocument(pdfStream, org);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                HttpServletResponse response = context.getResponseExclusive();
                response.setContentLength(pdfStream.length);
                String filename = ft.getSubject() + ".pdf";
                response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
                response.setHeader("Pragma", "public");
                response.setHeader("Cache-Control", "private, max-age=15");
                response.getOutputStream().write(pdfStream);
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (SocketException file) {
            }
            catch (SelfServiceException ex) {
                throw new ServletException((Throwable)ex);
            }
            catch (IOException ex) {
                throw new ServletException((Throwable)ex);
            }
            catch (FormException ex) {
                throw new ServletException((Throwable)ex);
            }
        }
    }
}

