/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages.admin;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import java.util.Collection;
import net.gopro.selfservice.data.BaseDocument;
import org.dom4j.Element;

public abstract class WebBaseList
extends WebElementBase {
    private String sortKey;
    private Element rootElement;
    private Element staticElement;
    private boolean isFilter = false;

    protected abstract void doDelete(WebContext var1, String var2) throws BirdException;

    protected abstract void doFilter(WebContext var1, String var2, String var3) throws BirdException;

    protected Element getRootElement() {
        return this.rootElement;
    }

    protected Element getStaticElement() {
        return this.staticElement;
    }

    protected String getSortKey() {
        return this.sortKey;
    }

    protected void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    protected boolean isFilter() {
        return this.isFilter;
    }

    protected void showList(Collection<? extends BaseDocument> list) throws BirdException {
        if (this.rootElement == null) {
            throw new BirdException("doGet must call super");
        }
        if (list != null) {
            for (BaseDocument baseDocument : list) {
                this.rootElement.add(baseDocument.getXml());
            }
        }
    }

    protected void showList(Element el, Collection<? extends BaseDocument> list) throws BirdException {
        if (el == null) {
            throw new BirdException("The element cannot be null");
        }
        if (list != null) {
            for (BaseDocument baseDocument : list) {
                el.add(baseDocument.getXml());
            }
        }
    }

    public void doGet(WebContext context) throws BirdException {
        super.doGet(context);
        this.isFilter = false;
        this.rootElement = context.getRootElement().addElement("bird_view");
        this.staticElement = context.getRootElement().addElement("static");
        if (this.sortKey == null) {
            this.sortKey = context.getRequest().getParameter("sort");
        }
        if (this.sortKey != null && !"".equals(this.sortKey)) {
            this.rootElement.addAttribute("sort", this.sortKey);
        } else {
            this.rootElement.addAttribute("sort", "subject");
        }
        if (context.getRequest().getParameter("delete") != null) {
            String documentId = context.getRequest().getParameter("id");
            if (this.isValid(documentId)) {
                this.doDelete(context, documentId);
            }
        } else if (context.getRequest().getParameter("filter") != null) {
            String key = context.getRequest().getParameter("filterkey");
            String value = context.getRequest().getParameter("filtervalue");
            if (this.isValid(key) && this.isValid(value)) {
                this.isFilter = true;
                this.rootElement.addAttribute("filterkey", key);
                this.rootElement.addAttribute("filtervalue", value);
                this.doFilter(context, key, value);
            }
        }
    }

    private boolean isValid(String s) {
        return s != null && !"".equals(s);
    }
}

