/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdSession;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.log.Log;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.SelfServicePrincipal;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.PageUtil;
import org.dom4j.Element;

public abstract class BasePage {
    protected static BirdSession birdSession;
    protected static Log log;
    protected Element dataroot;
    protected ResourceBundle resourceBundle;

    public final synchronized void init(WebContext context, Element root, ResourceBundle rb) throws BirdException {
        if (birdSession == null) {
            birdSession = context.getSession();
        }
        if (log == null) {
            log = birdSession.getLog();
        }
        this.dataroot = root;
        this.resourceBundle = rb;
    }

    public abstract void doGet(WebContext var1) throws BirdException;

    public abstract void doPost(WebContext var1) throws BirdException;

    public void doAction(WebContext context, Form data) throws BirdException {
    }

    public void doDelete(WebContext context, Form data) throws BirdException {
    }

    public void doSave(WebContext context, Form data) throws BirdException {
    }

    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        return true;
    }

    public boolean querySave(WebContext context, Form data) throws BirdException {
        return true;
    }

    public void doXML(WebContext context, Form data) throws BirdException {
    }

    protected final Properties getBirdConfig() {
        return birdSession.getParameters();
    }

    protected final SelfServicePrincipal getPrincipal(WebContext context) throws BirdException {
        return this.getPrincipal(context.getRequest());
    }

    protected final SelfServicePrincipal getPrincipal(HttpServletRequest req) throws BirdException {
        try {
            if (req.getUserPrincipal() == null) {
                return null;
            }
            User user = UserService.getUserByUsername(req.getUserPrincipal().getName());
            if (user != null) {
                return user.getPrincipal();
            }
            return null;
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    protected final User getCurrentUser(WebContext context) throws BirdException {
        return this.getCurrentUser(context.getRequest());
    }

    protected final User getCurrentUser(HttpServletRequest req) throws BirdException {
        try {
            User user = UserService.getUserByUsername(req.getUserPrincipal().getName());
            if (user == null) {
                throw new BirdException("User " + req.getUserPrincipal().getName() + " was not found!");
            }
            return user;
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    protected void showList(Collection<? extends BaseDocument> list) throws BirdException {
        if (list != null) {
            for (BaseDocument baseDocument : list) {
                this.dataroot.add(baseDocument.getXml());
            }
        }
    }

    protected void showList(Collection<? extends BaseDocument> list, int maxRecords) throws BirdException {
        if (list != null) {
            Iterator<? extends BaseDocument> it = list.iterator();
            for (int counter = 0; it.hasNext() && counter < maxRecords; ++counter) {
                BaseDocument doc = it.next();
                this.dataroot.add(doc.getXml());
            }
        }
    }

    protected void showList(Element el, Collection<? extends BaseDocument> list) throws BirdException {
        if (el == null) {
            throw new BirdException("The element cannot be null");
        }
        if (list != null) {
            for (BaseDocument baseDocument : list) {
                el.add(baseDocument.getXml());
            }
        }
    }

    protected void redirect(WebContext context, String pageName) throws BirdException {
        try {
            PageUtil.redirect(context, pageName);
        }
        catch (IOException ex) {
            throw new BirdException((Exception)ex);
        }
    }
}

