/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.pages;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.communications.Messenger;
import net.gopro.selfservice.communications.Translator;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.SimpleMessage;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.CommunicationException;
import net.gopro.selfservice.exceptions.MessageException;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;

public class ActivationPage
extends WebElementBase {
    public void doGet(WebContext context) throws BirdException {
        try {
            User user;
            String userId = context.getRequest().getParameter("id");
            if (StringUtil.isValid(userId) && userId.length() == 32 && (user = UserService.getUser(userId)) != null && !user.isVerified()) {
                user.setVerified(true);
                UserService.updateUser(user);
                context.getRootElement().addElement("status").setText("success");
                this.sendRegistrationEmail(user);
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (UserException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (CommunicationException ex) {
            SelfServiceEngine.getLogger().error("Error sending registration email: ", (Exception)ex);
        }
        catch (MessageException ex) {
            SelfServiceEngine.getLogger().error("Error sending registration email: ", (Exception)ex);
        }
    }

    private final void sendRegistrationEmail(User user) throws CommunicationException, MessageException, SelfServiceException {
        ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages");
        String subject = Translator.translate((BaseDocument)user, rb.getString("register.subject"));
        String message = rb.getString("register.body.activated") + rb.getString("mail.footer");
        message = Translator.translate((BaseDocument)user, message);
        Messenger.sendMessage(user, new SimpleMessage(subject, message), User.Communications.EMAIL, false);
    }
}

