/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl.processors;

import is.hugvit.util.Util;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.gopro.selfservice.IFormQuery;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.exceptions.FormQueryException;
import net.gopro.selfservice.util.FormQueryUtil;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class GoProFormV1QueryProcessor
implements IFormQuery {
    @Override
    public List<Attachment> getAttachments(ApplicationForm form) throws FormQueryException {
        return new ArrayList<Attachment>();
    }

    @Override
    public Hashtable<String, String> getKeyValuePairs(ApplicationForm form) throws FormQueryException {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        try {
            String val;
            String key;
            Document doc = FormQueryUtil.getFormAsDom4JDocument(form);
            String xpathQuery = "//FIELD/VALUE";
            List<Element> nodeList = FormQueryUtil.selectNodes(doc, xpathQuery, true);
            boolean isMulti = false;
            Iterator<Element> it = nodeList.iterator();
            while (it.hasNext()) {
                isMulti = false;
                Element el = it.next();
                key = el.getParent().valueOf("@NAME");
                val = "";
                String xmlType = el.getParent().valueOf("@TYPE");
                if (xmlType != null && (xmlType.equalsIgnoreCase("CHECKBOX") || xmlType.equalsIgnoreCase("LISTBOX") || xmlType.equalsIgnoreCase("RADIO"))) {
                    isMulti = true;
                }
                if (isMulti) {
                    try {
                        val = this.getXmlMultiValue(el.getParent(), key);
                    }
                    catch (Exception exception) {}
                } else {
                    val = el.getText();
                }
                if (!StringUtil.isValid(key) || !StringUtil.isValid(val)) continue;
                ht.put(key, val);
            }
            xpathQuery = "//VALUES/VALUE";
            nodeList = FormQueryUtil.selectNodes(doc, xpathQuery, true);
            for (Element el : nodeList) {
                key = el.valueOf("@KEY");
                val = el.getText();
                if (!StringUtil.isValid(key) || !StringUtil.isValid(val)) continue;
                ht.put(key, val);
            }
            xpathQuery = "//VALUES/SET";
            nodeList = FormQueryUtil.selectNodes(doc, xpathQuery, true);
            for (Element elIndex : nodeList) {
                String index = elIndex.valueOf("@INDEX");
                List valueNodes = elIndex.selectNodes("VALUE");
                Hashtable<String, String> localValues = new Hashtable<String, String>();
                for (Element elValue : valueNodes) {
                    String key2 = elValue.valueOf("@KEY");
                    String val2 = elValue.getText();
                    if (!StringUtil.isValid(key2) || !StringUtil.isValid(val2)) continue;
                    if (localValues.containsKey(key2 = key2 + "-" + index)) {
                        localValues.put(key2, (String)localValues.get(key2) + ", " + val2);
                        continue;
                    }
                    localValues.put(key2, val2);
                }
                ht.putAll(localValues);
            }
            return ht;
        }
        catch (SelfServiceException ex) {
            throw new FormQueryException(ex);
        }
    }

    @Override
    public boolean search(ApplicationForm form, String keyword) throws FormQueryException {
        Hashtable<String, String> h = this.getKeyValuePairs(form);
        Enumeration<String> en = h.elements();
        while (en.hasMoreElements()) {
            String value = en.nextElement();
            if (!value.toLowerCase().contains(keyword.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private String getXmlMultiValue(Element el, String rootName) {
        String xpath = "//FIELD[@NAME='" + rootName + "']/VALUE[@SELECTED='YES']";
        List nodes = el.selectNodes(xpath);
        Iterator it = nodes.iterator();
        Vector<String> items = new Vector<String>();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            items.add(node.getText());
        }
        if (items.size() == 0) {
            return "";
        }
        return Util.expand(items, (String)",");
    }

    @Override
    public Hashtable<String, String> getKeyFields(ApplicationForm form) throws FormQueryException {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        return ht;
    }
}

