/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.gopro.selfservice.ITargetGroupEngine;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.dalc.TargetGroupDalc;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.data.targetgroup.TargetGroupUser;
import net.gopro.selfservice.exceptions.TargetGroupException;
import net.gopro.selfservice.impl.BaseImpl;
import net.gopro.selfservice.util.BaseDocumentUtil;
import org.quartz.SchedulerException;

public class TargetGroupImpl
extends BaseImpl
implements ITargetGroupEngine {
    protected TargetGroupDalc dalc;

    public TargetGroupImpl() throws SelfServiceException {
        this.initialize();
    }

    @Override
    protected void initialize() throws SelfServiceException {
        super.initialize();
        this.dalc = new TargetGroupDalc();
    }

    @Override
    public void createTargetGroup(TargetGroup group) throws TargetGroupException, SelfServiceException {
        this.throwIfNull(group, "Targetgroup is null");
        try {
            this.throwIfNotValid(group.getSubject(), "Title is missing");
            this.throwIfNotValid(group.getGenerator() != null, "The Target group generator is missing");
            this.assertStringLength(group.getSubject(), 255);
            this.assertStringLength(group.getClassName(), 255);
            if (TargetGroup.Generator.CLASS.equals((Object)group.getGenerator())) {
                this.throwIfNotValid(group.getClassName(), "The implementing classname is missing");
            }
            if (TargetGroup.Generator.CONTACTS.equals((Object)group.getGenerator())) {
                this.throwIfNotValid(group.getCompanyId(), "Company Id is missing");
            }
            this.checkDocumentId(group);
            if (group.getUpdateHourInterval() < 1) {
                group.setUpdateHourInterval(1);
            } else if (group.getUpdateHourInterval() > 24) {
                group.setUpdateHourInterval(24);
            }
            this.dalc.createTargetGroup(group);
            this.createMetaData(group, this.dalc);
            if (group.getGenerator().equals((Object)TargetGroup.Generator.MANUAL) || group.getGenerator().equals((Object)TargetGroup.Generator.CONTACTS)) {
                this.updateTargetGroupUsers(group);
            } else if (group.getGenerator().equals((Object)TargetGroup.Generator.CLASS)) {
                try {
                    group.scheduleJob(SelfServiceEngine.getScheduler());
                }
                catch (SchedulerException ex) {
                    throw new SelfServiceException((Exception)((Object)ex));
                }
            }
            this.logAction(group.getId(), AuditLogEntry.DataType.TARGETGROUP, AuditLogEntry.Action.CREATE);
        }
        catch (IllegalArgumentException ex) {
            throw new TargetGroupException(ex);
        }
        catch (SQLException ex) {
            throw new TargetGroupException(ex);
        }
    }

    @Override
    public void deleteTargetGroup(String targetgroupId) throws TargetGroupException, SelfServiceException {
        TargetGroup group = this.getTargetGroup(targetgroupId, false);
        if (group == null) {
            throw new TargetGroupException("Invalid targetgroup Id");
        }
        group.setDeleted(true);
        this.updateTargetGroup(group);
        this.logAction(group.getId(), AuditLogEntry.DataType.TARGETGROUP, AuditLogEntry.Action.DELETE);
    }

    @Override
    public List<TargetGroup> getTargetGroupsByUser(String userId) throws SelfServiceException {
        try {
            return this.dalc.getTargetGroupsByUser(userId);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public TargetGroup getTargetGroup(String targetgroupId, boolean populateUsers) throws TargetGroupException, SelfServiceException {
        try {
            TargetGroup group = this.dalc.getTargetGroup(targetgroupId);
            if (group != null && populateUsers) {
                List<TargetGroupUser> users = this.dalc.getTargetGroupUsers(group.getId());
                group.getGroupUsers().addAll(users);
            }
            this.setMetaData(group, this.dalc);
            return group;
        }
        catch (SQLException ex) {
            throw new TargetGroupException(ex);
        }
    }

    @Override
    public void createTargetGroupUser(TargetGroupUser tgu) throws TargetGroupException, SelfServiceException {
        try {
            this.throwIfNull(tgu, "The targetgroup user cannot be null");
            this.throwIfNotValid(tgu.getTargetGroupId(), "The target group Id is missing");
            this.throwIfNotValid(tgu.getUserId(), "The User Id is invalid");
            TargetGroup group = this.getTargetGroup(tgu.getTargetGroupId(), true);
            this.throwIfNull(group, "The specified targetgroup is invalid");
            List<TargetGroup> userGroups = this.getTargetGroupsByUser(tgu.getUserId());
            BaseDocument doc = BaseDocumentUtil.getDocumentFromList(tgu.getTargetGroupId(), userGroups);
            if (doc == null) {
                group.getGroupUsers().add(tgu);
                this.updateTargetGroupUsers(group);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new TargetGroupException(ex);
        }
    }

    @Override
    public List<TargetGroup> getTargetGroups() throws TargetGroupException {
        try {
            List<TargetGroup> list = this.dalc.getTargetGroups();
            return list;
        }
        catch (SQLException ex) {
            throw new TargetGroupException(ex);
        }
    }

    @Override
    public void updateTargetGroup(TargetGroup group) throws TargetGroupException, SelfServiceException {
        this.throwIfNull(group, "Targetgroup is null");
        try {
            this.throwIfNotValid(group.getSubject(), "Title is missing");
            this.assertStringLength(group.getSubject(), 255);
            this.assertStringLength(group.getClassName(), 255);
            group.setDateModified(new Date().getTime());
            if (group.getUpdateHourInterval() < 1) {
                group.setUpdateHourInterval(1);
            } else if (group.getUpdateHourInterval() > 24) {
                group.setUpdateHourInterval(24);
            }
            if (group.getGenerator().equals((Object)TargetGroup.Generator.CLASS)) {
                this.deleteOldSchedule(group.getId());
            }
            this.dalc.updateTargetGroup(group);
            if (group.getGenerator().equals((Object)TargetGroup.Generator.MANUAL)) {
                this.updateTargetGroupUsers(group);
            }
            this.updateMetaData(group, this.dalc);
            this.logAction(group.getId(), AuditLogEntry.DataType.TARGETGROUP, AuditLogEntry.Action.UPDATE);
            if (group.getGenerator().equals((Object)TargetGroup.Generator.CLASS)) {
                group.scheduleJob(SelfServiceEngine.getScheduler());
            }
        }
        catch (IllegalArgumentException ex) {
            throw new TargetGroupException(ex);
        }
        catch (SQLException ex) {
            throw new TargetGroupException(ex);
        }
        catch (SchedulerException ex) {
            throw new TargetGroupException((Exception)((Object)ex));
        }
    }

    @Override
    public void updateTargetGroupUsers(TargetGroup group) throws SelfServiceException {
        try {
            TargetGroupUser user;
            Set<TargetGroupUser> currentUsers = group.getGroupUsers();
            List<TargetGroupUser> existingUsers = this.dalc.getTargetGroupUsers(group.getId());
            ArrayList<String> existingUserIds = new ArrayList<String>();
            for (TargetGroupUser user2 : existingUsers) {
                existingUserIds.add(user2.getUserId());
            }
            ArrayList<String> currentUserIds = new ArrayList<String>();
            Iterator<TargetGroupUser> it = currentUsers.iterator();
            while (it.hasNext()) {
                user = it.next();
                if (currentUserIds.contains(user.getUserId())) {
                    it.remove();
                    continue;
                }
                currentUserIds.add(user.getUserId());
            }
            it = currentUsers.iterator();
            while (it.hasNext()) {
                user = it.next();
                if (!existingUserIds.contains(user.getUserId())) continue;
                existingUserIds.remove(user.getUserId());
                it.remove();
            }
            this.dalc.updateTargetGroupUsers(group.getId(), currentUsers, existingUserIds);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private void deleteOldSchedule(String targetgroupId) throws SelfServiceException, SchedulerException {
        try {
            TargetGroup group = this.dalc.getTargetGroup(targetgroupId);
            if (group != null) {
                SelfServiceEngine.getScheduler().deleteJob(group.getSubject(), "TargetGroup");
            }
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public boolean isInTargetGroup(String userId, String targetgroupId) throws SelfServiceException {
        try {
            this.throwIfNotValid(userId, "The user Id is invalid");
            this.throwIfNotValid(targetgroupId, "The target group Id is invalid");
            return this.dalc.isInTargetGroup(userId, targetgroupId);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public boolean removeUserFromTargetGroup(String userId, String targetgroupId) throws SelfServiceException {
        try {
            this.throwIfNotValid(userId, "The user Id is invalid");
            this.throwIfNotValid(targetgroupId, "The target group Id is invalid");
            return this.dalc.removeUserFromTargetGroup(userId, targetgroupId);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public boolean addUserToTargetGroup(String userId, String targetgroupId) throws SelfServiceException {
        try {
            this.throwIfNotValid(userId, "The user Id is invalid");
            this.throwIfNotValid(targetgroupId, "The target group Id is invalid");
            return this.dalc.addUserToTargetGroup(userId, targetgroupId);
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }
}

