/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.impl;

import is.hugvit.bird.jaas.security.BirdUserPrincipal;
import is.hugvit.util.UID;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.activation.MimetypesFileTypeMap;
import net.gopro.selfservice.EngineFactory;
import net.gopro.selfservice.ICaseEngine;
import net.gopro.selfservice.ICaseProcessHookIn;
import net.gopro.selfservice.IConfigEngine;
import net.gopro.selfservice.IFormCaseProcessHookIn;
import net.gopro.selfservice.IFormEngine;
import net.gopro.selfservice.IFormQuery;
import net.gopro.selfservice.IQueueEngine;
import net.gopro.selfservice.ITargetGroupEngine;
import net.gopro.selfservice.IUserEngine;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.communications.MessageHelper;
import net.gopro.selfservice.dalc.CaseDalc;
import net.gopro.selfservice.data.AccessControl;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.Case;
import net.gopro.selfservice.data.CaseList;
import net.gopro.selfservice.data.CaseTemplate;
import net.gopro.selfservice.data.CheckoutTicket;
import net.gopro.selfservice.data.CompletedFormDocument;
import net.gopro.selfservice.data.ConfigEntry;
import net.gopro.selfservice.data.Contact;
import net.gopro.selfservice.data.Email;
import net.gopro.selfservice.data.EmailAttachment;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.IAccessControlled;
import net.gopro.selfservice.data.ListItem;
import net.gopro.selfservice.data.Memo;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.StatusList;
import net.gopro.selfservice.data.StatusListItem;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.gopro.RemoteGoPro;
import net.gopro.selfservice.data.routing.RoutingQueueEntry;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.exceptions.CaseException;
import net.gopro.selfservice.exceptions.ConfigException;
import net.gopro.selfservice.exceptions.FormQueryException;
import net.gopro.selfservice.exceptions.HookInException;
import net.gopro.selfservice.exceptions.SaveConflictException;
import net.gopro.selfservice.exceptions.TargetGroupException;
import net.gopro.selfservice.exceptions.UserException;
import net.gopro.selfservice.exceptions.VirusScannerException;
import net.gopro.selfservice.filters.CaseListFilter;
import net.gopro.selfservice.forms.util.FormsUtil;
import net.gopro.selfservice.hookins.SubjectHookin;
import net.gopro.selfservice.impl.BaseImpl;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.services.VirusScanService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.ReferenceNumberGenerator;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CaseImpl
extends BaseImpl
implements ICaseEngine {
    private static final Logger logger = Logger.getLogger(CaseImpl.class);
    private static final String CaseNameHookin = "ComputedCaseNameHookin";
    private static final String UseCaseNamePrefix = "ComputedCaseNamePrefix";
    protected IConfigEngine configEngine;
    protected IUserEngine userEngine;
    protected IFormEngine formEngine;
    protected IQueueEngine queueEngine;
    protected ITargetGroupEngine targetgroupEngine;
    protected CaseDalc dalc;

    public CaseImpl() throws SelfServiceException {
        this.initialize();
    }

    @Override
    protected void initialize() throws SelfServiceException {
        super.initialize();
        this.dalc = new CaseDalc();
        this.configEngine = EngineFactory.getConfigEngine();
        this.userEngine = EngineFactory.getUserEngine();
        this.formEngine = EngineFactory.getFormEngine();
        this.queueEngine = EngineFactory.getQueueEngine();
        this.targetgroupEngine = EngineFactory.getTargetGroupEngine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createCase(BaseCase bc) throws CaseException, SelfServiceException {
        this.throwIfNull(bc, "Case is null");
        try {
            this.throwIfNotValid(bc.getSubject(), "Case subject is missing");
            this.throwIfNotValid(bc.getOrganizationId(), "Case organization is missing");
            if (bc.getSubject().length() > 255) {
                bc.setSubject(bc.getSubject().substring(0, 255));
            }
            this.assertStringLength(bc.getGoProCaseNumber(), 36);
            BirdUserPrincipal userContext = this.getUserContext();
            this.validateAccessControl(bc);
            boolean isCompanyCase = this.isValid(bc.getCompanyId());
            if (bc instanceof FormCase) {
                this.throwIfNotValid(bc.getCreatedById(), "Case owner is missing");
            } else if (bc instanceof Case) {
                boolean isUserCase = this.isValid(bc.getCreatedById());
                boolean isTargetGroupCase = this.isValid(((Case)bc).getTargetGroupId());
                if (!(isUserCase || isTargetGroupCase || isCompanyCase)) {
                    throw new CaseException("Either userId, targetgroupId or companyId must be defined.");
                }
                if (isTargetGroupCase) {
                    TargetGroup tg = this.targetgroupEngine.getTargetGroup(((Case)bc).getTargetGroupId(), false);
                    this.throwIfNull(tg, "The specified targetgroup is invalid");
                }
            }
            if (isCompanyCase) {
                if (this.userEngine.getCompany(bc.getCompanyId()) == null) {
                    throw new CaseException("Invalid Company Id for the Case");
                }
                if (bc instanceof FormCase) {
                    this.throwIfNotValid(bc.getContactId(), "The contact Id is missing");
                    if (this.userEngine.getContact(bc.getContactId()) == null) {
                        throw new CaseException("Invalid Contact Id for the case");
                    }
                }
            }
            if (bc instanceof FormCase) {
                bc.setCaseTemplateId("00278849E25F336B0000012E156D54D9");
            } else {
                String caseTemplateId = bc.getCaseTemplateId();
                this.throwIfNotValid(caseTemplateId, "The casetemplate Id is missing");
                if (caseTemplateId.equals("00278849E25F336B0000012E156D54D9")) {
                    throw new IllegalArgumentException("This case template cannot be used by normal cases.");
                }
                CaseTemplate ct = this.getCaseTemplate(caseTemplateId);
                this.throwIfNull(ct, "The selected Case Template was not found");
            }
            if (bc instanceof FormCase && this.isValid(((FormCase)bc).getParentId())) {
                User parentAuthor;
                BaseCase parentCase = this.getCase(((FormCase)bc).getParentId());
                if (parentCase == null) {
                    throw new SelfServiceException("Invalid Parent Id!");
                }
                if (parentCase instanceof FormCase) {
                    bc.getAccessControlList().addAll(parentCase.getAccessControlList());
                } else {
                    for (AccessControl updatedAcl : parentCase.getAccessControlList()) {
                        if (!updatedAcl.getEntityType().equals((Object)AccessControl.AccessControlType.ROLE) && !updatedAcl.getEntityId().equals(userContext.getUserId())) {
                            updatedAcl.setBitmask(AccessControl.Permission.READ.getValue());
                        }
                        bc.getAccessControlList().add(updatedAcl);
                    }
                }
                if (parentCase instanceof FormCase && ((FormCase)parentCase).isShared()) {
                    ((FormCase)bc).setShared(true);
                }
                for (MetaData meta : parentCase.getMetadata()) {
                    if (!"collaboration.user".equals(meta.getKey()) || meta.getUserId().equals(userContext.getUserId())) continue;
                    bc.getMetadata().add(new MetaData("collaboration.user", meta.getValue(), meta.getUserId()));
                    bc.getMetadata().add(new MetaData("collaboration.submit", "true", meta.getUserId()));
                }
                if (!parentCase.getCreatedById().equals(bc.getCreatedById()) && parentCase instanceof FormCase && (parentAuthor = this.userEngine.getUser(parentCase.getCreatedById())) != null) {
                    bc.getMetadata().add(new MetaData("collaboration.user", parentAuthor.getFullname(), parentCase.getCreatedById()));
                    bc.getMetadata().add(new MetaData("collaboration.submit", "true", parentCase.getCreatedById()));
                }
            }
            this.checkDocumentId(bc);
            if (!this.isValid(bc.getStatusId())) {
                this.setDocumentStatus(bc);
            } else {
                this.validateDocumentStatus(bc);
            }
            if (bc instanceof FormCase) {
                this.throwIfNotValid(((FormCase)bc).getFormtemplateId(), "Formtemplate Id must be defined for FormCases");
            }
            this.throwIfNotValid(bc.getStatusId(), "Case status is missing, no default Case Status is set.");
            Organization org = this.configEngine.getOrganization(bc.getOrganizationId());
            if (org == null) {
                throw new CaseException("Invalid Organization Id for Case");
            }
            if (!this.isValid(bc.getModifiedById())) {
                bc.setModifiedById(bc.getCreatedById());
            }
            if (bc instanceof FormCase) {
                this.doPreSaveFormCase(null, (FormCase)bc);
            } else if (bc instanceof Case) {
                this.doPreSaveCase(null, (Case)bc);
            }
            CaseImpl parentAuthor = this;
            synchronized (parentAuthor) {
                String caseReferenceNumber = this.createReferenceNumber();
                bc.setReferenceNumber(caseReferenceNumber);
                this.dalc.createCase(bc);
            }
            this.saveAccessControl(bc.getId(), bc.getAccessControlList());
            this.logAction(bc.getId(), AuditLogEntry.DataType.CASE, AuditLogEntry.Action.CREATE);
            this.createQueueEntry(bc, org);
            ArrayList<SelfServiceException> sExceptions = new ArrayList<SelfServiceException>();
            for (SubDocument doc : bc.getSubDocuments()) {
                doc.setCaseId(bc.getId());
                if (!doc.isPersonalSensitive() && bc.isPersonalSensitive()) {
                    doc.setPersonalSensitive(bc.isPersonalSensitive());
                }
                if (!this.isValid(doc.getCreatedById())) {
                    doc.setCreatedById(bc.getCreatedById());
                }
                if (bc.isSent()) {
                    doc.setDateCompleted(new Date().getTime());
                    if (!this.isValid(doc.getCompletedById())) {
                        doc.setCompletedById(doc.getCreatedById());
                    }
                }
                boolean isVirusFound = false;
                if (doc instanceof Attachment) {
                    try {
                        VirusScanService.virusScan((Attachment)doc);
                    }
                    catch (SelfServiceException se) {
                        isVirusFound = true;
                        sExceptions.add(se);
                        continue;
                    }
                }
                if (isVirusFound) continue;
                doc.getAccessControlList().addAll(bc.getAccessControlList());
                this.createSubDocument(doc);
            }
            super.createMetaData(bc, this.dalc);
            if (bc instanceof FormCase) {
                this.doPostSaveFormCase(null, (FormCase)bc);
            } else if (bc instanceof Case) {
                this.doPostSaveCase(null, (Case)bc);
            }
            if (bc.isSent()) {
                this.logAction(bc.getId(), AuditLogEntry.DataType.CASE, AuditLogEntry.Action.SEND);
            }
            if (sExceptions.size() > 0) {
                String exMsg = "";
                String eol = System.getProperty("line.separator");
                for (int cnt = 0; cnt < sExceptions.size(); ++cnt) {
                    exMsg = exMsg + ((SelfServiceException)sExceptions.get(cnt)).getMessage() + eol;
                }
                throw new VirusScannerException(exMsg);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new CaseException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (UserException ex) {
            throw new SelfServiceException(ex);
        }
        catch (HookInException ex) {
            throw new SelfServiceException(ex);
        }
        catch (RuntimeException ex) {
            throw new SelfServiceException(ex);
        }
        catch (TargetGroupException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public BaseCase getCase(String caseId) throws SelfServiceException {
        try {
            BirdUserPrincipal userContext = this.getUserContext();
            BaseCase bc = this.dalc.getCase(caseId, userContext.getUserId());
            if (bc != null) {
                FormTemplate ft;
                bc.getSubDocuments().addAll(this.getCaseDocuments(caseId, false));
                ListItem statusItem = this.configEngine.getListItem(bc.getStatusId());
                if (statusItem != null) {
                    bc.setStatus((StatusListItem)statusItem);
                }
                this.setMetaData(bc, this.dalc);
                this.setACL(bc);
                if (bc instanceof FormCase && (ft = this.formEngine.getFormTemplate(((FormCase)bc).getFormtemplateId(), false)) != null && ft.getExtendedData() != null) {
                    bc.setCaseFlow(ft.getExtendedData().getCaseStatusList());
                    ((FormCase)bc).setNewAttachmentAvailable(ft.isAttachmentVisible());
                    ((FormCase)bc).setNewMemoAvailable(ft.isMemoVisible());
                }
            }
            return bc;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (ConfigException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public BaseCase getCaseByGoProId(String goproDocumentId, String organizationId) throws SelfServiceException {
        try {
            BirdUserPrincipal userContext = this.getUserContext();
            BaseCase bc = this.dalc.getCaseByGoProId(goproDocumentId, organizationId, userContext.getUserId());
            if (bc != null) {
                FormTemplate ft;
                bc.getSubDocuments().addAll(this.getCaseDocuments(bc.getId(), false));
                this.setMetaData(bc, this.dalc);
                this.setACL(bc);
                if (bc instanceof FormCase && (ft = this.formEngine.getFormTemplate(((FormCase)bc).getFormtemplateId(), false)) != null && ft.getExtendedData() != null) {
                    bc.setCaseFlow(ft.getExtendedData().getCaseStatusList());
                }
            }
            return bc;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<BaseCase> getCases() throws SelfServiceException {
        BirdUserPrincipal userContext = this.getUserContext();
        return this.getCases(userContext.getUserId());
    }

    @Override
    public List<BaseCase> getCases(String userId) throws SelfServiceException {
        try {
            List<BaseCase> list = this.dalc.getCases(userId);
            this.setStatuses(list);
            this.setCaseMetadata(list);
            return list;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public CaseList getCases(String userId, CaseListFilter filter) throws SelfServiceException {
        try {
            List<String> filterStatusList = filter.getStatusList();
            if (!filterStatusList.isEmpty()) {
                boolean isUIDs = true;
                for (String status : filterStatusList) {
                    isUIDs &= status.length() == 32;
                }
                if (!isUIDs) {
                    ArrayList<String> idList = new ArrayList<String>();
                    net.gopro.selfservice.data.List statusList = this.configEngine.getList("00ED1DFEB2098F050000012274E564AF");
                    for (ListItem item : statusList.getListItems()) {
                        if (!filterStatusList.contains(item.getSubject()) && !filterStatusList.contains(item.getAlias())) continue;
                        idList.add(item.getId());
                    }
                    filter.getStatusList().clear();
                    filter.getStatusList().addAll(idList);
                }
            }
            List<BaseCase> list = this.dalc.getCases(userId, filter);
            int caseCount = this.dalc.getCaseCount(userId, filter);
            this.setStatuses(list);
            this.setCaseMetadata(list);
            CaseList cl = new CaseList(list, filter);
            cl.setTotalRecordCount(caseCount);
            return cl;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private void setStatuses(List<BaseCase> caseList) throws SelfServiceException {
        net.gopro.selfservice.data.List statusList;
        if (caseList.size() > 0 && (statusList = this.configEngine.getList("00ED1DFEB2098F050000012274E564AF")) instanceof StatusList) {
            for (BaseCase bc : caseList) {
                ListItem listItem = statusList.getListItem(bc.getStatusId());
                if (listItem == null) continue;
                bc.setStatus((StatusListItem)listItem);
            }
        }
    }

    @Override
    public List<BaseCase> getCasesByParentId(String parentId) throws SelfServiceException {
        try {
            net.gopro.selfservice.data.List statusList;
            this.throwIfNull(parentId, "Parent Id cannot be null");
            BirdUserPrincipal userContext = this.getUserContext();
            List<BaseCase> list = this.dalc.getCasesByParentId(parentId, userContext.getUserId());
            if (list.size() > 0 && (statusList = this.configEngine.getList("00ED1DFEB2098F050000012274E564AF")) instanceof StatusList) {
                for (BaseCase bc : list) {
                    ListItem listItem = statusList.getListItem(bc.getStatusId());
                    if (listItem == null) continue;
                    bc.setStatus((StatusListItem)listItem);
                }
            }
            this.setCasesACL(list);
            return list;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<FormCase> getCasesByFormTemplate(String templateId) throws SelfServiceException {
        try {
            net.gopro.selfservice.data.List statusList;
            this.throwIfNull(templateId, "Template Id cannot be null");
            BirdUserPrincipal userContext = this.getUserContext();
            List<FormCase> list = this.dalc.getCasesByFormTemplate(null, templateId, userContext.getUserId());
            if (list.size() > 0 && (statusList = this.configEngine.getList("00ED1DFEB2098F050000012274E564AF")) instanceof StatusList) {
                for (BaseCase baseCase : list) {
                    ListItem listItem = statusList.getListItem(baseCase.getStatusId());
                    if (listItem == null) continue;
                    baseCase.setStatus((StatusListItem)listItem);
                }
            }
            this.setCaseMetadata(list);
            return list;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<FormCase> getCasesByFormTemplate(String userId, String templateId) throws SelfServiceException {
        try {
            net.gopro.selfservice.data.List statusList;
            this.throwIfNull(userId, "User Id cannot be null");
            this.throwIfNull(templateId, "Template Id cannot be null");
            BirdUserPrincipal userContext = this.getUserContext();
            List<FormCase> list = this.dalc.getCasesByFormTemplate(userId, templateId, userContext.getUserId());
            BaseDocumentUtil.removeDeletedDocuments(list);
            if (list.size() > 0 && (statusList = this.configEngine.getList("00ED1DFEB2098F050000012274E564AF")) instanceof StatusList) {
                for (BaseCase baseCase : list) {
                    ListItem listItem = statusList.getListItem(baseCase.getStatusId());
                    if (listItem == null) continue;
                    baseCase.setStatus((StatusListItem)listItem);
                }
            }
            this.setCaseMetadata(list);
            return list;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<BaseCase> getCasesByOrganization(String organizationId) throws SelfServiceException {
        try {
            net.gopro.selfservice.data.List statusList;
            this.throwIfNull(organizationId, "Organization Id cannot be null");
            BirdUserPrincipal userContext = this.getUserContext();
            List<BaseCase> list = this.dalc.getCasesByOrganizationId(organizationId, userContext.getUserId());
            BaseDocumentUtil.removeDeletedDocuments(list);
            if (list.size() > 0 && (statusList = this.configEngine.getList("00ED1DFEB2098F050000012274E564AF")) instanceof StatusList) {
                for (BaseCase bc : list) {
                    ListItem listItem = statusList.getListItem(bc.getStatusId());
                    if (listItem == null) continue;
                    bc.setStatus((StatusListItem)listItem);
                }
            }
            this.setCaseMetadata(list);
            return list;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<BaseCase> getCasesByCompany(String companyId) throws SelfServiceException {
        try {
            net.gopro.selfservice.data.List statusList;
            this.throwIfNull(companyId, "Company Id cannot be null");
            BirdUserPrincipal userContext = this.getUserContext();
            List<BaseCase> list = this.dalc.getCasesByCompany(companyId, userContext.getUserId());
            if (list.size() > 0 && (statusList = this.configEngine.getList("00ED1DFEB2098F050000012274E564AF")) instanceof StatusList) {
                for (BaseCase bc : list) {
                    ListItem listItem = statusList.getListItem(bc.getStatusId());
                    if (listItem == null) continue;
                    bc.setStatus((StatusListItem)listItem);
                }
            }
            this.setCasesACL(list);
            this.setCaseMetadata(list);
            return list;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateCase(BaseCase bc) throws CaseException, SelfServiceException {
        this.throwIfNull(bc, "Case is null");
        try {
            List<SubDocument> subDocList;
            this.throwIfNotValid(bc.getSubject(), "Case subject is missing");
            this.throwIfNotValid(bc.getOrganizationId(), "Case organization is missing");
            this.throwIfNotValid(bc.getStatusId(), "Case status is missing");
            this.assertStringLength(bc.getGoProCaseNumber(), 36);
            if (bc.getSubject().length() > 255) {
                bc.setSubject(bc.getSubject().substring(0, 255));
            }
            BirdUserPrincipal userContext = this.getUserContext();
            BaseCase oldInstance = this.dalc.getCase(bc.getId(), userContext.getUserId());
            this.validateAccessControl(bc);
            boolean isCompanyCase = this.isValid(bc.getCompanyId());
            if (bc instanceof FormCase) {
                this.throwIfNotValid(bc.getCreatedById(), "Case owner is missing");
            } else if (bc instanceof Case) {
                boolean isUserCase = this.isValid(bc.getCreatedById());
                boolean isTargetGroupCase = this.isValid(((Case)bc).getTargetGroupId());
                if (!(isUserCase || isTargetGroupCase || isCompanyCase)) {
                    throw new CaseException("Either userId, targetgroupId or companyId must be defined.");
                }
            }
            if (isCompanyCase) {
                if (this.userEngine.getCompany(bc.getCompanyId()) == null) {
                    throw new CaseException("Invalid Company Id for the Case");
                }
                if (bc instanceof FormCase) {
                    this.throwIfNotValid(bc.getContactId(), "The contact Id is missing");
                    if (this.userEngine.getContact(bc.getContactId()) == null) {
                        throw new CaseException("Invalid Contact Id for the case");
                    }
                }
            }
            if (bc instanceof FormCase) {
                bc.setCaseTemplateId("00278849E25F336B0000012E156D54D9");
            } else {
                String caseTemplateId = bc.getCaseTemplateId();
                this.throwIfNotValid(caseTemplateId, "The casetemplate Id is missing");
                CaseTemplate ct = this.getCaseTemplate(caseTemplateId);
                this.throwIfNull(ct, "The selected Case Template was not found");
            }
            bc.setDateModified(new Date().getTime());
            bc.setModifiedById(userContext.getUserId());
            if (bc instanceof FormCase) {
                this.doPreSaveFormCase(null, (FormCase)bc);
            } else if (bc instanceof Case) {
                this.doPreSaveCase(null, (Case)bc);
            }
            for (SubDocument doc : bc.getSubDocuments()) {
                if (doc.getSaveCounter() != 0) continue;
                doc.setCaseId(bc.getId());
                if (!this.isValid(doc.getCreatedById())) {
                    doc.setCreatedById(bc.getCreatedById());
                }
                if (bc instanceof FormCase && doc instanceof Attachment && bc.isSent()) {
                    doc.setDateCompleted(new Date().getTime());
                    doc.setSent(true);
                    if (!this.isValid(doc.getCompletedById())) {
                        doc.setCompletedById(doc.getCreatedById());
                    }
                }
                doc.getAccessControlList().addAll(bc.getAccessControlList());
                this.createSubDocument(doc);
            }
            Organization org = this.configEngine.getOrganization(bc.getOrganizationId());
            if (org == null) {
                throw new CaseException("Invalid Organization Id for Case");
            }
            boolean isReSubmitted = false;
            if (bc instanceof FormCase && bc.isSent() && bc.isReOpened()) {
                bc.setReOpened(false);
                MetaData m = new MetaData();
                m.setKey("case.resubmit");
                m.setValue(String.valueOf(new Date().getTime()));
                bc.getMetadata().add(m);
                isReSubmitted = true;
            }
            boolean isResendStatusTriggered = false;
            if (bc instanceof FormCase) {
                isResendStatusTriggered = this.isResendTriggered((FormCase)bc);
            }
            this.dalc.updateCase(bc);
            this.updateAccessControl(bc.getId(), bc.getAccessControlList());
            this.updateMetaData(bc, this.dalc);
            this.logAction(bc.getId(), AuditLogEntry.DataType.CASE, AuditLogEntry.Action.UPDATE);
            if (!isResendStatusTriggered) {
                if (isReSubmitted) {
                    bc.setReOpened(true);
                    logger.debug((Object)String.format("Case %s marked as re-opened", bc.getReferenceNumber()));
                }
                this.createQueueEntry(bc, org);
            }
            if (!oldInstance.isSent() && bc.isSent()) {
                this.logAction(bc.getId(), AuditLogEntry.DataType.CASE, AuditLogEntry.Action.SEND);
            }
            if (bc instanceof FormCase && oldInstance.isSignaturePending() && bc.isSigned() && bc.isSent()) {
                subDocList = this.getCaseDocuments(bc.getId(), false);
                for (SubDocument sub : subDocList) {
                    if (!sub.isSent() || sub.isFromGoPro() || !(sub instanceof Memo) && !(sub instanceof Attachment)) continue;
                    this.createQueueEntry(sub, org);
                    logger.debug((Object)("Queue entry created for response doc pending parent signature: " + sub.getSubject()));
                }
            }
            if (bc.isSent()) {
                subDocList = this.getCaseDocuments(bc.getId(), false);
                for (SubDocument doc : subDocList) {
                    if (doc.isDeleted() || doc.isSent()) continue;
                    doc.setSent(true);
                    doc.setDateCompleted(new Date().getTime());
                    doc.setCompletedById(bc.getCompletedById());
                    doc.setModifiedById(bc.getModifiedById());
                    this.dalc.updateSubdocumentSentStatus(doc, true);
                    if (doc instanceof ApplicationForm) continue;
                    this.createQueueEntry(doc, org);
                }
            }
            if (bc instanceof FormCase) {
                this.doPostSaveFormCase(null, (FormCase)bc);
            } else if (bc instanceof Case) {
                this.doPostSaveCase(null, (Case)bc);
            }
            if (isResendStatusTriggered) {
                this.reopenFormCase((FormCase)bc);
            }
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new CaseException(ex);
        }
        catch (HookInException ex) {
            throw new SelfServiceException(ex);
        }
        catch (RuntimeException ex) {
            throw new SelfServiceException(ex);
        }
        catch (UserException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private void reopenFormCase(FormCase bc) throws SelfServiceException, CaseException, SQLException {
        try {
            SubDocument xmlForm;
            bc.setSent(false);
            bc.setReOpened(true);
            MetaData m = new MetaData();
            m.setKey("case.reopened");
            m.setValue(String.valueOf(new Date().getTime()));
            m.setReferenceId(bc.getId());
            this.configEngine.createMetaData(m);
            FormTemplate ft = this.formEngine.getFormTemplate(bc.getFormtemplateId(), false);
            LinkedList<StatusListItem> caseStatusList = ft.getExtendedData().getCaseStatusList();
            bc.setStatusId(caseStatusList.getFirst().getId());
            SubDocument pdfForm = this.getSubDocument(bc.getCompletedFormDocument().getId(), true);
            if (pdfForm != null) {
                pdfForm.setDeleted(true);
                this.updateSubDocument(pdfForm);
            }
            if ((xmlForm = this.getSubDocument(bc.getApplicationForm().getId(), true)) != null) {
                xmlForm.setSent(false);
                this.updateSubDocument(xmlForm);
            }
            this.removeMetadataAfterReOpen(bc, (ApplicationForm)xmlForm);
            this.dalc.updateCase(bc);
            User user = this.userEngine.getUser(bc.getCreatedById());
            MessageHelper.sendCaseReopenedMessage(user, bc);
            this.logAction(bc.getId(), AuditLogEntry.DataType.CASE, AuditLogEntry.Action.REOPEN);
        }
        catch (SaveConflictException ex) {
            throw new SelfServiceException(ex);
        }
        catch (FormQueryException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private void removeMetadataAfterReOpen(FormCase fc, ApplicationForm form) throws SelfServiceException, FormQueryException {
        logger.info((Object)String.format("Remove all Form related metadata on Re-Opened case: %s", fc.getReferenceNumber()));
        FormTemplate formtemplate = FormService.getFormTemplate(fc.getFormtemplateId(), false);
        IFormQuery queryProcessor = formtemplate.getFormQueryProcessor();
        Hashtable<String, String> bucket = queryProcessor.getKeyValuePairs(form);
        for (MetaData meta : fc.getMetadata()) {
            for (String metaKey : bucket.keySet()) {
                if (!meta.getKey().startsWith(metaKey)) continue;
                meta.setDeleted(true);
                this.configEngine.updateMetaData(meta);
                logger.debug((Object)String.format("Metadata with key: %s marked deleted on the Case", meta.getKey()));
            }
        }
        for (MetaData meta : form.getMetadata()) {
            for (String metaKey : bucket.keySet()) {
                if (!meta.getKey().startsWith(metaKey)) continue;
                meta.setDeleted(true);
                this.configEngine.updateMetaData(meta);
                logger.debug((Object)String.format("Metadata with key: %s marked deleted on the Form", meta.getKey()));
            }
        }
    }

    private boolean isResendTriggered(FormCase bc) throws SelfServiceException, SQLException {
        logger.debug((Object)("Re-open status check on case: " + bc.getReferenceNumber()));
        BirdUserPrincipal userContext = this.getUserContext();
        FormCase previousVersion = (FormCase)this.dalc.getCase(bc.getId(), userContext.getUserId());
        logger.debug((Object)String.format("Current status: %s, Previous status: %s ", bc.getStatusId(), previousVersion.getStatusId()));
        if (!previousVersion.getStatusId().equals(bc.getStatusId())) {
            FormTemplate ft = this.formEngine.getFormTemplate(bc.getFormtemplateId(), false);
            logger.debug((Object)String.format("Is resend enabled: %s ", Boolean.toString(ft.isResendEnabled())));
            if (ft.isResendEnabled()) {
                logger.debug((Object)String.format("Enabled for status: %s, current status: %s ", ft.getResendStatusId(), bc.getStatusId()));
            }
            if (ft.isResendEnabled() && bc.getStatusId().equals(ft.getResendStatusId())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void deleteCase(String caseId) throws CaseException, SelfServiceException, SaveConflictException {
        BaseCase bc = this.getCase(caseId);
        if (bc != null) {
            bc.setDeleted(true);
            this.updateCase(bc);
            for (RoutingQueueEntry entry : this.queueEngine.findEntries(caseId)) {
                if (entry.isProcessed()) continue;
                this.queueEngine.removeRoutingQueueEntry(entry.getId());
            }
            for (SubDocument doc : bc.getSubDocuments()) {
                this.deleteSubDocument(doc);
            }
        } else {
            throw new SelfServiceException("Invalid Case Id");
        }
        this.logAction(caseId, AuditLogEntry.DataType.CASE, AuditLogEntry.Action.DELETE);
    }

    @Override
    public void createSubDocument(SubDocument doc) throws CaseException, SelfServiceException {
        this.throwIfNull(doc, "Document is null");
        try {
            this.throwIfNotValid(doc.getSubject(), "The Subject is missing");
            this.throwIfNotValid(doc.getCaseId(), "The case Id is missing");
            this.assertStringLength(doc.getSubject(), 255);
            this.checkDocumentId(doc);
            BaseCase parentCase = this.getCase(doc.getCaseId());
            this.validateAccessControl(doc);
            if (doc.getParentId() != null && !doc.getParentId().equals(doc.getCaseId())) {
                SubDocument parentDocument = this.getSubDocument(doc.getParentId(), false);
                this.throwIfNull(parentDocument, "The parent document was not found");
                if (parentDocument.isDeleted()) {
                    throw new CaseException("Cannot set deleted document as parent document");
                }
                if (!doc.getParentId().equals(doc.getCaseId()) && !parentDocument.getCaseId().equals(doc.getCaseId())) {
                    throw new CaseException("The selected parent document is not under same case!");
                }
                if (parentDocument instanceof CompletedFormDocument) {
                    doc.setParentId(parentDocument.getCaseId());
                }
            }
            if (parentCase != null && parentCase instanceof FormCase) {
                if (parentCase.isSent()) {
                    doc.setDateCompleted(new Date().getTime());
                }
                if (doc.isFromGoPro()) {
                    doc.setCreatedById(parentCase.getCreatedById());
                }
            }
            if (!doc.isPersonalSensitive() && parentCase != null) {
                doc.setPersonalSensitive(parentCase.isPersonalSensitive());
            }
            this.throwIfNotValid(doc.getCreatedById(), "Document owner Id is missing");
            if (!this.isValid(doc.getModifiedById())) {
                doc.setModifiedById(doc.getCreatedById());
            }
            if (!this.isValid(doc.getStatusId())) {
                this.setDocumentStatus(doc);
            } else {
                this.checkDocumentId(doc);
            }
            if (doc.getSaveCounter() == 0) {
                doc.incrementSaveCounter();
            }
            if (parentCase != null && parentCase instanceof FormCase) {
                this.doPreSaveFormCase(doc, (FormCase)parentCase);
            } else if (parentCase != null && parentCase instanceof Case) {
                this.doPreSaveCase(doc, (Case)parentCase);
            }
            Organization org = null;
            if (parentCase != null) {
                String goproAgent;
                FormTemplate formTemplate;
                org = this.configEngine.getOrganization(parentCase.getOrganizationId());
                if (parentCase instanceof FormCase && RemoteGoPro.isNOPDataStore(org.getEndpoint().getGoproType()) && (formTemplate = this.formEngine.getFormTemplate(((FormCase)parentCase).getFormtemplateId(), false)).getExtendedData() != null && (goproAgent = formTemplate.getExtendedData().getGoproAgent()) != null && !StringUtils.isEmpty((String)goproAgent)) {
                    MetaData metaAgent = new MetaData("$GoProWebServicesAgent", goproAgent);
                    doc.getMetadata().add(metaAgent);
                }
            }
            if (doc instanceof ExternalDocument) {
                ExternalDocument ext = (ExternalDocument)doc;
                this.throwIfNotValid(ext.getFilename(), "The filename is missing");
                if (ext.getStream() == null || ext.getStream().length == 0) {
                    throw new SelfServiceException("The filestream is invalid");
                }
                ext.setFilename(StringUtil.sanitizeFileName(FilenameUtils.getName((String)ext.getFilename())));
                if (!this.isValid(ext.getMimetype())) {
                    MimetypesFileTypeMap mmap = new MimetypesFileTypeMap();
                    ext.setMimetype(mmap.getContentType(ext.getFilename()));
                }
                this.throwIfNotValid(ext.getMimetype(), "The mimetype is missing");
                if (ext.getFilesize() == 0L) {
                    ext.setFilesize(ext.getStream().length);
                }
                this.assertStringLength(ext.getFilename(), 255);
                this.assertStringLength(ext.getMimetype(), 255);
                try {
                    this.dalc.createExternalDocument(ext);
                    this.createMetaData(doc, this.dalc);
                    this.logAction(doc.getId(), AuditLogEntry.DataType.EXTERNAL_DOCUMENT, AuditLogEntry.Action.CREATE);
                }
                catch (SQLException ex) {
                    throw new SelfServiceException(ex);
                }
                catch (RuntimeException ex) {
                    throw new SelfServiceException(ex);
                }
            }
            if (doc instanceof Memo) {
                Memo memo = (Memo)doc;
                this.throwIfNotValid(memo.getBody(), "Memo body is missing");
                try {
                    this.dalc.createMemo(memo);
                    this.createMetaData(doc, this.dalc);
                    this.logAction(doc.getId(), AuditLogEntry.DataType.MEMO, AuditLogEntry.Action.CREATE);
                }
                catch (SQLException ex) {
                    throw new SelfServiceException(ex);
                }
            }
            if (doc instanceof Email) {
                Email email = (Email)doc;
                if (email.getRecipients() == null || email.getRecipients().size() == 0) {
                    throw new SelfServiceException("Email recipient list is empty");
                }
                for (EmailAttachment att : email.getAttachments()) {
                    this.throwIfNotValid(att.getFileName(), "Email attachment filename is missing");
                    this.throwIfNotValid(att.getMimeType(), "Email attachment mimetype is missing");
                    if (att.getStream() == null || att.getStream().length == 0) {
                        throw new IllegalArgumentException("Email attachment stream is missing");
                    }
                    if (att.getFileSize() != 0L) continue;
                    att.setFileSize(att.getStream().length);
                }
                try {
                    this.dalc.createEmail(email);
                    this.createMetaData(doc, this.dalc);
                    this.logAction(doc.getId(), AuditLogEntry.DataType.EMAIL, AuditLogEntry.Action.CREATE);
                }
                catch (SQLException ex) {
                    throw new SelfServiceException(ex);
                }
            }
            this.saveAccessControl(doc.getId(), doc.getAccessControlList());
            this.updateParentResponseCount(doc);
            if (org != null) {
                this.createQueueEntry(doc, org);
            }
            if (parentCase != null && parentCase instanceof FormCase) {
                this.doPostSaveFormCase(doc, (FormCase)parentCase);
            } else if (parentCase != null && parentCase instanceof Case) {
                this.doPostSaveCase(doc, (Case)parentCase);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new CaseException(ex);
        }
        catch (HookInException ex) {
            throw new CaseException(ex);
        }
        catch (RuntimeException ex) {
            throw new CaseException(ex);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new CaseException(ex);
        }
    }

    @Override
    public List<SubDocument> getCaseDocuments(String caseId, boolean includeStream) throws SelfServiceException {
        try {
            BirdUserPrincipal userContext = this.getUserContext();
            ArrayList<SubDocument> documentList = new ArrayList<SubDocument>();
            documentList.addAll(this.dalc.getMemos(caseId, userContext.getUserId()));
            documentList.addAll(this.dalc.getExternalDocuments(caseId, includeStream, userContext.getUserId()));
            documentList.addAll(this.dalc.getEmails(caseId, includeStream, userContext.getUserId()));
            this.setResponseDocumentsACL(documentList);
            return documentList;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IOException ex) {
            throw new SelfServiceException("Error processing document stream", ex);
        }
    }

    @Override
    public SubDocument getSubDocument(String documentId, boolean includeStream) throws SelfServiceException {
        SubDocument doc = this.getMemo(documentId);
        if (doc == null) {
            doc = this.getExternalDocument(documentId, includeStream);
        }
        if (doc == null) {
            doc = this.getEmail(documentId, includeStream);
        }
        return doc;
    }

    @Override
    public Email getEmail(String documentId, boolean includeStream) throws SelfServiceException {
        try {
            BirdUserPrincipal userContext = this.getUserContext();
            Email email = this.dalc.getEmail(documentId, includeStream, userContext.getUserId());
            if (email != null) {
                this.setMetaData(email, this.dalc);
                this.setACL(email);
                this.logAction(email.getId(), AuditLogEntry.DataType.EMAIL, AuditLogEntry.Action.READ);
            }
            return email;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public SubDocument getSubDocumentByGoProId(String goproDocumentId) throws SelfServiceException {
        try {
            BirdUserPrincipal userContext = this.getUserContext();
            SubDocument doc = this.dalc.getMemoByGoProId(goproDocumentId, userContext.getUserId());
            if (doc == null) {
                doc = this.dalc.getExternalDocumentByGoProId(goproDocumentId, false, userContext.getUserId());
            }
            if (doc == null) {
                doc = this.dalc.getEmailByGoProId(goproDocumentId);
            }
            if (doc != null) {
                this.setACL(doc);
            }
            return doc;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<SubDocument> getSubdocuments(String userId) throws SelfServiceException {
        try {
            this.throwIfNull(userId, "UserId cannot be null");
            BirdUserPrincipal userContext = this.getUserContext();
            ArrayList<SubDocument> list = new ArrayList<SubDocument>();
            List<Memo> memoList = this.dalc.getMemosByUser(userId, userContext.getUserId());
            List<SubDocument> docList = this.dalc.getExternalDocumentsByUser(userId, userContext.getUserId());
            list.addAll(memoList);
            list.addAll(docList);
            this.setResponseDocumentsACL(list);
            return list;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateSubDocument(SubDocument doc) throws CaseException, SaveConflictException, SelfServiceException {
        this.throwIfNull(doc, "Document is null");
        try {
            this.throwIfNotValid(doc.getSubject(), "The Subject is missing");
            this.throwIfNotValid(doc.getCaseId(), "The case Id is missing");
            this.throwIfNotValid(doc.getStatusId(), "The status Id is missing");
            this.assertStringLength(doc.getSubject(), 255);
            BirdUserPrincipal userContext = this.getUserContext();
            BaseCase parentCase = this.getCase(doc.getCaseId());
            this.validateAccessControl(doc);
            doc.incrementSaveCounter();
            SubDocument latestVersion = this.getSubDocument(doc.getId(), false);
            if (latestVersion != null && latestVersion.getSaveCounter() == doc.getSaveCounter()) {
                SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm");
                throw new SaveConflictException("Document save conflict detected, document was last on " + df.format(new Date(latestVersion.getDateModified())));
            }
            try {
                doc.setDateModified(new Date().getTime());
                doc.setModifiedById(userContext.getUserId());
                if (parentCase != null && parentCase instanceof FormCase) {
                    this.doPreSaveFormCase(doc, (FormCase)parentCase);
                } else if (parentCase != null && parentCase instanceof Case) {
                    this.doPreSaveCase(doc, (Case)parentCase);
                }
                if (doc instanceof Memo) {
                    this.throwIfNotValid(doc.getBody(), "Memo body is missing");
                    this.dalc.updateMemo((Memo)doc);
                    this.logAction(doc.getId(), AuditLogEntry.DataType.MEMO, AuditLogEntry.Action.UPDATE);
                } else if (doc instanceof ExternalDocument) {
                    ExternalDocument ext = (ExternalDocument)doc;
                    this.throwIfNotValid(ext.getFilename(), "The filename is missing");
                    if (ext.getStream() == null || ext.getStream().length == 0) {
                        throw new SelfServiceException("The filestream is invalid");
                    }
                    ext.setFilename(FilenameUtils.getName((String)ext.getFilename()));
                    if (!this.isValid(ext.getMimetype())) {
                        MimetypesFileTypeMap mmap = new MimetypesFileTypeMap();
                        ext.setMimetype(mmap.getContentType(ext.getFilename()));
                    }
                    this.throwIfNotValid(ext.getMimetype(), "The mimetype is missing");
                    if (ext.getFilesize() == 0L) {
                        ext.setFilesize(ext.getStream().length);
                    }
                    this.dalc.updateExternalDocument(ext);
                    this.logAction(doc.getId(), AuditLogEntry.DataType.EXTERNAL_DOCUMENT, AuditLogEntry.Action.UPDATE);
                }
                this.updateAccessControl(doc.getId(), doc.getAccessControlList());
                this.updateMetaData(doc, this.dalc);
                this.updateParentResponseCount(doc);
                if (!doc.isDeleted() && parentCase != null) {
                    Organization org = this.configEngine.getOrganization(parentCase.getOrganizationId());
                    this.createQueueEntry(doc, org);
                }
                if (parentCase != null && parentCase instanceof FormCase) {
                    this.doPostSaveFormCase(doc, (FormCase)parentCase);
                } else if (parentCase != null && parentCase instanceof Case) {
                    this.doPostSaveCase(doc, (Case)parentCase);
                }
            }
            catch (SQLException ex) {
                throw new SelfServiceException(ex);
            }
            catch (RuntimeException ex) {
                throw new SelfServiceException(ex);
            }
            catch (HookInException ex) {
                throw new SelfServiceException(ex);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new CaseException(ex);
        }
    }

    @Override
    public void updateCaseStatus(BaseCase bc) throws SelfServiceException {
        try {
            StatusListItem status = bc.getStatus();
            if (status != null) {
                boolean isResendStatusTriggered = false;
                if (bc instanceof FormCase) {
                    isResendStatusTriggered = this.isResendTriggered((FormCase)bc);
                }
                if (this.dalc.updateCaseStatus(bc)) {
                    this.logAction(bc.getId(), AuditLogEntry.DataType.CASE, AuditLogEntry.Action.UPDATE);
                    if (isResendStatusTriggered) {
                        this.reopenFormCase((FormCase)bc);
                    }
                } else {
                    logger.warn((Object)("Case was not updated, dalc returned false for update on case: " + bc.getId()));
                }
            } else {
                logger.warn((Object)"Case status not updated, status is null");
            }
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (CaseException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateSubdocumentStatus(SubDocument sub) throws SelfServiceException {
        try {
            StatusList statusList = null;
            if (sub instanceof Memo) {
                statusList = (StatusList)this.configEngine.getList("00F9E89D6203E1AB00000121159B3979");
            } else if (sub instanceof ExternalDocument) {
                statusList = (StatusList)this.configEngine.getList("0009A47DD30D261C0000012110DFE58C");
            } else if (sub instanceof Email) {
                statusList = (StatusList)this.configEngine.getList("221003FD1A49F6E10000013775389FFF");
            }
            if (statusList != null) {
                for (ListItem item : statusList.getListItems()) {
                    if (!item.getId().equals(sub.getStatusId())) continue;
                    this.dalc.updateSubdocumentStatus(sub);
                    return;
                }
            }
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void deleteSubDocument(String documentId) throws CaseException, SelfServiceException, SaveConflictException {
        SubDocument doc = this.getSubDocument(documentId, false);
        if (doc != null) {
            this.deleteSubDocument(doc);
            if (doc.getResponseCount() > 0) {
                List<SubDocument> caseDocuments = this.getCaseDocuments(doc.getCaseId(), false);
                List<SubDocument> doclist = this.findReponseDocumentChain(caseDocuments, doc.getId());
                for (SubDocument subDoc : doclist) {
                    this.deleteSubDocument(subDoc);
                }
            }
        } else {
            throw new SelfServiceException("Invalid document Id");
        }
    }

    @Override
    public ExternalDocument getExternalDocument(String documentId, boolean includeStream) throws SelfServiceException {
        try {
            BirdUserPrincipal userContext = this.getUserContext();
            ExternalDocument doc = this.dalc.getExternalDocument(documentId, includeStream, userContext.getUserId());
            if (doc != null) {
                ListItem statusItem;
                this.setMetaData(doc, this.dalc);
                this.setACL(doc);
                CheckoutTicket ticket = this.dalc.getCheckoutStatus(doc.getId());
                if (ticket != null) {
                    doc.setCheckoutTicket(ticket);
                }
                if ((statusItem = this.configEngine.getListItem(doc.getStatusId())) != null) {
                    doc.setStatusText(statusItem.getSubject());
                }
                if (doc instanceof Attachment) {
                    boolean isPending = ((Attachment)doc).isSignaturePending();
                    boolean isSigned = ((Attachment)doc).isSigned();
                    if (isPending || isSigned) {
                        for (MetaData ms : doc.getMetadata()) {
                            if (!"Signature.Request".equals(ms.getKey())) continue;
                            ((Attachment)doc).getSignerList().add(this.userEngine.getUser(ms.getUserId()));
                        }
                    }
                }
                if (includeStream) {
                    this.logAction(doc.getId(), AuditLogEntry.DataType.EXTERNAL_DOCUMENT, AuditLogEntry.Action.READ);
                }
            }
            return doc;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IOException ex) {
            throw new SelfServiceException("Error processing attachment stream", ex);
        }
        catch (ConfigException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public Memo getMemo(String documentId) throws SelfServiceException {
        try {
            BirdUserPrincipal userContext = this.getUserContext();
            Memo memo = this.dalc.getMemo(documentId, userContext.getUserId());
            if (memo != null) {
                this.setMetaData(memo, this.dalc);
                this.setACL(memo);
                CheckoutTicket ticket = this.dalc.getCheckoutStatus(memo.getId());
                if (ticket != null) {
                    memo.setCheckoutTicket(ticket);
                }
                this.logAction(memo.getId(), AuditLogEntry.DataType.MEMO, AuditLogEntry.Action.READ);
            }
            return memo;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public Hashtable<String, String> getCaseTypesInUse(String userId) throws SelfServiceException {
        try {
            BirdUserPrincipal userContext = this.getUserContext();
            return this.dalc.getCaseTypesInUse(userContext.getUserId());
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void createCaseTemplate(CaseTemplate ct) throws CaseException, SelfServiceException {
        this.throwIfNull(ct, "Case Template is null");
        try {
            this.throwIfNotValid(ct.getSubject(), "The subject is missing");
            this.checkDocumentId(ct);
            if (StringUtil.isValid(ct.getCategoryId())) {
                net.gopro.selfservice.data.List categoryList = this.configEngine.getList("01DCA04CC85B6E8E0000012E0FCA5C5A");
                ListItem listItem = categoryList.getListItem(ct.getCategoryId());
                this.throwIfNull(listItem, "The specified category Id was not found");
            }
            this.dalc.createCaseTemplate(ct);
            this.logAction(ct.getId(), AuditLogEntry.DataType.CASETEMPLATE, AuditLogEntry.Action.CREATE);
            this.createMetaData(ct, this.dalc);
        }
        catch (IllegalArgumentException ex) {
            throw new CaseException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void deleteCaseTemplate(String caseTemplateId) throws SelfServiceException, CaseException {
        CaseTemplate ct = this.getCaseTemplate(caseTemplateId);
        if (ct != null) {
            if (ct.isSystemTemplate()) {
                throw new SelfServiceException("System Case Templates cannot be deleted");
            }
        } else {
            throw new SelfServiceException("Invalid Case Template Id");
        }
        ct.setDeleted(true);
        this.updateCaseTemplate(ct);
        this.logAction(ct.getId(), AuditLogEntry.DataType.CASETEMPLATE, AuditLogEntry.Action.DELETE);
    }

    @Override
    public CaseTemplate getCaseTemplate(String caseTemplateId) throws SelfServiceException {
        try {
            CaseTemplate ct = this.dalc.getCaseTemplate(caseTemplateId);
            if (ct != null) {
                this.setMetaData(ct, this.dalc);
            }
            return ct;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<CaseTemplate> getCaseTemplates() throws SelfServiceException {
        try {
            return this.dalc.getCaseTemplates();
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<CaseTemplate> getPrimaryCaseTemplates() throws SelfServiceException {
        try {
            return this.dalc.getPrimaryCaseTemplates();
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<BaseCase> getCasesByCaseTemplate(String templateId, String userId) throws SelfServiceException {
        try {
            net.gopro.selfservice.data.List statusList;
            this.throwIfNotValid(templateId, "The Case template Id is invalid");
            BirdUserPrincipal userContext = this.getUserContext();
            List<BaseCase> list = this.dalc.getCasesByCaseTemplate(templateId, userContext.getUserId());
            if (list.size() > 0 && (statusList = this.configEngine.getList("00ED1DFEB2098F050000012274E564AF")) instanceof StatusList) {
                for (BaseCase bc : list) {
                    ListItem listItem = statusList.getListItem(bc.getStatusId());
                    if (listItem == null) continue;
                    bc.setStatus((StatusListItem)listItem);
                }
            }
            return list;
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateCaseTemplate(CaseTemplate ct) throws CaseException, SelfServiceException {
        this.throwIfNull(ct, "Case Template is null");
        try {
            this.throwIfNotValid(ct.getSubject(), "The subject is missing");
            ct.setDateModified(new Date().getTime());
            this.dalc.updateCaseTemplate(ct);
            this.updateMetaData(ct, this.dalc);
            this.logAction(ct.getId(), AuditLogEntry.DataType.CASETEMPLATE, AuditLogEntry.Action.UPDATE);
        }
        catch (IllegalArgumentException ex) {
            throw new CaseException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public String cloneCase(String caseId, boolean copyResponseDocuments) throws SelfServiceException, CaseException {
        try {
            BirdUserPrincipal userContext = this.getUserContext();
            this.throwIfNotValid(caseId, "The caseId is invalid");
            BaseCase bc = this.getCase(caseId);
            if (bc == null) {
                throw new SelfServiceException("The supplied Case to be cloned was not found!");
            }
            if (!(bc instanceof FormCase)) {
                throw new SelfServiceException("Only form cases can be cloned");
            }
            if (bc.isCompanyCase()) {
                throw new SelfServiceException("Shared cases cannot be cloned");
            }
            AccessControl acl = new AccessControl();
            acl.setEntityId(userContext.getUserId());
            acl.setEntityType(AccessControl.AccessControlType.USER);
            acl.setBitmask(AccessControl.Permission.WRITE.getValue());
            FormCase existingCase = (FormCase)bc;
            FormCase newCase = new FormCase(existingCase.getFormtemplateId());
            newCase.setCreatedById(userContext.getUserId());
            newCase.setSubject(existingCase.getSubject());
            newCase.setOrganizationId(existingCase.getOrganizationId());
            newCase.setSent(false);
            newCase.setShared(false);
            newCase.getAccessControlList().add(acl);
            ApplicationForm existingApplication = (ApplicationForm)this.getSubDocument(existingCase.getApplicationForm().getId(), true);
            if (existingApplication.getStream() == null) {
                throw new SelfServiceException("Application Form contents is null!");
            }
            existingApplication.setId(null);
            existingApplication.setCreatedById(userContext.getUserId());
            existingApplication.setSent(false);
            existingApplication.setParentId(null);
            existingApplication.setCaseId(null);
            existingApplication.getAccessControlList().clear();
            existingApplication.getAccessControlList().add(acl);
            FormTemplate ft = this.formEngine.getFormTemplate(existingApplication.getFormtemplateId(), false);
            FormsUtil.FormType formType = ft.getSchemaVersion() < 2.0 ? FormsUtil.FormType.GOPRO_FORM_V1 : FormsUtil.FormType.GOPRO_FORM_V2;
            FormsUtil.getInstance(formType).cleanForCloning(existingApplication);
            LinkedList<StatusListItem> caseStatusList = ft.getExtendedData().getCaseStatusList();
            StatusListItem initialStatus = caseStatusList.getFirst();
            newCase.setStatusId(initialStatus.getId());
            existingApplication.setStatusId(initialStatus.getId());
            existingApplication.getMetadata().clear();
            newCase.addSubDocument(existingApplication);
            if (copyResponseDocuments) {
                List<SubDocument> documents = this.getCaseDocuments(caseId, true);
                for (SubDocument doc : documents) {
                    if (doc.isDeleted() || doc.isFromGoPro() || doc instanceof CompletedFormDocument || doc instanceof ApplicationForm) continue;
                    doc.setId(null);
                    doc.setParentId(null);
                    doc.setCaseId(null);
                    doc.setSent(false);
                    doc.getMetadata().clear();
                    doc.getAccessControlList().clear();
                    doc.getAccessControlList().add(acl);
                    newCase.addSubDocument(doc);
                }
            }
            MetaData meta = new MetaData("clonedFrom", existingCase.getId());
            meta.setId(UID.getUID());
            newCase.getMetadata().add(meta);
            this.createCase(newCase);
            return newCase.getId();
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public CheckoutTicket checkOutDocument(String documentId, String userId) throws SelfServiceException {
        try {
            this.throwIfNotValid(documentId, "Invalid document Id");
            this.throwIfNotValid(userId, "Invalid user Id");
            CheckoutTicket ticket = null;
            ticket = this.dalc.getCheckoutStatus(documentId);
            if (ticket != null) {
                ticket.setCheckoutSuccess(false);
                return ticket;
            }
            SubDocument sub = this.getSubDocument(documentId, false);
            if (sub != null && sub.isSent()) {
                ticket = new CheckoutTicket();
                ticket.setDocumentId(documentId);
                ticket.setCheckoutSuccess(false);
                return ticket;
            }
            ticket = new CheckoutTicket(documentId, userId);
            this.checkOutDocument(ticket);
            ticket.setCheckoutSuccess(true);
            return ticket;
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public boolean checkInDocument(String documentId) throws SelfServiceException {
        try {
            boolean checkInSuccessful = false;
            CheckoutTicket ticket = this.dalc.getCheckoutStatus(documentId);
            if (ticket != null && ticket.isCheckedOut()) {
                ticket.setDateCheckedIn(new Date().getTime());
                checkInSuccessful = this.dalc.checkInDocument(ticket);
            }
            if (checkInSuccessful) {
                this.logAction(documentId, AuditLogEntry.DataType.EXTERNAL_DOCUMENT, AuditLogEntry.Action.CHECKIN);
            }
            return checkInSuccessful;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    public void checkOutDocument(CheckoutTicket ticket) throws SelfServiceException {
        try {
            this.throwIfNull(ticket, "Checkout Ticket is null!");
            this.throwIfNotValid(ticket.getDocumentId(), "The document Id is missing");
            this.throwIfNotValid(ticket.getUserId(), "The user Id is missing");
            if (this.dalc.checkOutDocument(ticket)) {
                this.logAction(ticket.getDocumentId(), AuditLogEntry.DataType.EXTERNAL_DOCUMENT, AuditLogEntry.Action.CHECKOUT);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public List<SubDocument> getCheckedOutDocuments() throws SelfServiceException {
        try {
            ArrayList<SubDocument> list = new ArrayList<SubDocument>();
            List<CheckoutTicket> tickets = this.dalc.getCheckedOutDocuments();
            for (CheckoutTicket ticket : tickets) {
                list.add(this.getSubDocument(ticket.getDocumentId(), false));
            }
            return list;
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void updateAccessControl(IAccessControlled doc) throws SelfServiceException {
        try {
            if (!(doc instanceof BaseDocument)) {
                throw new SelfServiceException("Could not update document!");
            }
            this.validateAccessControl(doc);
            this.updateAccessControl(((BaseDocument)((Object)doc)).getId(), doc.getAccessControlList());
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void createAccessControlEntry(AccessControl acl) throws SelfServiceException {
        try {
            this.throwIfNull(acl, "ACL entry is null");
            this.throwIfNull(acl.getDocumentId(), "Invalid documentId");
            this.throwIfNull(acl.getEntityId(), "The entity Id is invalid");
            this.dalc.createAccessControl(acl.getDocumentId(), Arrays.asList(acl), false);
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    @Override
    public void purgeContactAccessControl(Contact contact) throws SelfServiceException {
        try {
            List<BaseCase> companyCaseList = this.getCasesByCompany(contact.getCompanyId());
            for (BaseCase bc : companyCaseList) {
                boolean touched = false;
                Iterator<AccessControl> it = bc.getAccessControlList().iterator();
                while (it.hasNext()) {
                    AccessControl acl = it.next();
                    if (!AccessControl.AccessControlType.USER.equals((Object)acl.getEntityType()) || !acl.getEntityId().equals(contact.getUserId())) continue;
                    it.remove();
                    touched = true;
                }
                if (!touched) continue;
                this.updateAccessControl(bc.getId(), bc.getAccessControlList());
            }
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private void deleteSubDocument(SubDocument doc) throws CaseException, SelfServiceException, SaveConflictException {
        this.throwIfNull(doc, "Document is null");
        doc.setDeleted(true);
        doc.setDateModified(new Date().getTime());
        try {
            if (doc instanceof Memo) {
                this.dalc.deleteMemo((Memo)doc);
                this.logAction(doc.getId(), AuditLogEntry.DataType.MEMO, AuditLogEntry.Action.DELETE);
            } else if (doc instanceof ExternalDocument) {
                this.dalc.deleteExternalDocument((ExternalDocument)doc);
                this.logAction(doc.getId(), AuditLogEntry.DataType.EXTERNAL_DOCUMENT, AuditLogEntry.Action.DELETE);
            } else if (doc instanceof Email) {
                this.dalc.deleteEmail((Email)doc);
                this.logAction(doc.getId(), AuditLogEntry.DataType.EMAIL, AuditLogEntry.Action.DELETE);
            }
            this.updateParentResponseCount(doc);
            for (RoutingQueueEntry entry : this.queueEngine.findEntries(doc.getId())) {
                if (entry.isProcessed()) continue;
                this.queueEngine.removeRoutingQueueEntry(entry.getId());
            }
        }
        catch (SQLException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private void validateDocumentStatus(BaseDocument doc) throws SelfServiceException {
        StatusList statusList = null;
        if (doc instanceof BaseCase) {
            statusList = (StatusList)this.configEngine.getList("00ED1DFEB2098F050000012274E564AF");
            if (statusList != null) {
                ListItem item = statusList.getListItem(((BaseCase)doc).getStatusId());
                if (item == null) {
                    this.setDocumentStatus(doc);
                }
            } else {
                this.setDocumentStatus(doc);
            }
        } else if (doc instanceof ExternalDocument) {
            statusList = (StatusList)this.configEngine.getList("0009A47DD30D261C0000012110DFE58C");
            if (statusList != null) {
                ListItem item = statusList.getListItem(((ExternalDocument)doc).getStatusId());
                if (item == null) {
                    this.setDocumentStatus(doc);
                }
            } else {
                this.setDocumentStatus(doc);
            }
        } else if (doc instanceof Memo) {
            statusList = (StatusList)this.configEngine.getList("00F9E89D6203E1AB00000121159B3979");
            if (statusList != null) {
                ListItem item = statusList.getListItem(((Memo)doc).getStatusId());
                if (item == null) {
                    this.setDocumentStatus(doc);
                }
            } else {
                this.setDocumentStatus(doc);
            }
        } else if (doc instanceof Email) {
            statusList = (StatusList)this.configEngine.getList("221003FD1A49F6E10000013775389FFF");
            if (statusList != null) {
                ListItem item = statusList.getListItem(((Email)doc).getStatusId());
                if (item == null) {
                    this.setDocumentStatus(doc);
                }
            } else {
                this.setDocumentStatus(doc);
            }
        }
    }

    private void setDocumentStatus(BaseDocument doc) throws SelfServiceException {
        StatusList statusList = null;
        if (doc instanceof BaseCase) {
            statusList = (StatusList)this.configEngine.getList("00ED1DFEB2098F050000012274E564AF");
            ((BaseCase)doc).setStatusId(this.getDefaultStatusId(statusList));
        } else if (doc instanceof ExternalDocument) {
            statusList = (StatusList)this.configEngine.getList("0009A47DD30D261C0000012110DFE58C");
            ((ExternalDocument)doc).setStatusId(this.getDefaultStatusId(statusList));
        } else if (doc instanceof Memo) {
            statusList = (StatusList)this.configEngine.getList("00F9E89D6203E1AB00000121159B3979");
            ((Memo)doc).setStatusId(this.getDefaultStatusId(statusList));
        } else if (doc instanceof Email) {
            statusList = (StatusList)this.configEngine.getList("221003FD1A49F6E10000013775389FFF");
            ((Email)doc).setStatusId(this.getDefaultStatusId(statusList));
        } else {
            throw new SelfServiceException("Method is not available for type: " + doc.getClass().getName());
        }
    }

    private String getDefaultStatusId(StatusList list) throws SelfServiceException {
        this.throwIfNull(list, "The supplied status list is null");
        String defaultStatusId = list.getDefaultId();
        this.throwIfNotValid(defaultStatusId, "No default status is defined for statuslist: " + list.getSubject());
        return defaultStatusId;
    }

    private final void doPreSaveFormCase(SubDocument doc, FormCase fc) throws SelfServiceException, HookInException, RuntimeException {
        MetaData meta;
        FormTemplate ft = this.formEngine.getFormTemplate(fc.getFormtemplateId(), false);
        if (ft != null && ft.getFormCaseProcessHookIn() instanceof IFormCaseProcessHookIn) {
            if (doc != null) {
                ft.getFormCaseProcessHookIn().doPreSave(doc, fc);
            } else {
                ft.getFormCaseProcessHookIn().doPreSave(fc);
            }
        }
        if (ft != null && (meta = ft.getMetaDataByKey(CaseNameHookin)) != null && StringUtil.isValid(meta.getValue()) && !meta.isDeleted()) {
            boolean isTemplatePrefix = ft.getMetaDataByKey(UseCaseNamePrefix) != null && "true".equals(ft.getMetaDataByKey(UseCaseNamePrefix).getValue());
            SubjectHookin caseRenameHookin = new SubjectHookin(meta.getValue(), isTemplatePrefix);
            if (doc != null) {
                caseRenameHookin.doPreSave(doc, fc);
            } else {
                caseRenameHookin.doPreSave(fc);
            }
        }
    }

    private final void doPostSaveFormCase(SubDocument doc, FormCase fc) throws SelfServiceException, HookInException, RuntimeException {
        MetaData meta;
        FormTemplate ft = this.formEngine.getFormTemplate(fc.getFormtemplateId(), false);
        if (ft != null && ft.getFormCaseProcessHookIn() instanceof IFormCaseProcessHookIn) {
            if (doc != null) {
                ft.getFormCaseProcessHookIn().doPostSave(doc, fc);
            } else {
                ft.getFormCaseProcessHookIn().doPostSave(fc);
            }
        }
        if (ft != null && (meta = ft.getMetaDataByKey(CaseNameHookin)) != null && StringUtil.isValid(meta.getValue()) && !meta.isDeleted()) {
            boolean isTemplatePrefix = ft.getMetaDataByKey(UseCaseNamePrefix) != null && "true".equals(ft.getMetaDataByKey(UseCaseNamePrefix).getValue());
            SubjectHookin caseRenameHookin = new SubjectHookin(meta.getValue(), isTemplatePrefix);
            if (doc != null) {
                caseRenameHookin.doPostSave(doc, fc);
            } else {
                caseRenameHookin.doPostSave(fc);
            }
        }
    }

    private final void doPreSaveCase(SubDocument doc, Case cc) throws HookInException, SQLException {
        CaseTemplate ct = this.dalc.getCaseTemplate(cc.getCaseTemplateId());
        if (ct != null && ct.getCaseProcessHookIn() instanceof ICaseProcessHookIn) {
            if (doc != null) {
                ct.getCaseProcessHookIn().doPreSave(doc, cc);
            } else {
                ct.getCaseProcessHookIn().doPreSave(cc);
            }
        }
    }

    private final void doPostSaveCase(SubDocument doc, Case cc) throws HookInException, SQLException {
        CaseTemplate ct = this.dalc.getCaseTemplate(cc.getCaseTemplateId());
        if (ct != null && ct.getCaseProcessHookIn() instanceof ICaseProcessHookIn) {
            if (doc != null) {
                ct.getCaseProcessHookIn().doPostSave(doc, cc);
            } else {
                ct.getCaseProcessHookIn().doPostSave(cc);
            }
        }
    }

    private final boolean createQueueEntry(BaseDocument doc, Organization org) throws SelfServiceException {
        if (RemoteGoPro.isNOPDataStore(org.getEndpoint().getGoproType())) {
            return false;
        }
        if (doc instanceof FormCase) {
            FormCase fc = (FormCase)doc;
            if (fc.isSent() && !fc.isSignaturePending()) {
                RoutingQueueEntry entry = new RoutingQueueEntry(fc.getId(), fc.getOrganizationId(), RoutingQueueEntry.DocumentType.CASE);
                entry.setResend(fc.isReOpened());
                return this.queueEngine.createRoutingQueueEntry(entry);
            }
        } else if (doc instanceof SubDocument) {
            if (doc instanceof ApplicationForm) {
                return false;
            }
            SubDocument sub = (SubDocument)doc;
            if (sub.isSent() && !sub.isFromGoPro()) {
                BaseCase parentCase = this.getCase(sub.getCaseId());
                if (parentCase instanceof FormCase && parentCase.isSignaturePending()) {
                    return false;
                }
                RoutingQueueEntry entry = new RoutingQueueEntry(sub.getId(), parentCase.getOrganizationId(), RoutingQueueEntry.DocumentType.SUBDOCUMENT);
                return this.queueEngine.createRoutingQueueEntry(entry);
            }
        }
        return false;
    }

    private final synchronized String createReferenceNumber() throws SelfServiceException {
        try {
            String SerialNumberKey = "case.serial.number";
            ConfigEntry entry = this.configEngine.getConfigByKey("case.serial.number");
            if (entry == null) {
                throw new SelfServiceException("The config entry for Serial Number Store is missing!");
            }
            Integer counter = Integer.valueOf(entry.getValue());
            return ReferenceNumberGenerator.createReferenceNumber(counter);
        }
        catch (Exception ex) {
            throw new SelfServiceException(ex);
        }
    }

    private void setCaseMetadata(List<? extends BaseCase> list) throws SQLException {
        boolean isMetadataInViewsEnabled = "true".equalsIgnoreCase(SelfServiceEngine.getConfig("web.views.metadata"));
        if (isMetadataInViewsEnabled) {
            Vector<String> collectionIds = BaseDocumentUtil.getCollectionIds(list);
            List<MetaData> metadataList = this.dalc.getMetData(collectionIds);
            Hashtable<String, BaseCase> bucket = new Hashtable<String, BaseCase>();
            for (BaseCase baseCase : list) {
                bucket.put(baseCase.getId(), baseCase);
            }
            for (MetaData metaData : metadataList) {
                ((BaseCase)bucket.get(metaData.getReferenceId())).getMetadata().add(metaData);
            }
        }
    }

    private void updateParentResponseCount(SubDocument doc) throws SQLException, SelfServiceException {
        if (doc.getCaseId().equals(doc.getParentId())) {
            int responseCount = this.dalc.getCaseResponseCount(doc.getParentId());
            this.dalc.updateResponseCount(BaseCase.class, doc.getCaseId(), responseCount);
        } else {
            SubDocument parentDoc = this.getSubDocument(doc.getParentId(), false);
            this.throwIfNull(parentDoc, "The parent document was not found when updating the response counter!");
            int responseCount = this.dalc.getResponseCount(parentDoc.getClass(), doc.getParentId());
            this.dalc.updateResponseCount(parentDoc.getClass(), parentDoc.getId(), responseCount);
        }
    }

    private List<SubDocument> findReponseDocumentChain(List<SubDocument> list, String parentId) {
        ArrayList<SubDocument> responseList = new ArrayList<SubDocument>();
        for (SubDocument doc : list) {
            if (!parentId.equals(doc.getParentId())) continue;
            responseList.add(doc);
            responseList.addAll(this.findReponseDocumentChain(list, doc.getId()));
        }
        return responseList;
    }

    private void setACL(IAccessControlled doc) throws SQLException {
        if (doc instanceof BaseDocument) {
            doc.getAccessControlList().addAll(this.dalc.getAccessControlList(((BaseDocument)((Object)doc)).getId()));
        }
    }

    private void setResponseDocumentsACL(List<SubDocument> documentList) throws SQLException {
        Vector<String> collectionIds = BaseDocumentUtil.getCollectionIds(documentList);
        List<AccessControl> accessControlList = this.dalc.getAccessControlList(collectionIds);
        HashMap<String, SubDocument> map = new HashMap<String, SubDocument>(documentList.size());
        for (SubDocument doc : documentList) {
            map.put(doc.getId(), doc);
        }
        for (AccessControl acl : accessControlList) {
            ((SubDocument)map.get(acl.getDocumentId())).getAccessControlList().add(acl);
        }
    }

    private void setCasesACL(List<? extends BaseCase> documentList) throws SQLException {
        Vector<String> collectionIds = BaseDocumentUtil.getCollectionIds(documentList);
        List<AccessControl> accessControlList = this.dalc.getAccessControlList(collectionIds);
        HashMap<String, BaseCase> map = new HashMap<String, BaseCase>(documentList.size());
        for (BaseCase baseCase : documentList) {
            map.put(baseCase.getId(), baseCase);
        }
        for (AccessControl accessControl : accessControlList) {
            ((BaseCase)map.get(accessControl.getDocumentId())).getAccessControlList().add(accessControl);
        }
    }

    private void saveAccessControl(String documentId, List<AccessControl> accessControlList) throws SQLException {
        this.removeDuplicateAccessControlEntries(accessControlList);
        Iterator<AccessControl> it = accessControlList.iterator();
        while (it.hasNext()) {
            AccessControl acl = it.next();
            if (AccessControl.Permission.NONE.getValue() != acl.getBitmask()) continue;
            it.remove();
        }
        this.dalc.createAccessControl(documentId, accessControlList, false);
    }

    private void updateAccessControl(String documentId, List<AccessControl> accessControlList) throws SQLException {
        this.removeDuplicateAccessControlEntries(accessControlList);
        Iterator<AccessControl> it = accessControlList.iterator();
        while (it.hasNext()) {
            AccessControl acl = it.next();
            if (AccessControl.Permission.NONE.getValue() != acl.getBitmask()) continue;
            it.remove();
        }
        this.dalc.createAccessControl(documentId, accessControlList, true);
    }

    private void removeDuplicateAccessControlEntries(List<AccessControl> accessControlList) {
        if (accessControlList.size() > 0) {
            HashMap duplicateMap = new HashMap();
            for (AccessControl acl : accessControlList) {
                if (duplicateMap.containsKey(acl.getEntityId())) {
                    ((List)duplicateMap.get(acl.getEntityId())).add(acl);
                    continue;
                }
                ArrayList<AccessControl> list = new ArrayList<AccessControl>();
                list.add(acl);
                duplicateMap.put(acl.getEntityId(), list);
            }
            for (List aclList : duplicateMap.values()) {
                if (aclList.size() <= 1) continue;
                int maxBitmask = this.getHighestBitmask(aclList);
                for (AccessControl acl : aclList) {
                    if (acl.getBitmask() >= maxBitmask) continue;
                    accessControlList.remove(acl);
                }
            }
            ArrayList<String> entityIdList = new ArrayList<String>();
            Iterator<AccessControl> it = accessControlList.iterator();
            while (it.hasNext()) {
                AccessControl acl = it.next();
                if (!StringUtil.isValid(acl.getEntityId())) {
                    it.remove();
                    continue;
                }
                if (entityIdList.contains(acl.getEntityId())) {
                    it.remove();
                    continue;
                }
                entityIdList.add(acl.getEntityId());
            }
        }
    }

    private int getHighestBitmask(List<AccessControl> list) {
        int bitmask = 0;
        for (AccessControl acl : list) {
            if (acl.getBitmask() <= bitmask) continue;
            bitmask = acl.getBitmask();
        }
        return bitmask;
    }
}

