/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.hookins;

import java.util.HashMap;
import net.gopro.selfservice.IFormCaseProcessHookIn;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.CompletedFormDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.exceptions.FormException;
import net.gopro.selfservice.exceptions.HookInException;
import net.gopro.selfservice.forms.util.FormsUtil;
import net.gopro.selfservice.services.FormService;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.XPath;

public class SubjectHookin
implements IFormCaseProcessHookIn {
    private String fieldName = null;
    private boolean isTemplatePrefix = false;

    public SubjectHookin() {
    }

    public SubjectHookin(String fieldname, boolean isTemplatePrefix) {
        this.fieldName = fieldname;
        this.isTemplatePrefix = isTemplatePrefix;
    }

    @Override
    public void doPreSave(FormCase formCase) throws HookInException {
        try {
            FormTemplate ft;
            Document doc;
            byte[] data;
            ApplicationForm form;
            if (this.fieldName == null) {
                this.fieldName = SelfServiceEngine.getConfig("namehookin." + formCase.getFormtemplateId());
            }
            if (this.fieldName != null && (form = formCase.getApplicationForm()) != null && (data = form.getStream()) != null && data.length > 0 && (doc = FormsUtil.createDocument(data)) != null && (ft = FormService.getFormTemplate(formCase.getFormtemplateId(), false)) != null) {
                Node valueNode = null;
                if (ft.getSchemaVersion() >= 2.0) {
                    HashMap<String, String> uris = new HashMap<String, String>();
                    uris.put("gpf", "http://rep.gopro.net/gpf/xml/schemas/");
                    String xpathQuery = "//gpf:*[@id='" + this.fieldName + "']/gpf:value";
                    XPath xpath = doc.createXPath(xpathQuery);
                    xpath.setNamespaceURIs(uris);
                    valueNode = xpath.selectSingleNode((Object)doc.getRootElement());
                } else {
                    String xpath = "//FIELD[@NAME='" + this.fieldName + "']/VALUE";
                    valueNode = doc.selectSingleNode(xpath);
                }
                if (valueNode != null) {
                    String caseSubject = ft.getSubject();
                    String valueText = valueNode.getText().trim();
                    if (!"".equals(valueText)) {
                        caseSubject = this.isTemplatePrefix ? ft.getSubject() + " / " + valueText : valueText;
                    }
                    formCase.setSubject(caseSubject);
                }
            }
        }
        catch (FormException ex) {
            throw new HookInException(ex);
        }
        catch (SelfServiceException ex) {
            throw new HookInException(ex);
        }
    }

    @Override
    public void doPreSave(SubDocument doc, FormCase parentCase) throws HookInException {
        try {
            FormTemplate ft;
            if (doc instanceof CompletedFormDocument && (ft = FormService.getFormTemplate(parentCase.getFormtemplateId(), false)) != null) {
                doc.setSubject(ft.getSubject());
                ((CompletedFormDocument)doc).setFileName(ft.getSubject(), "pdf");
            }
        }
        catch (SelfServiceException ex) {
            throw new HookInException(ex);
        }
    }

    @Override
    public void doPostSave(FormCase formCase) throws HookInException {
    }

    @Override
    public void doPostSave(SubDocument doc, FormCase parentCase) throws HookInException {
    }

    @Override
    public void doPreSend(FormCase formCase, IFormCaseProcessHookIn.RecordAction action) throws HookInException {
    }

    @Override
    public void doPreSend(SubDocument doc, FormCase parentCase, IFormCaseProcessHookIn.RecordAction action) throws HookInException {
    }

    @Override
    public void doPostSend(FormCase formCase, IFormCaseProcessHookIn.RecordAction action) throws HookInException {
    }

    @Override
    public void doPostSend(SubDocument doc, FormCase parentCase, IFormCaseProcessHookIn.RecordAction action) throws HookInException {
    }
}

