/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.gdf.helpers;

import java.util.Date;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.ListValueRefType;
import net.gopro.gdf.data.MemoType;
import net.gopro.gdf.data.MetaDataType;
import net.gopro.gdf.data.types.CommunicationCodeType;
import net.gopro.gdf.data.types.MetaValueType;
import net.gopro.selfservice.data.Memo;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.gopro.GoProClientBaseReference;
import net.gopro.selfservice.exceptions.GoProDataStoreException;
import net.gopro.selfservice.gdf.RestHelper;
import net.gopro.selfservice.gdf.helpers.GDFMetadata;

public final class RESTMemo {
    public static final MemoType createMemoType(Organization org, String goproParentId, Memo memo, User user, GoProClientBaseReference clientRef) throws GoProDataStoreException {
        MemoType m = (MemoType)RestHelper.getDocumentInitiationData(org, 1028, goproParentId, null);
        m.setID("00000000-0000-0000-0000-000000000000");
        m.setSubject(memo.getSubject());
        m.setBody(memo.getBody());
        m.setCreationDate(new Date(memo.getDateCreated()));
        m.setModifiedDate(new Date(memo.getDateModified()));
        m.setDirection(CommunicationCodeType.INCOMING);
        m.setPersonalSensitive(memo.isPersonalSensitive());
        if (m.getStatus() == null) {
            ListValueRefType lStatus = new ListValueRefType();
            lStatus.setName("");
            m.setStatus(lStatus);
        }
        GDFMetadata.setMetadata(memo, (DocumentBaseType)m);
        MetaDataType mt = new MetaDataType();
        mt.setName("SelfServiceId");
        mt.setValue(memo.getId());
        mt.setValueType(MetaValueType.STRING);
        m.addMetaDataEntry(mt);
        return m;
    }
}

