/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.gdf.helpers;

import is.hugvit.log.Log;
import net.gopro.gdf.data.AddressType;
import net.gopro.gdf.data.BinaryFilterExpressionType;
import net.gopro.gdf.data.CompanyType;
import net.gopro.gdf.data.DocumentFilterType;
import net.gopro.gdf.data.FilterExpressionType;
import net.gopro.gdf.data.FlexibleDataSetType;
import net.gopro.gdf.data.types.DeleteStatusType;
import net.gopro.gdf.data.types.FilterOperatorType;
import net.gopro.gdf.data.types.HiddenStatusType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.exceptions.GoProDataStoreException;
import net.gopro.selfservice.gdf.RestHelper;
import net.gopro.selfservice.gdf.helpers.RESTAddress;

public final class RESTCompany {
    private static final Log logger = SelfServiceEngine.getLogger();

    public static final String createCompany(Organization organization, Company com) throws GoProDataStoreException {
        String goproId = null;
        try {
            goproId = RESTCompany.lookupCompany(organization, com);
            if (goproId != null) {
                return goproId;
            }
            CompanyType comType = RESTCompany.createCompanyType(organization, com);
            goproId = RestHelper.createCompany(organization, comType);
            if (goproId == null) {
                throw new GoProDataStoreException("Could not create Company, Service returned null");
            }
        }
        catch (GdfServiceException ex) {
            throw new GoProDataStoreException((Exception)((Object)ex));
        }
        return goproId;
    }

    private static final CompanyType createCompanyType(Organization organization, Company com) throws GoProDataStoreException, GdfServiceException {
        CompanyType type = (CompanyType)RestHelper.getDocumentInitiationData(organization, 1008, null, null);
        type.setSubject(com.getName());
        AddressType addressType = RESTAddress.createAddressType(organization, com.getAddress());
        if (type.getAddressesCount() == 1) {
            type.setAddress(0, addressType);
        } else {
            type.addAddress(addressType);
        }
        return type;
    }

    private static String lookupCompany(Organization organization, Company com) throws GoProDataStoreException, GdfServiceException {
        String companyId = null;
        DocumentFilterType filter = new DocumentFilterType();
        filter.setID("00000000-0000-0000-0000-000000000000");
        filter.setSubject("");
        filter.setDocumentFormType(1008);
        filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
        filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
        BinaryFilterExpressionType nameFilter = new BinaryFilterExpressionType();
        nameFilter.setPropertyName("_subject");
        nameFilter.setOperator(FilterOperatorType.EQUAL);
        nameFilter.setValue((Object)com.getName());
        filter.setCustomFilter((FilterExpressionType)nameFilter);
        FlexibleDataSetType dataset = RestHelper.query(organization, filter);
        if (dataset != null && dataset.getData().getRowsCount() > 0) {
            companyId = dataset.getData().getRow(0).getID();
            logger.info("Found existing Company in the Remote GoPro");
        } else {
            logger.info("Company does not already exist in the Remote GoPro, needs to be created.");
        }
        return companyId;
    }
}

