/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.gdf;

import java.util.List;
import net.gopro.gdf.data.BinaryFilterExpressionType;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.DocumentCollectionType;
import net.gopro.gdf.data.DocumentFilterType;
import net.gopro.gdf.data.FilterExpressionType;
import net.gopro.gdf.data.ListType;
import net.gopro.gdf.data.ListValueType;
import net.gopro.gdf.data.types.DeleteStatusType;
import net.gopro.gdf.data.types.DocumentStateType;
import net.gopro.gdf.data.types.FilterOperatorType;
import net.gopro.gdf.data.types.HiddenStatusType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.gdf.ws.proxy.DocumentService;
import net.gopro.selfservice.exceptions.GoProDataStoreException;

public final class GDFDataHelper {
    public static final String GoProNullID = "00000000-0000-0000-0000-000000000000";
    public static final String COMMUNITY_ID = "CommunityId";
    public static final String SELFSERVICE_ID = "SelfServiceId";

    public static final <T> T getDocumentInitiationData(DocumentService service, int documentType, String parentId, String templateId) throws GdfServiceException, GoProDataStoreException {
        DocumentCollectionType dc = service.getDocumentInitiationData(parentId, documentType, templateId);
        DocumentBaseType baseType = null;
        if (dc == null || dc.getDocumentsCount() != 1) {
            throw new GoProDataStoreException("GDF Initiation data is missing or invalid!");
        }
        baseType = dc.getDocument(0);
        return (T)baseType;
    }

    public static final <T> T getDocument(DocumentService service, int documentType, String documentId) throws GdfServiceException {
        DocumentFilterType filter = new DocumentFilterType();
        filter.setID(GoProNullID);
        filter.setSubject("");
        filter.setDocumentFormType(documentType);
        filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
        filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
        filter.addFilterDocumentID(documentId);
        DocumentBaseType baseType = null;
        DocumentCollectionType coll = service.getDocuments(filter, DocumentStateType.UNCHANGED);
        if (coll != null && coll.getDocumentsCount() == 1) {
            baseType = coll.getDocument(0);
        }
        return (T)baseType;
    }

    public static ListType getList(DocumentService service, String listTypeName) throws GdfServiceException {
        ListType listType = null;
        DocumentFilterType filter = new DocumentFilterType();
        filter.setDocumentFormType(1016);
        filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
        filter.setID(GoProNullID);
        filter.setSubject("");
        BinaryFilterExpressionType customFilter = new BinaryFilterExpressionType();
        customFilter.setPropertyName("_key");
        customFilter.setOperator(FilterOperatorType.EQUAL);
        customFilter.setValue((Object)listTypeName);
        filter.setCustomFilter((FilterExpressionType)customFilter);
        DocumentCollectionType dc = service.getDocuments(filter, DocumentStateType.UNCHANGED);
        if (dc != null && dc.getDocumentsCount() == 1) {
            listType = (ListType)dc.getDocument(0);
        }
        return listType;
    }

    public static ListValueType getListValueType(String key, ListType list) {
        if (key == null) {
            return null;
        }
        if (list != null && list.getListEntriesCount() > 0) {
            for (ListValueType type : list.getListEntries()) {
                if (!key.equalsIgnoreCase(type.getName()) && !key.equalsIgnoreCase(type.getAlias())) continue;
                return type;
            }
        }
        return null;
    }

    public static ListValueType getListValueType(List<String> keylist, ListType list) {
        for (String key : keylist) {
            ListValueType lt = GDFDataHelper.getListValueType(key, list);
            if (lt == null) continue;
            return lt;
        }
        return null;
    }
}

