/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.forms.v2.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.exceptions.FormException;
import net.gopro.selfservice.forms.BaseFormTranslation;
import net.gopro.selfservice.forms.util.FormsUtil;
import net.gopro.selfservice.services.FormService;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;

public class FormTranslationImpl
extends BaseFormTranslation {
    private static final Logger logger = Logger.getLogger(FormTranslationImpl.class);
    private static Map<String, String> uris = new HashMap<String, String>();

    public FormTranslationImpl(FormTemplate template) {
        super(template);
    }

    @Override
    public Document getTranslationTemplate() throws SelfServiceException, FormException {
        FormTemplateFile templateFile = FormService.getFormTemplateFile(this.formTemplate.getId(), FormTemplateFile.Tag.DATA, true);
        if (templateFile == null) {
            throw new SelfServiceException("Invalid form template Id, No form template was found.");
        }
        Document doc = FormsUtil.createDocument(templateFile.getStream());
        Document transDoc = this.createTranslationTemplate();
        Element translationEl = (Element)transDoc.getRootElement().selectSingleNode("translation");
        XPath xpath = doc.createXPath("//gpf:page");
        xpath.setNamespaceURIs(uris);
        List pageNodes = xpath.selectNodes((Object)doc);
        for (Object pageNode : pageNodes) {
            Element el = ((Element)translationEl.selectSingleNode("pages")).addElement("page");
            el.addAttribute("key", pageNode.valueOf("@id"));
            xpath = pageNode.createXPath("gpf:label");
            xpath.setNamespaceURIs(uris);
            Node labelNode = xpath.selectSingleNode(pageNode);
            if (labelNode == null) continue;
            el.addAttribute("original", labelNode.getText());
            el.setText(labelNode.getText());
        }
        xpath = doc.createXPath("//gpf:section");
        xpath.setNamespaceURIs(uris);
        List sectionNodes = xpath.selectNodes((Object)doc);
        for (Node node : sectionNodes) {
            Element el = ((Element)translationEl.selectSingleNode("sections")).addElement("section");
            el.addAttribute("key", node.valueOf("@id"));
            xpath = node.createXPath("gpf:label");
            xpath.setNamespaceURIs(uris);
            Node labelNode = xpath.selectSingleNode((Object)node);
            if (labelNode != null) {
                el.addAttribute("original", labelNode.getText());
                el.setText(labelNode.getText());
            }
            if (!"true".equalsIgnoreCase(node.valueOf("@repeatable"))) continue;
            el.addAttribute("repeatable-label", node.valueOf("@repeatable-label"));
        }
        xpath = doc.createXPath("//gpf:section/gpf:*");
        xpath.setNamespaceURIs(uris);
        List fieldNodes = xpath.selectNodes((Object)doc);
        List<String> skipList = Arrays.asList("divider", "label");
        List<String> multiTypes = Arrays.asList("selection");
        for (Node node : fieldNodes) {
            Object placeHolder;
            if (skipList.contains(node.getName())) continue;
            String nodeKey = node.valueOf("@id");
            String fieldType = node.getName();
            Element el = ((Element)translationEl.selectSingleNode("fields")).addElement("field");
            if (nodeKey != null && !nodeKey.equals("")) {
                el.addAttribute("key", nodeKey);
            }
            el.addAttribute("type", fieldType.toLowerCase());
            Element elLabel = el.addElement("label");
            if ("message".equals(node.getName())) {
                elLabel.addCDATA(node.getText());
                if (node.valueOf("@type") != null) {
                    elLabel.addAttribute("type", node.valueOf("@type"));
                }
            } else {
                xpath = node.createXPath("gpf:label");
                xpath.setNamespaceURIs(uris);
                Node nodeLabel = xpath.selectSingleNode((Object)node);
                if (nodeLabel != null) {
                    elLabel.addAttribute("original", nodeLabel.getText());
                    elLabel.setText(nodeLabel.getText());
                }
                if (!StringUtils.isEmpty((String)(placeHolder = node.valueOf("@placeholder")))) {
                    el.addElement("placeholder").setText((String)placeHolder);
                }
                xpath = node.createXPath("gpf:helptext");
                xpath.setNamespaceURIs(uris);
                Node helpNode = xpath.selectSingleNode((Object)node);
                if (helpNode != null) {
                    Element elHelp = el.addElement("helptext");
                    elHelp.addCDATA(helpNode.getText());
                }
            }
            if (multiTypes.contains(fieldType)) {
                List<Node> optionGroupNodes = this.selectNodeList("gpf:optionGroup", node);
                placeHolder = optionGroupNodes.iterator();
                while (placeHolder.hasNext()) {
                    Node optionGroupNode = (Node)placeHolder.next();
                    Element elValue = el.addElement("option");
                    elValue.setText(optionGroupNode.valueOf("@label"));
                    elValue.addAttribute("type", "group");
                    List<Node> optionNodes = this.selectNodeList("gpf:option", optionGroupNode);
                    for (Node optionNode : optionNodes) {
                        Element elOption = el.addElement("option");
                        elOption.addAttribute("key", optionNode.valueOf("@value"));
                        elOption.setText(optionNode.getText());
                    }
                }
                List<Node> optionNodes = this.selectNodeList("gpf:option", node);
                for (Node optionNode : optionNodes) {
                    Element elValue = el.addElement("option");
                    elValue.addAttribute("key", optionNode.valueOf("@value"));
                    elValue.setText(optionNode.getText());
                }
            }
            if (!"matrix".equals(node.getName())) continue;
            xpath = node.createXPath("gpf:headers/gpf:label|gpf:options/gpf:option");
            xpath.setNamespaceURIs(uris);
            List matrixNodes = xpath.selectNodes((Object)node);
            for (Node matrixNode : matrixNodes) {
                Element elx = el.addElement(matrixNode.getName().equals("label") ? "header" : "option");
                elx.setText(matrixNode.getText());
            }
        }
        return transDoc;
    }

    @Override
    public Document translateForm(FormTemplateFile dataXmlFile, Document translationDoc) throws FormException {
        Document doc = FormsUtil.createDocument(dataXmlFile.getStream());
        Hashtable<String, String> bucket = this.getTranslationBucket(translationDoc);
        if (logger.isTraceEnabled()) {
            Set<String> ks = bucket.keySet();
            for (String s : ks) {
                logger.trace((Object)("key: " + s + " => " + bucket.get(s)));
            }
        }
        Element root = doc.getRootElement();
        String transLang = translationDoc.valueOf("//form/language/translation/@isocode");
        transLang = "en".equalsIgnoreCase(transLang) ? transLang + "-GB" : transLang + "-" + transLang.toUpperCase();
        root.addAttribute("lang", transLang);
        List<String> ignoreList = Arrays.asList("label", "divider");
        List<Node> pageNodes = this.selectNodeList("//gpf:page", (Node)root);
        for (Node pageNode : pageNodes) {
            this.translateNode(pageNode.valueOf("@id"), BaseFormTranslation.FieldType.PAGE, this.selectSingleNode("gpf:label", pageNode), bucket);
            List<Node> sectionNodes = this.selectNodeList("gpf:section", pageNode);
            for (Node sectionNode : sectionNodes) {
                this.translateNode(sectionNode.valueOf("@id"), BaseFormTranslation.FieldType.SECTION, this.selectSingleNode("gpf:label", sectionNode), bucket);
                if ("true".equalsIgnoreCase(sectionNode.valueOf("@repeatable"))) {
                    this.translateNode(sectionNode.valueOf("@id"), BaseFormTranslation.FieldType.BUTTON, sectionNode, bucket);
                }
                List<Node> fieldNodes = this.selectNodeList("gpf:*", sectionNode);
                for (Node fieldNode : fieldNodes) {
                    Node helpNode;
                    String placeHolder;
                    int i;
                    if (ignoreList.contains(fieldNode.getName())) continue;
                    this.translateNode(fieldNode.valueOf("@id"), BaseFormTranslation.FieldType.LABEL, this.selectSingleNode("gpf:label", fieldNode), bucket);
                    String fieldType = fieldNode.getName();
                    List<String> multiTypes = Arrays.asList("selection");
                    if (multiTypes.contains(fieldType)) {
                        List<Node> valueNodes = this.selectNodeList("gpf:option|gpf:optionGroup/gpf:option", fieldNode);
                        for (i = 0; i < valueNodes.size(); ++i) {
                            String optionKey = fieldNode.valueOf("@id") + "-option-" + (i + 1);
                            if (!bucket.containsKey(optionKey)) continue;
                            valueNodes.get(i).setText(bucket.get(optionKey));
                        }
                    }
                    if ("matrix".equalsIgnoreCase(fieldType)) {
                        List<Node> headerNodes = this.selectNodeList("gpf:headers/gpf:label", fieldNode);
                        for (i = 0; i < headerNodes.size(); ++i) {
                            String headerKey = fieldNode.valueOf("@id") + "-header-" + (i + 1);
                            if (!bucket.containsKey(headerKey)) continue;
                            headerNodes.get(i).setText(bucket.get(headerKey));
                        }
                        List<Node> optionNodes = this.selectNodeList("gpf:options/gpf:option", fieldNode);
                        for (int i2 = 0; i2 < optionNodes.size(); ++i2) {
                            String optionKey = fieldNode.valueOf("@id") + "-option-" + (i2 + 1);
                            if (!bucket.containsKey(optionKey)) continue;
                            optionNodes.get(i2).setText(bucket.get(optionKey));
                        }
                    }
                    if (!StringUtils.isEmpty((String)(placeHolder = fieldNode.valueOf("@placeholder")))) {
                        this.translateNode(fieldNode.valueOf("@id"), BaseFormTranslation.FieldType.PLACEHOLDER, fieldNode, bucket);
                    }
                    if ((helpNode = this.selectSingleNode("gpf:helptext", fieldNode)) == null) continue;
                    this.translateNode(fieldNode.valueOf("@id"), BaseFormTranslation.FieldType.HELPTEXT, helpNode, bucket);
                }
            }
        }
        return doc;
    }

    private Node selectSingleNode(String xpath, Node parent) {
        XPath xp = parent.createXPath(xpath);
        xp.setNamespaceURIs(uris);
        return xp.selectSingleNode((Object)parent);
    }

    private List<Node> selectNodeList(String xpath, Node parent) {
        XPath xp = parent.createXPath(xpath);
        xp.setNamespaceURIs(uris);
        return xp.selectNodes((Object)parent);
    }

    static {
        uris.put("gpf", "http://rep.gopro.net/gpf/xml/schemas/");
    }
}

