/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.forms.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.exceptions.FormException;
import net.gopro.selfservice.exceptions.GoProFormXmlErrorHandler;
import net.gopro.selfservice.forms.util.BaseFormUtil;
import net.gopro.selfservice.forms.util.IFormUtil;
import net.gopro.selfservice.util.SaxReader;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.io.DOMReader;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class GoProFormsV1Util
extends BaseFormUtil
implements IFormUtil {
    private static final Logger logger = Logger.getLogger(GoProFormsV1Util.class);
    public static final String GOPRO_FORM_SCHEMA = "http://gopro.net/_schemas/ecommunity/gopro-forms-1.2.xsd";

    @Override
    public boolean validateForm(FormTemplateFile ff) throws FormException {
        if (!"true".equals(SelfServiceEngine.getConfig("goproforms.xml.validate"))) {
            logger.warn((Object)"GoPro Forms validation is turned OFF!");
            return true;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(ff.getStream());
        try {
            SAXReader reader = SaxReader.createReader();
            ByteArrayInputStream is = new ByteArrayInputStream(ff.getStream());
            Document doc = reader.read((InputStream)is);
            is.close();
            Element root = doc.getRootElement();
            Node schemaLocation = root.selectSingleNode("@xsi:noNamespaceSchemaLocation");
            if (schemaLocation == null) {
                logger.debug((Object)"Internal schema validation");
                String externalSchema = SelfServiceEngine.getConfig("goproforms.v1.schema.external");
                String internalSchema = SelfServiceEngine.getConfig("goproforms.v1.schema.internal");
                if (externalSchema == null || internalSchema == null) {
                    throw new FormException("GoPro form schema config keys are missing!");
                }
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setValidating(false);
                dbf.setNamespaceAware(true);
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                String xsd = "/WEB-INF/" + internalSchema;
                InputStream xsdIn = SelfServiceEngine.getContext().getResourceAsStream(xsd);
                if (xsdIn == null) {
                    throw new FormException("The schema file " + xsd + " was not found!");
                }
                StreamSource schemaFile = new StreamSource(xsdIn);
                Schema schema = factory.newSchema(schemaFile);
                xsdIn.close();
                dbf.setSchema(schema);
                DocumentBuilder builder = dbf.newDocumentBuilder();
                builder.setErrorHandler(new GoProFormXmlErrorHandler());
                org.w3c.dom.Document wDoc = builder.parse(in);
                DOMReader xmlReader = new DOMReader();
                Document nDoc = xmlReader.read(wDoc);
                root = nDoc.getRootElement();
                Namespace ns = root.getNamespaceForURI("http://www.w3.org/2001/XMLSchema-instance");
                if (ns == null) {
                    root.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    root.addAttribute("xsi:noNamespaceSchemaLocation", externalSchema);
                }
                ff.setStream(nDoc.asXML().getBytes("UTF-8"));
                boolean bl = true;
                return bl;
            }
            boolean bl = this.validateDocument(in);
            return bl;
        }
        catch (IOException ex) {
            throw new FormException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new FormException(ex);
        }
        catch (SAXException ex) {
            throw new FormException(ex);
        }
        catch (DocumentException ex) {
            throw new FormException((Exception)((Object)ex));
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (Exception ex) {
                throw new FormException(ex);
            }
        }
    }

    @Override
    public void cleanForCloning(ApplicationForm form) throws SelfServiceException {
        this.removeInlineUploadReferences(form);
    }

    private void removeInlineUploadReferences(ApplicationForm form) throws SelfServiceException {
        ByteArrayInputStream is = null;
        try {
            SAXReader reader = SaxReader.createReader();
            is = new ByteArrayInputStream(form.getStream());
            Document doc = reader.read((InputStream)is);
            List nodes = doc.selectNodes("//SECTIONS/SECTION/FIELDS/FIELD[@TYPE='FILE']", ".");
            if (nodes != null && nodes.size() > 0) {
                for (Element el : nodes) {
                    Node node = el.selectSingleNode("VALUE");
                    if (node == null) continue;
                    node.detach();
                }
                form.setStream(doc.asXML().getBytes("UTF-8"));
            }
        }
        catch (DocumentException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
        catch (UnsupportedEncodingException ex) {
            throw new SelfServiceException(ex);
        }
        catch (SAXException ex) {
            throw new SelfServiceException(ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    throw new SelfServiceException(ex);
                }
            }
        }
    }
}

