/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.exceptions;

import org.apache.log4j.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GoProFormXmlErrorHandler
implements ErrorHandler {
    private static final Logger logger = Logger.getLogger(GoProFormXmlErrorHandler.class);
    private boolean isSchemaConnectionFailure = false;

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        logger.warn((Object)("GoPro forms warning: " + ex.getMessage()));
        throw new SAXException(ex);
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        logger.warn((Object)("GoPro forms error: " + ex.getMessage()));
        if (ex.getMessage() != null && ex.getMessage().contains("Failed to read schema document")) {
            this.isSchemaConnectionFailure = true;
        }
        throw new SAXException(ex);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        logger.warn((Object)("GoPro forms fatal error: " + ex.getMessage()));
        throw new SAXException(ex);
    }

    public boolean isSchemaConnectionFailure() {
        return this.isSchemaConnectionFailure;
    }
}

