/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.excel;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.excel.ExcelDataRow;
import org.dom4j.Node;

public class ExcelData {
    private List<ExcelDataRow> headers = new ArrayList<ExcelDataRow>();
    private Hashtable<String, List<Object>> data = new Hashtable();
    private String filename;
    private String sheetName;

    public ExcelData(String filename) {
        this.filename = filename;
    }

    public List<ExcelDataRow> getHeaders() {
        return this.headers;
    }

    public Hashtable<String, List<Object>> getData() {
        return this.data;
    }

    public List<Object> getData(String rowKey) {
        return this.data.get(rowKey);
    }

    public void loadFromXml(List<ExcelDataRow> rowHeaders, List<Node> list) throws SelfServiceException {
        this.headers.addAll(rowHeaders);
        for (ExcelDataRow row : rowHeaders) {
            this.data.put(row.getKey(), new ArrayList());
        }
        for (Node node : list) {
            for (ExcelDataRow row : this.headers) {
                List<Object> l;
                String key = row.getKey();
                String xmlValue = "";
                try {
                    xmlValue = node.selectSingleNode(key).getText();
                }
                catch (NullPointerException ex) {
                    xmlValue = "";
                }
                if ((l = this.data.get(key)) == null) continue;
                l.add(xmlValue);
            }
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setSheetName(String name) {
        this.sheetName = name;
    }

    public String getSheetName() {
        return this.sheetName;
    }
}

