/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data.targetgroup;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import is.hugvit.util.Util;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import javax.json.bind.annotation.JsonbTransient;
import net.gopro.selfservice.ITargetGroupGenerator;
import net.gopro.selfservice.agents.TargetGroupAgent;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.targetgroup.TargetGroupUser;
import net.gopro.selfservice.exceptions.TargetGroupException;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Element;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="_type", visible=true)
@JsonIgnoreProperties(value={"classParameters"})
public class TargetGroup
extends BaseDocument {
    public static final String SCHEDULE_GROUP = "TargetGroup";
    private String subject;
    private String description;
    private boolean isEnabled;
    private Generator generator;
    private String className;
    private String classParameters;
    private int targetGroupUserCount = 0;
    private int updateHourInterval = 24;
    private String companyId;
    private Set<TargetGroupUser> groupUsers = new HashSet<TargetGroupUser>();

    public TargetGroup() {
        this.generator = Generator.MANUAL;
        this.isEnabled = true;
    }

    public TargetGroup(ResultSet rs) throws SQLException {
        super(rs);
        this.documentId = rs.getString("targetgroup_id");
        this.subject = rs.getString("subject");
        this.description = rs.getString("description");
        this.isEnabled = rs.getInt("is_enabled") == 1;
        this.generator = Generator.valueOf(rs.getString("generator"));
        this.className = rs.getString("classname");
        this.classParameters = rs.getString("classparams");
        this.updateHourInterval = rs.getInt("runinterval");
        this.companyId = rs.getString("company_id");
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public Set<TargetGroupUser> getGroupUsers() {
        return this.groupUsers;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public void setGenerator(Generator generator) {
        this.generator = generator;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassParameters() {
        return this.classParameters;
    }

    public void setClassParameters(String classParameters) {
        this.classParameters = classParameters;
    }

    public void setParametersAsProperties(Map<String, String> params) {
        ArrayList paramList = new ArrayList();
        params.forEach((key, value) -> paramList.add(String.format("%s=%s", key, value)));
        this.classParameters = String.join((CharSequence)"\n", paramList);
    }

    public Properties getParametersAsProperties() {
        Properties props = new Properties();
        if (this.classParameters != null) {
            Vector paramList = Util.split((String)this.classParameters, (String)"\n");
            Enumeration e = paramList.elements();
            while (e.hasMoreElements()) {
                String line = (String)e.nextElement();
                int pos = line.indexOf("=");
                if (pos <= 0) continue;
                String key = line.substring(0, pos);
                String val = line.substring(pos + 1, line.length());
                props.setProperty(key.trim(), val.trim());
            }
        }
        return props;
    }

    public int getTargetGroupUserCount() {
        if (this.targetGroupUserCount > 0) {
            return this.targetGroupUserCount;
        }
        return this.groupUsers.size();
    }

    public void setTargetGroupUserCount(int targetGroupUserCount) {
        this.targetGroupUserCount = targetGroupUserCount;
    }

    public int getUpdateHourInterval() {
        return this.updateHourInterval;
    }

    public void setUpdateHourInterval(int updateHourInterval) {
        this.updateHourInterval = updateHourInterval;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    @Override
    @JsonIgnore
    @JsonbTransient
    public Element getXml() {
        Element el = super.getBaseXml("targetgroup");
        Dom4JUtil.addElement(el, "subject", this.subject);
        Dom4JUtil.addElement(el, "description", this.description);
        Dom4JUtil.addElement(el, "is_enabled", String.valueOf(this.isEnabled));
        Dom4JUtil.addElement(el, "usercount", String.valueOf(this.getTargetGroupUserCount()));
        Dom4JUtil.addElement(el, "interval", String.valueOf(this.updateHourInterval));
        Dom4JUtil.addElement(el, "company_id", this.companyId);
        return el;
    }

    @JsonIgnore
    @JsonbTransient
    public final ITargetGroupGenerator getGeneratorInstance() throws TargetGroupException {
        try {
            if (this.generator.equals((Object)Generator.CLASS) && StringUtil.isValid(this.className)) {
                return (ITargetGroupGenerator)Class.forName(this.className).newInstance();
            }
            return null;
        }
        catch (Exception ex) {
            throw new TargetGroupException(ex);
        }
    }

    @JsonIgnore
    @JsonbTransient
    public boolean scheduleJob(Scheduler scheduler) throws SchedulerException {
        if (this.isEnabled && this.generator.equals((Object)Generator.CLASS)) {
            String jobName = this.subject;
            String groupName = SCHEDULE_GROUP;
            JobDataMap map = new JobDataMap();
            map.put("id", this.documentId);
            JobDetail jobDetail = new JobDetail(jobName, SCHEDULE_GROUP, TargetGroupAgent.class);
            jobDetail.setJobDataMap(map);
            jobDetail.setName(jobName);
            Trigger trigger = this.createTrigger();
            Calendar cal = Calendar.getInstance();
            cal.add(12, new Random().nextInt(60));
            trigger.setStartTime(cal.getTime());
            trigger.setName(this.subject);
            trigger.setGroup(SCHEDULE_GROUP);
            scheduler.scheduleJob(jobDetail, trigger);
            return true;
        }
        return false;
    }

    private Trigger createTrigger() {
        Trigger trigger = null;
        trigger = this.updateHourInterval == 24 ? TriggerUtils.makeDailyTrigger((int)4, (int)new Random().nextInt(60)) : TriggerUtils.makeHourlyTrigger((int)this.updateHourInterval);
        return trigger;
    }

    public static enum Generator {
        MANUAL,
        CLASS,
        CONTACTS;

    }
}

