/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data.targetgroup;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import net.gopro.selfservice.ITargetGroupGenerator;
import net.gopro.selfservice.data.DirectoryUser;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.exceptions.TargetGroupException;

public class LdapGenerator
implements ITargetGroupGenerator {
    protected String hostname;
    protected AuthenticationType authenticationType = AuthenticationType.NONE;
    protected String username;
    protected String password;
    protected String searchBase = "";
    protected String searchFilter = "(objectclass=*)";
    protected int searchTimeLimit = 30;

    @Override
    public Properties getPropertes() throws TargetGroupException {
        Properties p = new Properties();
        p.put("hostname", "The LDAP server host. (ldap://localhost:389)");
        p.put("authtype", "The authentication method. (None, Simple, SSL, SASL)");
        p.put("username", "The Bind username if using authentication");
        p.put("password", "The Bind password if using authentication");
        p.put("searchbase", "The LDAP search base (ou=users, dc=acme, dc=com)");
        p.put("searchfilter", "Specify custom search filter (default is " + this.searchFilter + ")");
        p.put("timelimit", "Specify search timelimit in second, default is 30");
        return p;
    }

    @Override
    public void setProperties(Properties prop) throws TargetGroupException {
        String authType;
        this.hostname = prop.getProperty("hostname");
        if (this.hostname == null) {
            throw new TargetGroupException("The hostname is missing");
        }
        if (prop.getProperty("searchbase") != null) {
            this.searchBase = prop.getProperty("searchbase");
        }
        if (prop.getProperty("searchfilter") != null) {
            this.searchFilter = prop.getProperty("searchfilter");
        }
        if (prop.getProperty("timelimit") != null) {
            this.searchTimeLimit = Integer.valueOf(prop.getProperty("timelimit"));
        }
        if ((authType = prop.getProperty("authtype")) != null) {
            try {
                this.authenticationType = AuthenticationType.valueOf(authType.toUpperCase());
                this.username = prop.getProperty("username");
                this.password = prop.getProperty("password");
            }
            catch (Exception ex) {
                throw new TargetGroupException("Invalid authentication type defined");
            }
            if (this.username == null || this.password == null) {
                throw new TargetGroupException("username and password is required for the selected authentication type.");
            }
        }
    }

    @Override
    public List<DirectoryUser> getAudience(TargetGroup group) throws TargetGroupException {
        try {
            ArrayList<DirectoryUser> list = new ArrayList<DirectoryUser>();
            NamingEnumeration<SearchResult> results = this.search();
            while (results.hasMore()) {
                SearchResult result = results.next();
                Attributes attributes = result.getAttributes();
                NamingEnumeration<String> en = attributes.getIDs();
                DirectoryUser user = new DirectoryUser();
                while (en.hasMoreElements()) {
                    String attributeKey = (String)en.nextElement();
                    Attribute attribute = attributes.get(attributeKey);
                    String key = attribute.getID();
                    Object value = attribute.get();
                    if (key.equals("mail") || key.equals("email")) {
                        user.setEmail(String.valueOf(value));
                        continue;
                    }
                    if (key.equals("cn")) {
                        user.setFullName(String.valueOf(value));
                        continue;
                    }
                    if (key.equals("o")) {
                        user.setOrganization(String.valueOf(value));
                        continue;
                    }
                    if (key.equalsIgnoreCase("postalcode")) {
                        user.setPostcode(String.valueOf(value));
                        continue;
                    }
                    if (key.equalsIgnoreCase("l") || key.equalsIgnoreCase("location") || key.equalsIgnoreCase("st")) {
                        user.setCity(String.valueOf(value));
                        continue;
                    }
                    if (key.equalsIgnoreCase("street")) {
                        user.setStreetName(String.valueOf(value));
                        continue;
                    }
                    if (!key.equalsIgnoreCase("c")) continue;
                    user.setCountryCode(String.valueOf(value));
                }
                list.add(user);
            }
            results.close();
            return list;
        }
        catch (NamingException ex) {
            throw new TargetGroupException(ex);
        }
    }

    @Override
    public void getAudienceCallback(List<User> userList) throws TargetGroupException {
        Iterator<User> it = userList.iterator();
        while (it.hasNext()) {
            if (!it.next().isDeleted()) continue;
            it.remove();
        }
    }

    @Override
    public String getInfo() {
        return "LDAP Directory Target Group Generator";
    }

    protected NamingEnumeration<SearchResult> search() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.hostname);
        if (this.authenticationType.equals((Object)AuthenticationType.NONE)) {
            env.put("java.naming.security.authentication", "none");
        } else {
            env.put("java.naming.security.authentication", this.authenticationType.toString().toLowerCase());
            env.put("java.naming.security.principal", this.username);
            env.put("java.naming.security.credentials", this.password);
        }
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        ctx.setRequestControls(null);
        NamingEnumeration<SearchResult> results = ctx.search(this.searchBase, this.searchFilter, this.getSimpleSearchControls());
        return results;
    }

    protected SearchControls getSimpleSearchControls() {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setTimeLimit(this.searchTimeLimit * 100);
        return searchControls;
    }

    protected static enum AuthenticationType {
        NONE,
        SIMPLE,
        SSL,
        SASL;

    }
}

