/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data.targetgroup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.gopro.gdf.data.AddressType;
import net.gopro.gdf.data.BinaryFilterExpressionType;
import net.gopro.gdf.data.DocumentCollectionType;
import net.gopro.gdf.data.DocumentFilterType;
import net.gopro.gdf.data.FilterExpressionType;
import net.gopro.gdf.data.FlexibleDataRowType;
import net.gopro.gdf.data.FlexibleDataSetType;
import net.gopro.gdf.data.IndividualType;
import net.gopro.gdf.data.MetaDataType;
import net.gopro.gdf.data.types.DeleteStatusType;
import net.gopro.gdf.data.types.DocumentStateType;
import net.gopro.gdf.data.types.FilterOperatorType;
import net.gopro.gdf.data.types.HiddenStatusType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.gdf.ws.proxy.DocumentService;
import net.gopro.selfservice.IGoProDataStore;
import net.gopro.selfservice.ITargetGroupGenerator;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.DirectoryUser;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.gopro.RemoteGoPro;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.datastore.DataStoreFactory;
import net.gopro.selfservice.datastore.RESTDataStore;
import net.gopro.selfservice.exceptions.GoProDataStoreException;
import net.gopro.selfservice.exceptions.TargetGroupException;
import net.gopro.selfservice.gdf.RestHelper;
import net.gopro.selfservice.services.ConfigService;

public class GoProNetGroupGenerator
implements ITargetGroupGenerator {
    private static final String BASE = "WebServices/Gdf/BaseDocumentWebService.asmx";
    private static final String TARGETGROUP_PARENT_ID = "456e332a-2504-43bb-b9d3-ebbabcad9afc";
    private String organizationName;
    private String targetGroupName;

    @Override
    public List<DirectoryUser> getAudience(TargetGroup group) throws TargetGroupException {
        try {
            Organization org = this.getOrganization();
            List<IndividualType> individuals = this.getClients(org);
            ArrayList<DirectoryUser> list = new ArrayList<DirectoryUser>();
            for (IndividualType ind : individuals) {
                DirectoryUser user = new DirectoryUser();
                user.setFullName(ind.getSubject());
                user.setSsn(ind.getIDNumber());
                for (MetaDataType m : ind.getMetaDataEntries()) {
                    if (!m.getName().equalsIgnoreCase("SelfServiceId")) continue;
                    user.setSelfServiceUserId(m.getValue());
                }
                if (ind.getEmailAddressesCount() > 0) {
                    user.setEmail(ind.getEmailAddress(0));
                }
                if (ind.getOrganizationUnit() != null) {
                    user.setOrganization(ind.getOrganizationUnit().getName());
                }
                if (ind.getAddressesCount() > 0) {
                    AddressType address = ind.getAddress(0);
                    user.setCity(address.getCity());
                    user.setPostcode(address.getPostCode());
                    user.setStreetName(address.getStreetName());
                    user.setStreetNumber(address.getStreetNumber());
                    if (address.getCountry() != null) {
                        user.setCountryCode(address.getCountry().getName());
                    }
                }
                list.add(user);
            }
            return list;
        }
        catch (SelfServiceException ex) {
            throw new TargetGroupException(ex);
        }
    }

    @Override
    public void getAudienceCallback(List<User> userList) throws TargetGroupException {
        Iterator<User> it = userList.iterator();
        while (it.hasNext()) {
            if (!it.next().isDeleted()) continue;
            it.remove();
        }
    }

    @Override
    public String getInfo() {
        return "GoPro Net specified Target Groups";
    }

    @Override
    public Properties getPropertes() throws TargetGroupException {
        Properties p = new Properties();
        p.put("organization", "The organization name or alias");
        p.put("targetgroup", "The Target Group name in GoPro NET");
        return p;
    }

    @Override
    public void setProperties(Properties prop) throws TargetGroupException {
        try {
            this.organizationName = prop.getProperty("organization");
            if (this.organizationName == null) {
                throw new TargetGroupException("The parameter \"organization\" is missing");
            }
            List<Organization> list = ConfigService.getOrganizations();
            boolean isValid = false;
            for (Organization o : list) {
                if (!o.getSubject().equalsIgnoreCase(this.organizationName) && !o.getAlias().equals(this.organizationName)) continue;
                isValid = true;
                if (o.getEndpoint().getGoproType().equals((Object)RemoteGoPro.GoPro.GOPRO_NET)) continue;
                throw new TargetGroupException("Target GoPro must be of type GoPro NET");
            }
            if (!isValid) {
                throw new TargetGroupException("The parameter \"organization\" is not correct. No organization by that name or alias was found.");
            }
            this.targetGroupName = prop.getProperty("targetgroup");
            if (this.targetGroupName == null) {
                throw new TargetGroupException("The parameter \"targetgroup\" is missing");
            }
        }
        catch (SelfServiceException ex) {
            throw new TargetGroupException(ex);
        }
    }

    private final Organization getOrganization() throws TargetGroupException {
        try {
            Organization org = null;
            List<Organization> organizationList = ConfigService.getOrganizations();
            for (Organization organization : organizationList) {
                if (!organization.getSubject().equalsIgnoreCase(this.organizationName) && !organization.getAlias().equalsIgnoreCase(this.organizationName)) continue;
                org = organization;
                break;
            }
            if (org == null) {
                throw new TargetGroupException("The specified organization (" + this.organizationName + ") was not found!");
            }
            if (!org.getEndpoint().getGoproType().equals((Object)RemoteGoPro.GoPro.GOPRO_NET)) {
                throw new TargetGroupException("Target GoPro must be of type GoPro NET");
            }
            return org;
        }
        catch (SelfServiceException ex) {
            throw new TargetGroupException(ex);
        }
    }

    private IGoProDataStore getDataStore(Organization org) throws SelfServiceException {
        try {
            return DataStoreFactory.getDataStore(org.getEndpoint());
        }
        catch (GoProDataStoreException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private DocumentService getService(Organization org) throws SelfServiceException {
        String documentServiceUrl = org.getEndpoint().getHostname();
        String authUsername = org.getEndpoint().getUsername();
        String authPassword = org.getEndpoint().getPassword();
        if (documentServiceUrl == null) {
            throw new SelfServiceException("GoPro Service Url is missing for the organization!");
        }
        if (authUsername == null) {
            throw new SelfServiceException("GoPro username is missing for the organization!");
        }
        if (authPassword == null) {
            throw new SelfServiceException("GoPro password is missing for the organization!");
        }
        documentServiceUrl = documentServiceUrl + BASE;
        return new DocumentService(documentServiceUrl, authUsername, authPassword, false);
    }

    private List<IndividualType> getClients(Organization org) throws TargetGroupException, SelfServiceException {
        try {
            String targetGroupId;
            ArrayList<IndividualType> indList = new ArrayList<IndividualType>();
            IGoProDataStore store = this.getDataStore(org);
            DocumentService service = null;
            if (!(store instanceof RESTDataStore)) {
                service = this.getService(org);
            }
            if ((targetGroupId = this.getTargetGroupId(org, service)) == null) {
                throw new TargetGroupException("No Target Group was found with the name: " + this.targetGroupName);
            }
            DocumentFilterType filter = this.getClientsFilter(targetGroupId);
            FlexibleDataSetType headers = null;
            headers = service != null ? service.getDocumentHeaders(filter) : RestHelper.query(org, filter);
            if (headers != null && headers.getData() != null && headers.getData().getRowsCount() > 0) {
                for (FlexibleDataRowType row : headers.getData().getRows()) {
                    String individualId = row.getID();
                    IndividualType ind = this.getIndividual(individualId, org, service);
                    if (ind == null) continue;
                    indList.add(ind);
                }
            }
            return indList;
        }
        catch (GdfServiceException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
        catch (GoProDataStoreException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private IndividualType getIndividual(String individualId, Organization org, DocumentService service) throws GoProDataStoreException, GdfServiceException {
        if (service != null) {
            DocumentFilterType filter = new DocumentFilterType();
            filter.setID("00000000-0000-0000-0000-000000000000");
            filter.setSubject("");
            filter.setDocumentFormType(1009);
            filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
            filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
            filter.addFilterDocumentID(individualId);
            DocumentCollectionType coll = service.getDocuments(filter, DocumentStateType.UNCHANGED);
            if (coll != null && coll.getDocumentsCount() == 1) {
                IndividualType individualType = (IndividualType)coll.getDocument(0);
                return individualType;
            }
            return null;
        }
        return RestHelper.getIndividual(org, individualId);
    }

    private DocumentFilterType getClientsFilter(String targetGroupId) {
        DocumentFilterType filter = new DocumentFilterType();
        filter.setID("00000000-0000-0000-0000-000000000000");
        filter.setSubject("");
        filter.setDocumentFormType(1009);
        filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
        filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
        BinaryFilterExpressionType exFilter = new BinaryFilterExpressionType();
        exFilter.setPropertyName("_groups[CategoryRefType]._objData[CategoryType]._ID");
        exFilter.setOperator(FilterOperatorType.CONTAINSONE);
        exFilter.addInValue((Object)targetGroupId);
        filter.setCustomFilter((FilterExpressionType)exFilter);
        return filter;
    }

    private String getTargetGroupId(Organization org, DocumentService service) throws GdfServiceException, GoProDataStoreException, TargetGroupException {
        DocumentFilterType filter = this.getTargetGroupIdFilter();
        FlexibleDataSetType headers = null;
        headers = service != null ? service.getDocumentHeaders(filter) : RestHelper.query(this.getOrganization(), filter);
        if (headers != null && headers.getData() != null && headers.getData().getRowsCount() > 0) {
            for (FlexibleDataRowType row : headers.getData().getRows()) {
                String groupName = row.getColumnValue(0);
                if (!groupName.equalsIgnoreCase(this.targetGroupName)) continue;
                return row.getID();
            }
        }
        return null;
    }

    private DocumentFilterType getTargetGroupIdFilter() {
        DocumentFilterType filter = new DocumentFilterType();
        filter.setID("00000000-0000-0000-0000-000000000000");
        filter.setSubject("");
        filter.setDocumentFormType(1013);
        filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
        filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
        filter.setLoadDefaultColumns(false);
        filter.setLoadColumns(Arrays.asList("_subject"));
        BinaryFilterExpressionType topParentFilter = new BinaryFilterExpressionType();
        topParentFilter.setOperator(FilterOperatorType.EQUAL);
        topParentFilter.setPropertyName("_topParentID");
        topParentFilter.setValue((Object)TARGETGROUP_PARENT_ID);
        filter.setCustomFilter((FilterExpressionType)topParentFilter);
        return filter;
    }
}

