/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data.routing;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import net.gopro.selfservice.util.Dom4JUtil;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class QueueLogEntry {
    private String queueId;
    private Level logLevel;
    private long timestamp;
    private String message;
    private String stacktrace;

    public QueueLogEntry(String queueId, Level level, String message) {
        this.queueId = queueId;
        this.logLevel = level;
        this.message = message;
        this.timestamp = new Date().getTime();
    }

    public QueueLogEntry(String queueId, Level level, Exception ex) {
        this.queueId = queueId;
        this.logLevel = level;
        this.timestamp = new Date().getTime();
        this.message = ex.getMessage();
        this.setStacktrace(ex);
    }

    public QueueLogEntry(ResultSet rs) throws SQLException {
        this.queueId = rs.getString("queue_id");
        this.message = rs.getString("message");
        this.timestamp = rs.getTimestamp("stamp").getTime();
        this.stacktrace = rs.getString("stacktrace");
        int iLevel = rs.getInt("level");
        if (iLevel == Level.ERROR.getLevel()) {
            this.logLevel = Level.ERROR;
        } else if (iLevel == Level.WARN.getLevel()) {
            this.logLevel = Level.WARN;
        } else if (iLevel == Level.INFO.getLevel()) {
            this.logLevel = Level.INFO;
        }
    }

    public String getQueueId() {
        return this.queueId;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public String getMessage() {
        return this.message;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getStacktrace() {
        return this.stacktrace;
    }

    public void setStacktrace(String stacktrace) {
        this.stacktrace = stacktrace;
    }

    public void setStacktrace(Exception ex) {
        if (ex != null) {
            StringWriter result = new StringWriter();
            PrintWriter printWriter = new PrintWriter(result);
            ex.printStackTrace(printWriter);
            this.stacktrace = ((Object)result).toString();
        }
    }

    public Element getXml() {
        Element el = DocumentHelper.createElement((String)"log");
        el.addAttribute("id", this.queueId);
        el.addAttribute("level", String.valueOf(this.logLevel.getLevel()));
        el.addAttribute("type", this.logLevel.toString());
        Dom4JUtil.addElement(el, "message", this.message);
        Dom4JUtil.addCDATAElement(el, "stacktrace", this.stacktrace);
        return el;
    }

    public static enum Level {
        INFO(1),
        WARN(2),
        ERROR(3);

        private int level;

        private Level(int c) {
            this.level = c;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

