/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.json.bind.annotation.JsonbTransient;
import net.gopro.selfservice.data.AccessControl;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.CheckoutTicket;
import net.gopro.selfservice.data.CompletedFormDocument;
import net.gopro.selfservice.data.Email;
import net.gopro.selfservice.data.IAccessControlled;
import net.gopro.selfservice.data.Memo;
import net.gopro.selfservice.data.SignedFormDocument;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Element;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="_type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Email.class, name="email"), @JsonSubTypes.Type(value=Memo.class, name="memo"), @JsonSubTypes.Type(value=Attachment.class, name="attachment"), @JsonSubTypes.Type(value=ApplicationForm.class, name="applicationForm"), @JsonSubTypes.Type(value=CompletedFormDocument.class, name="completedForm"), @JsonSubTypes.Type(value=SignedFormDocument.class, name="signedForm")})
public abstract class SubDocument
extends BaseDocument
implements IAccessControlled {
    protected String caseId;
    protected String parentId;
    protected String createdById;
    protected String goProId;
    protected String statusId;
    protected String statusText;
    protected String subject;
    protected String body;
    protected long dateCompleted;
    protected String completedById;
    protected String modifiedById;
    protected boolean isSent;
    protected boolean isFromGoPro = false;
    protected boolean isPersonalSensitive = false;
    protected int responseCount = 0;
    protected List<AccessControl> accessControlList = new ArrayList<AccessControl>();
    protected String authorName;
    protected int saveCounter = 0;
    protected CheckoutTicket checkoutTicket = null;
    private boolean isParentIdDirty = false;

    public SubDocument() {
    }

    protected SubDocument(ResultSet rs) throws SQLException {
        super(rs);
        this.caseId = rs.getString("case_id");
        this.parentId = rs.getString("parent_id");
        this.createdById = rs.getString("createdby_id");
        this.goProId = rs.getString("gopro_id");
        this.statusId = rs.getString("status_id");
        this.subject = rs.getString("subject");
        this.body = rs.getString("body");
        this.isSent = rs.getInt("is_sent") == 1;
        this.isFromGoPro = rs.getInt("is_fromgopro") == 1;
        this.isPersonalSensitive = rs.getInt("is_sensitive") == 1;
        this.saveCounter = rs.getInt("savecounter");
        this.responseCount = rs.getInt("responsecount");
        Timestamp tsCompleted = rs.getTimestamp("completed");
        if (tsCompleted != null) {
            this.dateCompleted = tsCompleted.getTime();
        }
        this.modifiedById = rs.getString("modifiedby_id");
        this.completedById = rs.getString("completedby_id");
    }

    public SubDocument(String caseId) {
        this.caseId = caseId;
    }

    public String getCaseId() {
        return this.caseId;
    }

    public void setCaseId(String caseId) {
        this.caseId = caseId;
    }

    public String getParentId() {
        if (this.parentId != null) {
            return this.parentId;
        }
        if (this.caseId != null) {
            return this.caseId;
        }
        return null;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getStatusId() {
        return this.statusId;
    }

    public void setStatusId(String statusId) {
        this.statusId = statusId;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public void setCreatedById(String userId) {
        this.createdById = userId;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getGoProId() {
        return this.goProId;
    }

    public void setGoProId(String goProId) {
        this.goProId = goProId;
    }

    public boolean isSent() {
        return this.isSent;
    }

    public void setSent(boolean isSent) {
        this.isSent = isSent;
    }

    public boolean isPersonalSensitive() {
        return this.isPersonalSensitive;
    }

    public void setPersonalSensitive(boolean isPersonalSensitive) {
        this.isPersonalSensitive = isPersonalSensitive;
    }

    @Override
    public List<AccessControl> getAccessControlList() {
        return this.accessControlList;
    }

    public long getDateCompleted() {
        return this.dateCompleted;
    }

    public void setDateCompleted(long dateCompleted) {
        this.dateCompleted = dateCompleted;
    }

    public String getCompletedById() {
        return this.completedById;
    }

    public void setCompletedById(String completedById) {
        this.completedById = completedById;
    }

    public String getModifiedById() {
        return this.modifiedById;
    }

    public void setModifiedById(String modifiedById) {
        this.modifiedById = modifiedById;
    }

    public boolean isFromGoPro() {
        return this.isFromGoPro;
    }

    public void setFromGoPro(boolean isFromGoPro) {
        this.isFromGoPro = isFromGoPro;
    }

    public int getSaveCounter() {
        return this.saveCounter;
    }

    public int getResponseCount() {
        return this.responseCount;
    }

    public boolean isCheckedOut() {
        return this.checkoutTicket != null && this.checkoutTicket.isCheckedOut();
    }

    public CheckoutTicket getCheckoutTicket() {
        return this.checkoutTicket;
    }

    public void setCheckoutTicket(CheckoutTicket checkoutTicket) {
        this.checkoutTicket = checkoutTicket;
    }

    public boolean isParentIdDirty() {
        return this.isParentIdDirty;
    }

    public void setParentIdDirty(boolean isParentIdDirty) {
        this.isParentIdDirty = isParentIdDirty;
    }

    public int incrementSaveCounter() {
        ++this.saveCounter;
        return this.getSaveCounter();
    }

    @Override
    @JsonbTransient
    protected Element getBaseXml(String rootName) {
        Element el = super.getBaseXml(rootName);
        if (this.isFromGoPro) {
            el.addAttribute("direction", "in");
        } else {
            el.addAttribute("direction", "out");
        }
        Dom4JUtil.addElement(el, "case_id", this.caseId);
        Dom4JUtil.addElement(el, "parent_id", this.parentId);
        Dom4JUtil.addElement(el, "author_id", this.createdById);
        Dom4JUtil.addElement(el, "authorname", this.authorName);
        Dom4JUtil.addElement(el, "modifiedby_id", this.modifiedById);
        Dom4JUtil.addElement(el, "savecounter", String.valueOf(this.saveCounter));
        Dom4JUtil.addElement(el, "responsecount", String.valueOf(this.responseCount));
        Dom4JUtil.addElement(el, "subject", this.subject);
        Dom4JUtil.addElement(el, "is_sent", String.valueOf(this.isSent));
        Dom4JUtil.addElement(el, "is_sensitive", String.valueOf(this.isPersonalSensitive));
        Dom4JUtil.addElement(el, "status_id", String.valueOf(this.statusId));
        if (StringUtil.isValid(this.statusText)) {
            Dom4JUtil.addElement(el, "status", String.valueOf(this.statusText));
        }
        if (this.body != null) {
            Dom4JUtil.addCDATAElement(el, "body", this.body.replaceAll("\\n", "<br/>"));
        }
        if (this.isSent) {
            el.addElement("completed").setText(LocaleUtil.formatDateShort(this.dateCompleted));
            el.addElement("completed_alt").setText(LocaleUtil.formatDate(this.dateCompleted));
            Dom4JUtil.addElement(el, "completedby_id", this.completedById);
        }
        this.setACLXml(el, this.accessControlList);
        return el;
    }

    @JsonProperty(value="_type")
    public String get_type() {
        return this.getClass().getSimpleName();
    }
}

