/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.json.bind.annotation.JsonbTransient;
import net.gopro.selfservice.data.ListItem;
import net.gopro.selfservice.util.Dom4JUtil;
import org.dom4j.Element;

public class StatusListItem
extends ListItem {
    private Status status;

    public StatusListItem() {
        this.status = Status.ACTIVE;
    }

    public StatusListItem(String subject, String alias) {
        super(subject, alias);
    }

    public StatusListItem(String subject, String alias, Status status) {
        super(subject, alias);
        this.status = status;
    }

    public StatusListItem(ResultSet rs) throws SQLException {
        super(rs);
        this.status = Status.valueOf(rs.getString("status"));
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    @JsonIgnore
    @JsonbTransient
    public Element getXml() {
        Element el = super.getXml();
        Dom4JUtil.addElement(el, "status", this.status.toString());
        return el;
    }

    public static enum Status {
        ACTIVE,
        COMPLETED,
        LOCKED;

    }
}

