/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.json.bind.annotation.JsonbTransient;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.util.Dom4JUtil;
import org.dom4j.Element;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class Message
extends BaseDocument {
    private String recipientId;
    private String createdById;
    private String parentId;
    private String subject;
    private String body;
    private String senderName;
    private boolean isRead;
    private String templateKey;

    public Message() {
        this.isRead = false;
    }

    public Message(String recipientId, String subject, String body) {
        this.recipientId = recipientId;
        this.subject = subject;
        this.body = body;
    }

    public Message(ResultSet rs) throws SQLException {
        super(rs);
        this.documentId = rs.getString("message_id");
        this.recipientId = rs.getString("recipient_id");
        this.createdById = rs.getString("createdby_id");
        this.parentId = rs.getString("parent_id");
        this.subject = rs.getString("subject");
        this.body = rs.getString("body");
        this.senderName = rs.getString("sender");
        this.isRead = rs.getInt("is_read") == 1;
    }

    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public void setCreatedById(String createdById) {
        this.createdById = createdById;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public void setRead(boolean isRead) {
        this.isRead = isRead;
    }

    public boolean isRead() {
        return this.isRead;
    }

    public String getTemplateKey() {
        return this.templateKey;
    }

    public void setTemplateKey(String templateKey) {
        this.templateKey = templateKey;
    }

    public int getAgeInDays() {
        LocalDate now = new LocalDate();
        LocalDate created = new LocalDate(this.dateCreated);
        return Days.daysBetween((ReadablePartial)created, (ReadablePartial)now).getDays();
    }

    @Override
    @JsonIgnore
    @JsonbTransient
    public Element getXml() {
        Element el = super.getBaseXml("message");
        Dom4JUtil.addElement(el, "subject", this.subject);
        Dom4JUtil.addElement(el, "is_read", String.valueOf(this.isRead));
        Dom4JUtil.addElement(el, "createdby_id", this.createdById);
        Dom4JUtil.addElement(el, "sender", this.senderName);
        if (this.body != null) {
            Dom4JUtil.addCDATAElement(el, "body", this.body.replaceAll("\\n", "<br/>"));
        }
        return el;
    }
}

