/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.json.bind.annotation.JsonbTransient;
import net.gopro.selfservice.IFormQuery;
import net.gopro.selfservice.IFormTemplateRenderer;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.exceptions.FormTemplateException;
import net.gopro.selfservice.impl.processors.LotusFormQueryProcessor;
import net.gopro.selfservice.impl.renderers.LotusFormRenderer;
import org.dom4j.Element;

public class LotusFormTemplate
extends FormTemplate {
    private Class FormRenderer = LotusFormRenderer.class;

    @Override
    @JsonIgnore
    @JsonbTransient
    public IFormQuery getFormQueryProcessor() {
        if (this.getCustomFormQueryClass() != null) {
            return this.getCustomFormQueryClass();
        }
        return new LotusFormQueryProcessor();
    }

    @Override
    @JsonIgnore
    @JsonbTransient
    public IFormTemplateRenderer getFormRenderEngine() throws RuntimeException {
        try {
            return (IFormTemplateRenderer)Class.forName(this.FormRenderer.getName()).newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    @JsonIgnore
    @JsonbTransient
    public Element getXml() {
        Element el = super.getBaseXml("formtemplate");
        return el;
    }

    @Override
    public boolean validate() throws FormTemplateException {
        super.validateBaseData();
        if (this.templateFiles.size() != 1) {
            throw new FormTemplateException("Only 1 formtemplate file can be used with Lotus Forms");
        }
        FormTemplateFile ff = (FormTemplateFile)this.templateFiles.get(0);
        if (!ff.getType().equals((Object)FormTemplateFile.Type.XFDL)) {
            throw new FormTemplateException("The file must be of Type: XFDL");
        }
        return true;
    }
}

