/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.json.bind.annotation.JsonbTransient;
import net.gopro.selfservice.IFormQuery;
import net.gopro.selfservice.IFormTemplateRenderer;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.exceptions.FormException;
import net.gopro.selfservice.exceptions.FormTemplateException;
import net.gopro.selfservice.forms.util.FormsUtil;
import net.gopro.selfservice.impl.processors.GoProFormV1QueryProcessor;
import net.gopro.selfservice.impl.processors.GoProFormV2QueryProcessor;
import net.gopro.selfservice.impl.renderers.GoProFormV1Renderer;
import net.gopro.selfservice.impl.renderers.GoProFormV2Renderer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;

@JsonIgnoreProperties(value={"formQueryProcessor", "formRenderEngine"})
public class GoProFormTemplate
extends FormTemplate {
    @Override
    @JsonIgnore
    @JsonbTransient
    public IFormQuery getFormQueryProcessor() {
        if (this.getCustomFormQueryClass() != null) {
            return this.getCustomFormQueryClass();
        }
        double schemaVersion = this.getSchemaVersion();
        if (schemaVersion >= 2.0 && schemaVersion < 3.0) {
            return new GoProFormV2QueryProcessor();
        }
        return new GoProFormV1QueryProcessor();
    }

    @Override
    @JsonIgnore
    @JsonbTransient
    public IFormTemplateRenderer getFormRenderEngine() throws RuntimeException {
        try {
            double schemaVersion = this.getSchemaVersion();
            if (schemaVersion >= 2.0 && schemaVersion < 3.0) {
                return (IFormTemplateRenderer)Class.forName(GoProFormV2Renderer.class.getName()).newInstance();
            }
            return (IFormTemplateRenderer)Class.forName(GoProFormV1Renderer.class.getName()).newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    @JsonIgnore
    @JsonbTransient
    public Element getXml() {
        Element el = super.getBaseXml("formtemplate");
        return el;
    }

    @Override
    public boolean validate() throws FormTemplateException {
        super.validateBaseData();
        if (this.templateFiles.size() != 3) {
            throw new FormTemplateException("3 formtemplate files are required with GoPro Forms");
        }
        FormTemplateFile dataFile = this.getFormTemplateFile(FormTemplateFile.Tag.DATA);
        if (dataFile == null) {
            throw new FormTemplateException("No form template data file is included");
        }
        return true;
    }

    public Hashtable<String, String> getSections() throws FormException {
        Hashtable<String, String> ht;
        block2: {
            Document doc;
            block3: {
                ht = new Hashtable<String, String>();
                doc = FormsUtil.getApplicationForm(this);
                if (doc == null) break block2;
                double schemaVersion = this.getSchemaVersion();
                if (!(schemaVersion >= 2.0) || !(schemaVersion < 3.0)) break block3;
                HashMap<String, String> uris = new HashMap<String, String>();
                uris.put("gpf", "http://rep.gopro.net/gpf/xml/schemas/");
                XPath xpath = doc.createXPath("//gpf:section/gpf:label");
                xpath.setNamespaceURIs(uris);
                List list = xpath.selectNodes((Object)doc);
                for (Element node : list) {
                    ht.put(node.getParent().valueOf("@id"), node.getText());
                }
                break block2;
            }
            String xpath = "//sections/section/sectionlabel";
            List nodeList = doc.selectNodes("//sections/section/sectionlabel".toUpperCase());
            if (nodeList == null || nodeList.size() <= 0) break block2;
            for (Node node : nodeList) {
                String sectionLabel = node.getText();
                String sectionID = node.getParent().valueOf("@ID");
                ht.put(sectionID, sectionLabel);
            }
        }
        return ht;
    }

    public List<String> getOrderedSections() throws FormException {
        ArrayList<String> sections;
        block2: {
            Document doc;
            block3: {
                sections = new ArrayList<String>();
                doc = FormsUtil.getApplicationForm(this);
                if (doc == null) break block2;
                double schemaVersion = this.getSchemaVersion();
                if (!(schemaVersion >= 2.0) || !(schemaVersion < 3.0)) break block3;
                HashMap<String, String> uris = new HashMap<String, String>();
                uris.put("gpf", "http://rep.gopro.net/gpf/xml/schemas/");
                XPath xpath = doc.createXPath("//gpf:section/gpf:label");
                xpath.setNamespaceURIs(uris);
                List list = xpath.selectNodes((Object)doc);
                for (Element el : list) {
                    sections.add(el.getText());
                }
                break block2;
            }
            String xpath = "//sections/section/sectionlabel";
            List nodeList = doc.selectNodes("//sections/section/sectionlabel".toUpperCase());
            if (nodeList == null || nodeList.size() <= 0) break block2;
            for (Node node : nodeList) {
                sections.add(node.getText());
            }
        }
        return sections;
    }

    @JsonbTransient
    @JsonIgnore
    public Element getSectionsAsElement() throws FormException {
        Element els;
        block2: {
            int loopCounter;
            Document doc;
            block3: {
                els = DocumentHelper.createElement((String)"sections");
                doc = FormsUtil.getApplicationForm(this);
                if (doc == null) break block2;
                loopCounter = 1;
                double schemaVersion = this.getSchemaVersion();
                if (!(schemaVersion >= 2.0) || !(schemaVersion < 3.0)) break block3;
                HashMap<String, String> uris = new HashMap<String, String>();
                uris.put("gpf", "http://rep.gopro.net/gpf/xml/schemas/");
                XPath xpath = doc.createXPath("//gpf:section/gpf:label");
                xpath.setNamespaceURIs(uris);
                List list = xpath.selectNodes((Object)doc);
                for (Element fel : list) {
                    Element el = els.addElement("section");
                    el.addAttribute("id", "section-" + loopCounter);
                    el.addAttribute("visible", fel.getParent().valueOf("@visible").equals("false") ? "false" : "true");
                    el.setText(fel.getText());
                    ++loopCounter;
                }
                break block2;
            }
            String xpath = "//sections/section/sectionlabel";
            List nodeList = doc.selectNodes("//sections/section/sectionlabel".toUpperCase());
            if (nodeList == null || nodeList.size() <= 0) break block2;
            for (Node node : nodeList) {
                Element el = els.addElement("section");
                el.addAttribute("id", "section-" + loopCounter);
                el.setText(node.getText());
                ++loopCounter;
            }
        }
        return els;
    }

    public static enum FieldType {
        TEXT,
        LISTBOX,
        RADIO,
        CHECKBOX,
        TEXTAREA,
        FILE,
        DATE,
        MATRIX,
        BLOCK,
        BLOCKHEADER,
        DIVIDER;

    }

    public static enum GoProFormType {
        GOPRO_FORM_V1,
        GOPRO_FORM_V2;

    }
}

