/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.bind.annotation.JsonbTransient;
import net.gopro.selfservice.IFormCaseProcessHookIn;
import net.gopro.selfservice.IFormQuery;
import net.gopro.selfservice.IFormTemplateRenderer;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.FormGuidance;
import net.gopro.selfservice.data.FormTemplateExtras;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.data.FormTranslation;
import net.gopro.selfservice.data.GoProFormTemplate;
import net.gopro.selfservice.data.LotusFormTemplate;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SecondaryForm;
import net.gopro.selfservice.exceptions.FormTemplateException;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Element;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="_type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=GoProFormTemplate.class, name="GoProFormTemplate"), @JsonSubTypes.Type(value=LotusFormTemplate.class, name="LotusFormTemplate")})
@JsonIgnoreProperties(value={"isPostSendUsingViewFilter"})
public abstract class FormTemplate
extends BaseDocument {
    protected String subject;
    protected String description;
    protected String category;
    protected long dateValidTo;
    protected long dateValidFrom;
    protected double schemaVersion;
    protected boolean isVisible = true;
    protected boolean isMemoVisible = true;
    protected boolean isAttachmentVisible = true;
    protected boolean isResendEnabled = false;
    protected boolean isSignatureRequired = false;
    protected boolean isPersonalSensitive = false;
    protected String resendStatusId = null;
    protected String messageTemplateId = null;
    protected Restriction restriction = Restriction.NONE;
    protected FormTemplateExtras extendedData = null;
    protected List<FormTemplateFile> templateFiles = new ArrayList<FormTemplateFile>();
    protected List<FormGuidance> guidances = new ArrayList<FormGuidance>();
    protected List<FormTranslation> translations = new ArrayList<FormTranslation>();
    private String language = null;
    protected List<Organization> organizations = new ArrayList<Organization>();
    protected Map<String, String> linkMap = new HashMap<String, String>();
    protected boolean isFreeToSend = true;
    protected boolean isPostSendUsingViewFilter = false;
    protected boolean isSecondaryEnabled = false;
    protected SecondaryCaseHandling secondaryHandling = SecondaryCaseHandling.CREATE_AND_LINK;
    protected List<SecondaryForm> secondaryReferences = new ArrayList<SecondaryForm>();

    public FormTemplate() {
    }

    public FormTemplate(ResultSet rs) throws SQLException {
        super(rs);
    }

    @JsonIgnore
    @JsonbTransient
    public abstract IFormTemplateRenderer getFormRenderEngine();

    @JsonIgnore
    @JsonbTransient
    public abstract IFormQuery getFormQueryProcessor();

    @JsonIgnore
    @JsonbTransient
    public abstract boolean validate() throws FormTemplateException;

    public void loadInstance(ResultSet rs) throws SQLException {
        this.documentId = rs.getString("template_id");
        this.subject = rs.getString("subject");
        this.description = rs.getString("description");
        this.category = rs.getString("category");
        this.isVisible = rs.getInt("is_visible") == 1;
        this.isMemoVisible = rs.getInt("is_memos") == 1;
        this.isAttachmentVisible = rs.getInt("is_attachments") == 1;
        this.isPostSendUsingViewFilter = rs.getInt("is_postsendfilter") == 1;
        this.isResendEnabled = rs.getInt("is_resend") == 1;
        this.isSignatureRequired = rs.getInt("is_signature") == 1;
        this.isPersonalSensitive = rs.getInt("is_sensitive") == 1;
        this.resendStatusId = rs.getString("resendstatus_id");
        this.messageTemplateId = rs.getString("message_id");
        Timestamp tsValidFrom = rs.getTimestamp("valid_from");
        Timestamp tsValidTo = rs.getTimestamp("valid_to");
        if (tsValidFrom != null && tsValidTo != null) {
            this.dateValidFrom = tsValidFrom.getTime();
            this.dateValidTo = tsValidTo.getTime();
        }
        this.isDeleted = rs.getInt("is_deleted") == 1;
        this.dateCreated = rs.getTimestamp("created").getTime();
        this.dateModified = rs.getTimestamp("modified").getTime();
        this.restriction = Restriction.of(rs.getInt("restriction"));
        this.schemaVersion = rs.getDouble("version");
        this.isSecondaryEnabled = rs.getInt("is_secondary") == 1;
        this.secondaryHandling = SecondaryCaseHandling.of(rs.getInt("sec_handle"));
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public long getDateValidTo() {
        return this.dateValidTo;
    }

    public void setDateValidTo(long dateValidTo) {
        this.dateValidTo = dateValidTo;
    }

    public long getDateValidFrom() {
        return this.dateValidFrom;
    }

    public void setDateValidFrom(long dateValidFrom) {
        this.dateValidFrom = dateValidFrom;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isMemoVisible() {
        return this.isMemoVisible;
    }

    public void setMemoVisible(boolean isMemoVisible) {
        this.isMemoVisible = isMemoVisible;
    }

    public boolean isAttachmentVisible() {
        return this.isAttachmentVisible;
    }

    public void setAttachmentVisible(boolean isAttachmentVisible) {
        this.isAttachmentVisible = isAttachmentVisible;
    }

    public boolean isPersonalSensitive() {
        return this.isPersonalSensitive;
    }

    public void setPersonalSensitive(boolean isPersonalSensitive) {
        this.isPersonalSensitive = isPersonalSensitive;
    }

    public double getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(double version) {
        this.schemaVersion = version;
    }

    public List<FormTemplateFile> getTemplateFiles() {
        return this.templateFiles;
    }

    public FormTemplateFile getFormTemplateFile(FormTemplateFile.Tag tag) {
        for (FormTemplateFile ff : this.templateFiles) {
            if (!ff.getTag().equals((Object)tag)) continue;
            return ff;
        }
        return null;
    }

    public FormTemplateFile getFormTemplateFile(String fileId) {
        for (FormTemplateFile ff : this.templateFiles) {
            if (!ff.getId().equals(fileId)) continue;
            return ff;
        }
        return null;
    }

    public void setTemplateFiles(List<FormTemplateFile> templateFiles) {
        this.templateFiles = templateFiles;
    }

    public List<Organization> getOrganizations() {
        return this.organizations;
    }

    public Set<String> getOrganizationIds() {
        HashSet<String> set = new HashSet<String>();
        for (Organization o : this.organizations) {
            set.add(o.getId());
        }
        return set;
    }

    public Map<String, String> getLinkMap() {
        return this.linkMap;
    }

    public Organization getOrganizationByLinkToken(String token) {
        if (token != null) {
            for (String organizationId : this.linkMap.keySet()) {
                if (!this.linkMap.get(organizationId).equals(token)) continue;
                for (Organization o : this.organizations) {
                    if (!o.getId().equals(organizationId)) continue;
                    return o;
                }
            }
        }
        return null;
    }

    public String getLinkToken(String organizationId) {
        return this.linkMap.get(organizationId);
    }

    public boolean isFreeToSend() {
        return this.isFreeToSend;
    }

    public void setFreeToSend(boolean isFreeToSend) {
        this.isFreeToSend = isFreeToSend;
    }

    public boolean isResendEnabled() {
        return this.isResendEnabled;
    }

    public void setResendEnabled(boolean isResendEnabled) {
        this.isResendEnabled = isResendEnabled;
    }

    public boolean isSignatureRequired() {
        return this.isSignatureRequired;
    }

    public void setSignatureRequired(boolean isSignatureRequired) {
        this.isSignatureRequired = isSignatureRequired;
    }

    public String getResendStatusId() {
        return this.resendStatusId;
    }

    public void setResendStatusId(String resendStatusId) {
        this.resendStatusId = resendStatusId;
    }

    public String getMessageTemplateId() {
        return this.messageTemplateId;
    }

    public void setMessageTemplateId(String messageTemplateId) {
        this.messageTemplateId = messageTemplateId;
    }

    public Restriction getRestriction() {
        return this.restriction;
    }

    public void setRestriction(Restriction restriction) {
        this.restriction = restriction;
    }

    public boolean isSecondaryEnabled() {
        return this.isSecondaryEnabled;
    }

    public void setSecondaryEnabled(boolean isSecondaryEnabled) {
        this.isSecondaryEnabled = isSecondaryEnabled;
    }

    public List<SecondaryForm> getSecondaryReferences() {
        return this.secondaryReferences;
    }

    public SecondaryCaseHandling getSecondaryHandling() {
        return this.secondaryHandling;
    }

    public void setSecondaryHandling(SecondaryCaseHandling secondaryHandling) {
        this.secondaryHandling = secondaryHandling;
    }

    public boolean isPostSendUsingViewFilter() {
        return this.isPostSendUsingViewFilter;
    }

    public void setPostSendUsingViewFilter(boolean isPostSendUsingViewFilter) {
        this.isPostSendUsingViewFilter = isPostSendUsingViewFilter;
    }

    public List<FormGuidance> getGuidances() {
        return this.guidances;
    }

    public List<FormTranslation> getTranslations() {
        return this.translations;
    }

    public final boolean isDateRestricted() {
        return this.dateValidTo > 0L && this.dateValidFrom > 0L;
    }

    public final boolean isWithinDateRestriction() {
        if (this.isDateRestricted()) {
            long now = new Date().getTime();
            return now > this.dateValidFrom && now < this.dateValidTo;
        }
        return true;
    }

    public void setLanguage(String currentLanguage) {
        this.language = currentLanguage;
    }

    public FormTemplateExtras getExtendedData() {
        return this.extendedData;
    }

    public void setExtendedData(FormTemplateExtras extendedData) {
        this.extendedData = extendedData;
    }

    @Override
    @JsonbTransient
    protected Element getBaseXml(String rootName) {
        Element el = super.getBaseXml(rootName);
        el.addAttribute("type", this.getClass().getSimpleName());
        el.addAttribute("version", String.valueOf(this.schemaVersion));
        if (this.isDateRestricted()) {
            el.addAttribute("expires", "true");
            el.addAttribute("deadline", String.valueOf(this.dateValidTo));
        } else {
            el.addAttribute("expires", "false");
        }
        if (this.language != null) {
            el.addAttribute("language", this.language);
        }
        Dom4JUtil.addElement(el, "subject", this.subject);
        Dom4JUtil.addCDATAElement(el, "description", this.description);
        Dom4JUtil.addElement(el, "category", this.category);
        Dom4JUtil.addElement(el, "is_visible", String.valueOf(this.isVisible));
        Dom4JUtil.addElement(el, "is_memos", String.valueOf(this.isMemoVisible));
        Dom4JUtil.addElement(el, "is_attachments", String.valueOf(this.isAttachmentVisible));
        Dom4JUtil.addElement(el, "is_free", String.valueOf(this.isFreeToSend));
        Dom4JUtil.addElement(el, "is_postsendfilter", String.valueOf(this.isPostSendUsingViewFilter));
        Dom4JUtil.addElement(el, "is_resend", String.valueOf(this.isResendEnabled));
        Dom4JUtil.addElement(el, "is_sensitive", String.valueOf(this.isPersonalSensitive));
        Dom4JUtil.addElement(el, "is_signature", String.valueOf(this.isSignatureRequired));
        Dom4JUtil.addElement(el, "is_secondary", String.valueOf(this.isSecondaryEnabled));
        if (this.isSecondaryEnabled) {
            Element elSec = el.addElement("secondary");
            for (SecondaryForm sf : this.secondaryReferences) {
                Element elForms = elSec.addElement("applications");
                elForms.addAttribute("id", sf.getTemplateId());
                elForms.setText(sf.getTemplateName());
            }
        }
        if (this.isResendEnabled && StringUtil.isValid(this.resendStatusId)) {
            Dom4JUtil.addElement(el, "resendstatus_id", this.resendStatusId);
        }
        if (this.restriction != null) {
            Dom4JUtil.addElement(el, "restriction", this.restriction.toString());
        }
        if (this.isDateRestricted()) {
            Dom4JUtil.addElement(el, "is_expired", String.valueOf(!this.isWithinDateRestriction()));
            DateFormat df = LocaleUtil.getTimeFormat();
            Dom4JUtil.addElement(el, "valid_from", df.format(this.dateValidFrom));
            Dom4JUtil.addElement(el, "valid_to", df.format(this.dateValidTo));
        }
        if (this.extendedData != null) {
            el.add(this.extendedData.getXml());
        }
        if (this.templateFiles.size() > 0) {
            Element elTemplates = el.addElement("formfiles");
            for (FormTemplateFile ff : this.templateFiles) {
                elTemplates.add(ff.getXml());
            }
        }
        if (this.guidances.size() > 0) {
            Element elGuidance = el.addElement("guidances");
            for (FormGuidance fg : this.guidances) {
                elGuidance.add(fg.getXml());
            }
        }
        if (this.translations.size() > 0) {
            Element elTranslation = el.addElement("translations");
            for (FormTranslation trans : this.translations) {
                elTranslation.add(trans.getXml());
            }
        }
        if (this.linkMap.size() > 0 && this.organizations.size() > 0) {
            Element elLinks = el.addElement("mapping");
            for (String key : this.linkMap.values()) {
                Organization o = this.getOrganizationByLinkToken(key);
                if (o == null) continue;
                Element elLink = elLinks.addElement("link");
                elLink.addAttribute("organization", o.getSubject());
                elLink.addAttribute("link", key);
                elLink.addAttribute("id", o.getId());
            }
        }
        return el;
    }

    protected final void validateBaseData() throws FormTemplateException {
        if (!(this.dateValidFrom == 0L && this.dateValidTo == 0L || this.isDateRestricted())) {
            throw new FormTemplateException("Both dates valid From and valid To must be defined, or leave both empty.");
        }
        if (this.isDateRestricted() && this.dateValidFrom > this.dateValidTo) {
            throw new FormTemplateException("Date from must be less than date to.");
        }
        HashSet<FormTemplateFile.Tag> checkSet = new HashSet<FormTemplateFile.Tag>();
        for (FormTemplateFile ff : this.templateFiles) {
            if (ff.getStream() == null || ff.getStream().length == 0) {
                throw new FormTemplateException("Formtemplate stream is missing");
            }
            if (ff.getTag() == null) {
                throw new FormTemplateException("Formtemplate Tag is missing");
            }
            if (ff.getType() == null) {
                throw new FormTemplateException("Formtemplate Type is missing");
            }
            if (checkSet.contains((Object)ff.getTag())) {
                throw new FormTemplateException("Only one Tag of each type is allowed. Duplicate tag found: " + ff.getTag().toString());
            }
            checkSet.add(ff.getTag());
        }
    }

    public FormGuidance getGuidance(String guidanceId) {
        for (FormGuidance fg : this.guidances) {
            if (!fg.getId().equals(guidanceId)) continue;
            return fg;
        }
        return null;
    }

    @JsonIgnore
    @JsonbTransient
    public IFormCaseProcessHookIn getFormCaseProcessHookIn() throws RuntimeException {
        try {
            Object o;
            String className;
            if (this.extendedData != null && (className = this.extendedData.getCustomClass()) != null && !"".equals(className) && (o = Class.forName(className).newInstance()) instanceof IFormCaseProcessHookIn) {
                return (IFormCaseProcessHookIn)o;
            }
            return null;
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    @JsonIgnore
    @JsonbTransient
    protected final IFormQuery getCustomFormQueryClass() throws RuntimeException {
        try {
            Object o;
            String className;
            if (this.extendedData != null && (className = this.extendedData.getCustomClass()) != null && !"".equals(className) && (o = Class.forName(className).newInstance()) instanceof IFormQuery) {
                return (IFormQuery)o;
            }
            return null;
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static enum SecondaryCaseHandling {
        CREATE_AND_LINK(0),
        RESPONSE(1);

        private int code;

        private SecondaryCaseHandling(int c) {
            this.code = c;
        }

        public int getCode() {
            return this.code;
        }

        public static SecondaryCaseHandling of(int code) {
            switch (code) {
                case 0: {
                    return CREATE_AND_LINK;
                }
                case 1: {
                    return RESPONSE;
                }
            }
            return null;
        }
    }

    public static enum Restriction {
        NONE(0),
        INDIVIDUAL(1),
        CONTACT(2);

        private int code;

        private Restriction(int c) {
            this.code = c;
        }

        public int getCode() {
            return this.code;
        }

        public static Restriction of(int code) {
            switch (code) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return INDIVIDUAL;
                }
                case 2: {
                    return CONTACT;
                }
            }
            return null;
        }
    }
}

