/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.json.bind.annotation.JsonbTransient;
import net.gopro.selfservice.ICaseProcessHookIn;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.SecondaryForm;
import net.gopro.selfservice.util.Dom4JUtil;
import org.dom4j.Element;

public class CaseTemplate
extends BaseDocument {
    private String subject;
    private String description;
    private String categoryId;
    private String categoryName;
    private int timeLimitInDays;
    private boolean isSystemTemplate;
    private boolean isVisible;
    private boolean isVisibleInDefaultView;
    private String customClass;
    protected boolean isSecondaryEnabled = false;
    protected FormTemplate.SecondaryCaseHandling secondaryHandling = FormTemplate.SecondaryCaseHandling.CREATE_AND_LINK;
    protected List<SecondaryForm> secondaryReferences = new ArrayList<SecondaryForm>();

    public CaseTemplate() {
        this.timeLimitInDays = 0;
        this.isSystemTemplate = false;
        this.isVisible = true;
        this.isVisibleInDefaultView = true;
    }

    public CaseTemplate(ResultSet rs) throws SQLException {
        super(rs);
        this.documentId = rs.getString("casetemplate_id");
        this.subject = rs.getString("subject");
        this.description = rs.getString("description");
        this.categoryId = rs.getString("category_id");
        this.timeLimitInDays = rs.getInt("timelimit");
        this.isVisible = rs.getInt("is_visible") == 1;
        this.isSystemTemplate = rs.getInt("is_system") == 1;
        this.isVisibleInDefaultView = rs.getInt("is_inview") == 1;
        this.isSecondaryEnabled = rs.getInt("is_secondary") == 1;
        this.secondaryHandling = FormTemplate.SecondaryCaseHandling.of(rs.getInt("sec_handle"));
        this.customClass = rs.getString("customclass");
    }

    public String getSubject() {
        return this.subject;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public int getTimeLimitInDays() {
        return this.timeLimitInDays;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public boolean isVisibleInDefaultView() {
        return this.isVisibleInDefaultView;
    }

    public void setVisibleInDefaultView(boolean isVisibleInDefaultView) {
        this.isVisibleInDefaultView = isVisibleInDefaultView;
    }

    public void setTimeLimitInDays(int timeLimitInDays) {
        this.timeLimitInDays = timeLimitInDays;
    }

    public boolean isSystemTemplate() {
        return this.isSystemTemplate;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setSystemTemplate(boolean isSystemTemplate) {
        this.isSystemTemplate = isSystemTemplate;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isSecondaryEnabled() {
        return this.isSecondaryEnabled;
    }

    public void setSecondaryEnabled(boolean isSecondaryEnabled) {
        this.isSecondaryEnabled = isSecondaryEnabled;
    }

    public FormTemplate.SecondaryCaseHandling getSecondaryHandling() {
        return this.secondaryHandling;
    }

    public void setSecondaryHandling(FormTemplate.SecondaryCaseHandling secondaryHandling) {
        this.secondaryHandling = secondaryHandling;
    }

    public List<SecondaryForm> getSecondaryReferences() {
        return this.secondaryReferences;
    }

    public String getCustomClass() {
        return this.customClass;
    }

    public void setCustomClass(String customClass) {
        this.customClass = customClass;
    }

    @JsonIgnore
    @JsonbTransient
    public ICaseProcessHookIn getCaseProcessHookIn() throws RuntimeException {
        try {
            Object o;
            String className;
            if (this.customClass != null && (className = this.customClass) != null && !"".equals(className) && (o = Class.forName(className).newInstance()) instanceof ICaseProcessHookIn) {
                return (ICaseProcessHookIn)o;
            }
            return null;
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    @JsonIgnore
    @JsonbTransient
    public Element getXml() {
        Element el = super.getBaseXml("casetemplate");
        Dom4JUtil.addElement(el, "subject", this.subject);
        Dom4JUtil.addCDATAElement(el, "description", this.description);
        Dom4JUtil.addElement(el, "timelimit", String.valueOf(this.timeLimitInDays));
        Dom4JUtil.addElement(el, "visible", String.valueOf(this.isVisible));
        Dom4JUtil.addElement(el, "system", String.valueOf(this.isSystemTemplate));
        Dom4JUtil.addElement(el, "inview", String.valueOf(this.isVisibleInDefaultView));
        Dom4JUtil.addElement(el, "customclass", this.customClass);
        Dom4JUtil.addCDATAElement(el, "category", this.categoryName);
        Dom4JUtil.addElement(el, "is_secondary", String.valueOf(this.isSecondaryEnabled));
        if (this.isSecondaryEnabled) {
            Element elSec = el.addElement("secondary");
            for (SecondaryForm sf : this.secondaryReferences) {
                Element elForms = elSec.addElement("applications");
                elForms.addAttribute("id", sf.getTemplateId());
                elForms.setText(sf.getTemplateName());
            }
        }
        return el;
    }
}

