/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.dalc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import net.gopro.selfservice.dalc.BaseDalc;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.AuditLog;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.DetailedLogEntry;
import net.gopro.selfservice.filters.AuditLogFilter;

public class LogDalc
extends BaseDalc {
    private static final String TBL_HISTORY = "ss_history";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLogEntry(AuditLogEntry entry) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"document_id", "user_id", "stamp", "ip", "action", "datatype"};
        String sql = this.createInsertSQL(TBL_HISTORY, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, entry.getDocumentId());
            stmt.setString(2, entry.getUserId());
            stmt.setTimestamp(3, new Timestamp(entry.getTimestamp()));
            if (entry.getIp() != null) {
                stmt.setString(4, entry.getIp());
            } else {
                stmt.setNull(4, 12);
            }
            stmt.setString(5, entry.getAction().toString());
            stmt.setString(6, entry.getDataType().toString());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuditLog getAuditLog(AuditLogFilter filter) throws SQLException {
        AuditLog auditLog;
        String uid;
        ArrayList<Object> list;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        AuditLog log = new AuditLog();
        boolean isDateFilter = true;
        ArrayList<BaseDalc.FilterParam> params = new ArrayList<BaseDalc.FilterParam>();
        String sql = "SELECT l.document_id, l.user_id, l.stamp, l.ip, l.action, l.datatype ";
        if (filter.isDetailedResults()) {
            sql = sql + ",doctitle, fullname ";
        }
        sql = sql + "FROM ss_history l ";
        if (filter.isDetailedResults()) {
            String metaQuery = "";
            if (filter.getDocumentId() != null) {
                metaQuery = "SELECT md.metadata_id AS local_id, md.datakey AS doctitle FROM ss_metadata md WHERE md.document_id = ? UNION ";
                params.add(new BaseDalc.FilterParam(12, filter.getDocumentId()));
            }
            String documentsQuery = "SELECT e.document_id AS local_id, e.subject AS doctitle FROM ss_documents e ";
            if (filter.getDocumentId() != null) {
                documentsQuery = documentsQuery + " WHERE e.document_id = ? UNION ";
                params.add(new BaseDalc.FilterParam(12, filter.getDocumentId()));
            } else {
                documentsQuery = documentsQuery + " UNION ";
            }
            sql = sql + "LEFT OUTER JOIN ( SELECT c.case_id AS local_id, c.subject AS doctitle FROM ss_cases c UNION SELECT m.memo_id AS local_id, m.subject AS doctitle FROM ss_memos m UNION " + documentsQuery + "SELECT u.user_id AS local_id, u.fullname AS doctitle FROM " + "ss_users" + " u UNION SELECT q.queue_id AS local_id, 'Queue Entry' AS doctitle FROM ss_queue q UNION SELECT me.message_id AS local_id, me.subject AS doctitle FROM ss_messages me UNION SELECT l.list_id AS local_id, l.subject AS doctitle FROM " + "ss_lists" + " l UNION SELECT li.item_id AS local_id, li.subject AS doctitle FROM " + "ss_listitems" + " li UNION SELECT co.config_id AS local_id, co.configkey AS doctitle FROM ss_config co UNION SELECT t.targetgroup_id AS local_id, t.subject AS doctitle FROM " + "ss_targetgroups" + " t UNION SELECT f.template_id AS local_id, f.subject AS doctitle FROM " + "ss_formtemplates" + " f UNION " + metaQuery + "SELECT tf.file_id AS local_id, tf.filename AS doctitle FROM ss_formfiles tf UNION SELECT an.announcement_id AS local_id, an.subject AS doctitle FROM ss_announcements an UNION SELECT ct.casetemplate_id AS local_id, ct.subject AS doctitle FROM " + "ss_casetemplates" + " ct UNION SELECT co.company_id AS local_id, co.name AS doctitle FROM " + "ss_companies" + " co UNION SELECT cont.contact_id AS local_id, u.fullname AS doctitle FROM " + "ss_contacts" + " cont INNER JOIN " + "ss_users" + " u ON cont.user_id = u.user_id UNION SELECT gd.guidance_id AS local_id, gd.subject AS doctitle FROM ss_guidance gd UNION SELECT ta.task_id AS local_id, ta.subject AS doctitle FROM ss_tasks ta UNION SELECT o.organization_id AS local_id, o.subject AS doctitle from " + "ss_organizations" + " o  ) AS ENTRIES ON ENTRIES.local_id = l.document_id LEFT OUTER JOIN " + "ss_users" + " u ON u.user_id = l.user_id";
        }
        sql = sql + " WHERE ";
        if (filter.getDocumentId() != null) {
            sql = sql + "(l.document_id = ?)";
            params.add(new BaseDalc.FilterParam(12, filter.getDocumentId()));
        }
        if (filter.getUserIds().size() > 0) {
            if (params.size() > 0) {
                sql = sql + " AND ";
            }
            sql = sql + "(";
            list = new ArrayList<String>(filter.getUserIds());
            for (int i = 0; i < list.size(); ++i) {
                uid = (String)list.get(i);
                sql = i > 0 ? sql + " OR l.user_id = ? " : sql + " l.user_id = ? ";
                params.add(new BaseDalc.FilterParam(12, uid));
            }
            sql = sql + ")";
        }
        if (filter.getActions().size() > 0) {
            if (params.size() > 0) {
                sql = sql + " AND ";
            }
            sql = sql + "(";
            list = new ArrayList<AuditLogEntry.Action>(filter.getActions());
            for (int i = 0; i < list.size(); ++i) {
                uid = ((AuditLogEntry.Action)((Object)list.get(i))).toString();
                sql = i > 0 ? sql + " OR l.action = ? " : sql + " l.action = ? ";
                params.add(new BaseDalc.FilterParam(12, uid));
            }
            sql = sql + ")";
        }
        if (filter.getDatatypes().size() > 0) {
            if (params.size() > 0) {
                sql = sql + " AND ";
            }
            sql = sql + "(";
            list = new ArrayList<AuditLogEntry.DataType>(filter.getDatatypes());
            for (int i = 0; i < list.size(); ++i) {
                uid = ((AuditLogEntry.DataType)((Object)list.get(i))).toString();
                sql = i > 0 ? sql + " OR l.datatype = ? " : sql + " l.datatype = ? ";
                params.add(new BaseDalc.FilterParam(12, uid));
            }
            sql = sql + ")";
        }
        if (filter.getDateFrom() > 0L || filter.getDateTo() > 0L) {
            if (params.size() > 0) {
                sql = sql + " AND ";
            }
            sql = sql + "(";
            if (filter.getDateFrom() > 0L && filter.getDateTo() > 0L) {
                sql = sql + " l.stamp > ? AND l.stamp < ?";
                params.add(new BaseDalc.FilterParam(93, filter.getDateFrom()));
                params.add(new BaseDalc.FilterParam(93, filter.getDateTo()));
            } else if (filter.getDateFrom() > 0L) {
                sql = sql + " l.stamp > ?";
                params.add(new BaseDalc.FilterParam(93, filter.getDateFrom()));
            } else if (filter.getDateTo() > 0L) {
                sql = sql + " l.stamp < ?";
                params.add(new BaseDalc.FilterParam(93, filter.getDateTo()));
            }
            sql = sql + ")";
        } else {
            isDateFilter = false;
        }
        if (filter.getFormTemplateId() != null) {
            boolean isIndividualCases = filter.getFormTemplateId().equals("individual-cases");
            boolean isCompanyCases = filter.getFormTemplateId().equals("company-cases");
            boolean isTargetgroupCases = filter.getFormTemplateId().equals("targetgroup-cases");
            if (isIndividualCases) {
                sql = sql + " AND (l.document_id IN (SELECT case_id FROM ss_cases WHERE formtemplate_id IS NULL AND company_id IS NULL AND targetgroup_id IS NULL) ) ";
            } else if (isCompanyCases) {
                sql = sql + " AND (l.document_id IN (SELECT case_id FROM ss_cases WHERE formtemplate_id IS NULL AND company_id IS NOT NULL) ) ";
            } else if (isTargetgroupCases) {
                sql = sql + " AND (l.document_id IN (SELECT case_id FROM ss_cases WHERE formtemplate_id IS NULL AND targetgroup_id IS NOT NULL) ) ";
            } else {
                sql = sql + " AND (l.document_id IN (SELECT case_id FROM ss_cases WHERE formtemplate_id = ?) ) ";
                params.add(new BaseDalc.FilterParam(12, filter.getFormTemplateId()));
            }
        }
        if (filter.getCaseTemplateId() != null) {
            sql = sql + " AND (l.document_id IN (SELECT case_id FROM ss_cases WHERE casetemplate_id = ?) ) ";
            params.add(new BaseDalc.FilterParam(12, filter.getCaseTemplateId()));
        }
        sql = sql + " ORDER BY l.stamp DESC";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            if (!isDateFilter) {
                stmt.setMaxRows(1000);
            }
            int paramCounter = 1;
            for (BaseDalc.FilterParam param : params) {
                if (param.getDataType() == 93) {
                    Long stamp = (Long)param.getValue();
                    stmt.setObject(paramCounter, (Object)new Timestamp(stamp), param.getDataType());
                } else {
                    stmt.setObject(paramCounter, param.getValue(), param.getDataType());
                }
                ++paramCounter;
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (filter.isDetailedResults()) {
                    log.getEntries().add(new DetailedLogEntry(rs));
                    continue;
                }
                log.getEntries().add(new AuditLogEntry(rs));
            }
            rs.close();
            auditLog = log;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return auditLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DetailedLogEntry> getCaseHistory(String caseId) throws SQLException {
        ArrayList<DetailedLogEntry> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<DetailedLogEntry> list = new ArrayList<DetailedLogEntry>();
        String sql = "SELECT l.document_id, l.user_id, l.stamp, l.ip, l.action, l.datatype, fullname, 'CASE' AS doctitle FROM ss_history l LEFT OUTER JOIN ss_users u ON u.user_id = l.user_id WHERE (l.document_id = ? OR l.document_id = ( SELECT document_id FROM ss_documents WHERE case_id = ? AND classname = ? )) AND l.action != 'READ' ORDER BY stamp DESC";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, caseId);
            stmt.setString(2, caseId);
            stmt.setString(3, ApplicationForm.class.getCanonicalName());
            rs = stmt.executeQuery();
            while (rs.next()) {
                DetailedLogEntry entry = new DetailedLogEntry(rs);
                list.add(entry);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }
}

