/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.dalc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.gopro.selfservice.dalc.BaseDalc;
import net.gopro.selfservice.data.ConfigEntry;
import net.gopro.selfservice.data.List;
import net.gopro.selfservice.data.ListItem;
import net.gopro.selfservice.data.MessageTemplate;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.Module;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.StatusList;
import net.gopro.selfservice.data.StatusListItem;
import net.gopro.selfservice.data.gopro.Endpoint;
import net.gopro.selfservice.util.ReferenceNumberGenerator;

public class ConfigDalc
extends BaseDalc {
    private static final String TBL_CONFIG = "ss_config";
    private static final String TBL_MODULES = "ss_modules";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createList(List list) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"list_id", "default_id", "subject", "description", "is_system", "is_deleted", "created", "modified"};
        String sql = this.createInsertSQL("ss_lists", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, list.getId());
            stmt.setString(2, list.getDefaultId());
            stmt.setString(3, list.getSubject());
            stmt.setString(4, list.getDescription());
            stmt.setInt(5, list.isSystemList() ? 1 : 0);
            stmt.setInt(6, list.isDeleted() ? 1 : 0);
            stmt.setTimestamp(7, new Timestamp(list.getDateCreated()));
            stmt.setTimestamp(8, new Timestamp(list.getDateModified()));
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createListItem(ListItem item) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"item_id", "list_id", "subject", "alias", "status", "is_deleted", "created", "modified"};
        String sql = this.createInsertSQL("ss_listitems", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            String status = null;
            if (item instanceof StatusListItem) {
                status = ((StatusListItem)item).getStatus().toString();
            }
            stmt.setString(1, item.getId());
            stmt.setString(2, item.getListId());
            stmt.setString(3, item.getSubject());
            stmt.setString(4, item.getAlias());
            stmt.setString(5, status);
            stmt.setInt(6, item.isDeleted() ? 1 : 0);
            stmt.setTimestamp(7, new Timestamp(item.getDateCreated()));
            stmt.setTimestamp(8, new Timestamp(item.getDateModified()));
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteListItem(ListItem item) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"is_deleted", "modified", "item_id"};
        String sql = this.createUpdateSQL("ss_listitems", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, 1);
            stmt.setTimestamp(2, new Timestamp(item.getDateModified()));
            stmt.setString(3, item.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getList(String listId, boolean isStatusList) throws SQLException {
        List list;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        List list2 = null;
        String sql = "SELECT list_id, default_id, subject, description, is_system,is_deleted, created, modified FROM ss_lists WHERE list_id = ? AND is_deleted = 0";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, listId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                list2 = isStatusList ? new StatusList(rs) : new List(rs);
            }
            rs.close();
            stmt.close();
            if (list2 != null) {
                sql = "SELECT item_id, list_id, subject, alias, status, is_deleted, created, modified FROM ss_listitems WHERE list_id = ? AND is_deleted = 0 ORDER BY subject";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, list2.getId());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    if (isStatusList) {
                        list2.getListItems().add(new StatusListItem(rs));
                        continue;
                    }
                    list2.getListItems().add(new ListItem(rs));
                }
                rs.close();
            }
            list = list2;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateList(List list) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"default_id", "subject", "description", "is_deleted", "modified", "list_id"};
        String sql = this.createUpdateSQL("ss_lists", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, list.getDefaultId());
            stmt.setString(2, list.getSubject());
            stmt.setString(3, list.getDescription());
            stmt.setInt(4, list.isDeleted() ? 1 : 0);
            stmt.setTimestamp(5, new Timestamp(list.getDateModified()));
            stmt.setString(6, list.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListItem getListItem(String listItemId, boolean isStatusList) throws SQLException {
        StatusListItem statusListItem;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ListItem listItem = null;
        String sql = "SELECT item_id, list_id, subject, alias, status, modified FROM ss_listitems WHERE item_id = ? AND is_deleted = 0 ORDER BY subject";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, listItemId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                listItem = isStatusList ? new StatusListItem(rs) : new ListItem(rs);
            }
            rs.close();
            statusListItem = listItem;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return statusListItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateListItem(ListItem listItem) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"subject", "alias", "modified", "status", "item_id"};
        String sql = this.createUpdateSQL("ss_listitems", cols);
        String status = null;
        if (listItem instanceof StatusListItem) {
            status = ((StatusListItem)listItem).getStatus().toString();
        }
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, listItem.getSubject());
            stmt.setString(2, listItem.getAlias());
            stmt.setTimestamp(3, new Timestamp(listItem.getDateModified()));
            stmt.setString(4, status);
            stmt.setString(5, listItem.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.util.List<List> getLists() throws SQLException {
        ArrayList<List> arrayList;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<List> lists = new ArrayList<List>();
        String sql = "SELECT list_id, default_id, subject, description, is_system,is_deleted, created, modified FROM ss_lists ORDER BY subject";
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String listId = rs.getString("list_id");
                if (StatusList.isStatusList(listId)) {
                    lists.add(new StatusList(rs));
                    continue;
                }
                lists.add(new List(rs));
            }
            rs.close();
            arrayList = lists;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    public void createOrganization(Organization org) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"organization_id", "subject", "alias", "cssfile", "footer", "is_signature", "certificate", "certkey", "is_enabled", "is_remote", "is_deleted", "created", "modified", "is_service", "serviceemail", "mailoptions", "customclass"};
        String sql = this.createInsertSQL("ss_organizations", cols);
        try {
            con = this.startTransaction();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, org.getId());
            stmt.setString(2, org.getSubject());
            stmt.setString(3, org.getAlias());
            stmt.setString(4, org.getCssFile());
            stmt.setString(5, org.getFooter());
            stmt.setInt(6, org.isSigning() ? 1 : 0);
            if (org.getCertificate() != null && org.getCertificate().length > 0) {
                stmt.setBinaryStream(7, (InputStream)new ByteArrayInputStream(org.getCertificate()), org.getCertificate().length);
            } else {
                stmt.setNull(7, 2004);
            }
            stmt.setString(8, org.getCertificateKey());
            stmt.setInt(9, org.isEnabled() ? 1 : 0);
            stmt.setInt(10, org.isRemoteTemplatesEnabled() ? 1 : 0);
            stmt.setInt(11, org.isDeleted() ? 1 : 0);
            stmt.setTimestamp(12, new Timestamp(org.getDateCreated()));
            stmt.setTimestamp(13, new Timestamp(org.getDateModified()));
            stmt.setInt(14, org.isServiceAccountEnabled() ? 1 : 0);
            stmt.setString(15, org.getServiceAccountEmail());
            stmt.setInt(16, org.getMailOptions());
            stmt.setString(17, org.getCustomClass());
            stmt.executeUpdate();
            stmt.close();
            Endpoint ep = org.getEndpoint();
            String[] cols2 = new String[]{"organization_id", "type", "hostname", "username", "password", "brokerdestination"};
            sql = this.createInsertSQL("ss_endpoints", cols2);
            stmt = con.prepareStatement(sql);
            stmt.setString(1, org.getId());
            stmt.setString(2, ep.getGoproType().toString());
            stmt.setString(3, ep.getHostname());
            stmt.setString(4, ep.getUsername());
            stmt.setString(5, ep.getPassword());
            stmt.setString(6, ep.getBrokerDestinationId());
            stmt.executeUpdate();
            this.commitTransaction();
        }
        catch (SQLException ex) {
            try {
                con.rollback();
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Organization getOrganization(String organizationId) throws SQLException, IOException {
        Organization organization;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Organization org = null;
        String sql = "SELECT o.organization_id, o.subject, o.alias, o.cssfile, o.footer,o.is_enabled, o.is_remote, o.is_service, o.serviceemail, o.mailoptions, o.customclass,o.is_deleted, o.created, o.modified, o.is_signature, o.certificate, o.certkey, e.type, e.hostname, e.username, e.password, e.brokerdestination FROM ss_organizations o INNER JOIN ss_endpoints e ON e.organization_id = o.organization_id WHERE o.organization_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, organizationId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                org = new Organization(rs);
                Endpoint endpoint = new Endpoint(rs);
                org.setEndpoint(endpoint);
                InputStream is = rs.getBinaryStream("certificate");
                if (is != null && is.available() > 0) {
                    byte[] bytes = new byte[is.available()];
                    is.read(bytes);
                    is.close();
                    org.setCertificate(bytes);
                    org.setCertificateKey(rs.getString("certkey"));
                }
            }
            rs.close();
            organization = org;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return organization;
    }

    public void updateOrganization(Organization org) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"subject", "alias", "cssfile", "footer", "is_signature", "certificate", "certkey", "is_enabled", "is_remote", "is_service", "serviceemail", "mailoptions", "customclass", "is_deleted", "modified", "organization_id"};
        String sql = this.createUpdateSQL("ss_organizations", cols);
        try {
            con = this.startTransaction();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, org.getSubject());
            stmt.setString(2, org.getAlias());
            stmt.setString(3, org.getCssFile());
            stmt.setString(4, org.getFooter());
            stmt.setInt(5, org.isSigning() ? 1 : 0);
            if (org.getCertificate() != null && org.getCertificate().length > 0) {
                stmt.setBinaryStream(6, (InputStream)new ByteArrayInputStream(org.getCertificate()), org.getCertificate().length);
            } else {
                stmt.setNull(6, 2004);
            }
            stmt.setString(7, org.getCertificateKey());
            stmt.setInt(8, org.isEnabled() ? 1 : 0);
            stmt.setInt(9, org.isRemoteTemplatesEnabled() ? 1 : 0);
            stmt.setInt(10, org.isServiceAccountEnabled() ? 1 : 0);
            stmt.setString(11, org.getServiceAccountEmail());
            stmt.setInt(12, org.getMailOptions());
            stmt.setString(13, org.getCustomClass());
            stmt.setInt(14, org.isDeleted() ? 1 : 0);
            stmt.setTimestamp(15, new Timestamp(org.getDateModified()));
            stmt.setString(16, org.getId());
            stmt.executeUpdate();
            stmt.close();
            Endpoint end = org.getEndpoint();
            String[] cols2 = new String[]{"type", "hostname", "username", "password", "brokerdestination", "organization_id"};
            sql = this.createUpdateSQL("ss_endpoints", cols2);
            stmt = con.prepareStatement(sql);
            stmt.setString(1, end.getGoproType().toString());
            stmt.setString(2, end.getHostname());
            stmt.setString(3, end.getUsername());
            stmt.setString(4, end.getPassword());
            stmt.setString(5, end.getBrokerDestinationId());
            stmt.setString(6, org.getId());
            stmt.executeUpdate();
            this.commitTransaction();
        }
        catch (SQLException ex) {
            try {
                con.rollback();
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.util.List<Organization> getOrganizations() throws SQLException {
        ArrayList<Organization> arrayList;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<Organization> list = new ArrayList<Organization>();
        String sql = "SELECT o.organization_id, o.subject, o.alias, o.cssfile, o.footer, o.is_signature, o.is_enabled, o.is_remote, o.is_service, o.serviceemail, o.mailoptions, o.customclass, o.is_deleted, o.created, o.modified, e.type, e.hostname, e.username, e.password, e.brokerdestination,  (SELECT COUNT(f.template_id) FROM ss_formtemplates f INNER JOIN ss_formlinks l ON l.template_id = f.template_id WHERE l.organization_id = o.organization_id AND f.is_deleted = 0) AS formcount FROM ss_organizations o INNER JOIN ss_endpoints e ON e.organization_id = o.organization_id ORDER BY o.subject ASC";
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                Organization org = new Organization(rs);
                org.setFormTemplateCount(rs.getInt("formcount"));
                Endpoint endpoint = new Endpoint(rs);
                org.setEndpoint(endpoint);
                list.add(org);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigEntry getRefNumber() throws SQLException {
        ConfigEntry configEntry;
        Connection con = null;
        PreparedStatement stmt = null;
        PreparedStatement stmtUpdate = null;
        ResultSet rs = null;
        String SerialNumberKey = "case.serial.number";
        boolean isRecurring = ReferenceNumberGenerator.isRecurring();
        String sql = "SELECT config_id, configkey, configvalue, section, is_visible, created, modified, is_deleted FROM ss_config WHERE configkey = ?";
        String[] cols = new String[]{"configvalue", "modified", "configkey"};
        String sqlUpdate = this.createUpdateSQL(TBL_CONFIG, cols);
        try {
            con = this.startTransaction();
            con.setTransactionIsolation(8);
            stmt = con.prepareStatement(sql);
            stmt.setString(1, "case.serial.number");
            rs = stmt.executeQuery();
            rs.next();
            ConfigEntry ce = new ConfigEntry(rs);
            rs.close();
            int counter = Integer.valueOf(ce.getValue());
            Calendar now = Calendar.getInstance();
            Calendar modified = Calendar.getInstance();
            modified.setTimeInMillis(ce.getDateModified());
            if (isRecurring && (now.get(1) != modified.get(1) || now.get(2) != modified.get(2))) {
                counter = 1;
                ce.setValue(String.valueOf(counter));
                ++counter;
            } else {
                ++counter;
            }
            stmtUpdate = con.prepareStatement(sqlUpdate);
            stmtUpdate.setString(1, String.valueOf(counter));
            stmtUpdate.setTimestamp(2, new Timestamp(new Date().getTime()));
            stmtUpdate.setString(3, "case.serial.number");
            stmtUpdate.executeUpdate();
            this.commitTransaction();
            configEntry = ce;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeStatement(stmtUpdate);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeStatement(stmtUpdate);
        this.closeConnection(con);
        return configEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ConfigEntry> getConfig(boolean includeDeleted) throws SQLException {
        HashSet<ConfigEntry> hashSet;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        HashSet<ConfigEntry> set = new HashSet<ConfigEntry>();
        String sql = "SELECT config_id, configkey, configvalue, section, is_visible, created, modified, is_deleted FROM ss_config";
        if (!includeDeleted) {
            sql = sql + " WHERE is_deleted = 0";
        }
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                ConfigEntry ce = new ConfigEntry(rs);
                set.add(ce);
            }
            rs.close();
            hashSet = set;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConfig(ConfigEntry entry) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"config_id", "configkey", "configvalue", "section", "is_visible", "is_deleted", "created", "modified"};
        String sql = this.createInsertSQL(TBL_CONFIG, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, entry.getId());
            stmt.setString(2, entry.getKey());
            stmt.setString(3, entry.getValue());
            stmt.setString(4, entry.getSection());
            stmt.setInt(5, entry.isVisible() ? 1 : 0);
            stmt.setInt(6, entry.isDeleted() ? 1 : 0);
            stmt.setTimestamp(7, new Timestamp(entry.getDateCreated()));
            stmt.setTimestamp(8, new Timestamp(entry.getDateModified()));
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfig(ConfigEntry entry) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"configvalue", "section", "is_visible", "modified", "is_deleted", "config_id"};
        String sql = this.createUpdateSQL(TBL_CONFIG, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, entry.getValue());
            stmt.setString(2, entry.getSection());
            stmt.setInt(3, entry.isVisible() ? 1 : 0);
            stmt.setTimestamp(4, new Timestamp(entry.getDateModified()));
            stmt.setInt(5, entry.isDeleted() ? 1 : 0);
            stmt.setString(6, entry.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListItem getListItem(String listItemId) throws SQLException {
        StatusListItem statusListItem;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ListItem item = null;
        String sql = "SELECT i.item_id, i.list_id, i.subject, i.alias, i.status, i.is_deleted, i.created, i.modified FROM ss_listitems i WHERE i.item_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, listItemId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                item = rs.getString("status") != null ? new StatusListItem(rs) : new ListItem(rs);
            }
            rs.close();
            statusListItem = item;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return statusListItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMetaDataEntry(MetaData meta) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"metadata_id", "document_id", "user_id", "datakey", "datavalue", "is_deleted", "created", "modified"};
        String sql = this.createInsertSQL("ss_metadata", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, meta.getId());
            stmt.setString(2, meta.getReferenceId());
            stmt.setString(3, meta.getUserId());
            stmt.setString(4, meta.getKey());
            stmt.setString(5, meta.getValue());
            stmt.setInt(6, meta.isDeleted() ? 1 : 0);
            stmt.setTimestamp(7, new Timestamp(meta.getDateCreated()));
            stmt.setTimestamp(8, new Timestamp(meta.getDateModified()));
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMetadataEntry(MetaData meta) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"user_id", "datakey", "datavalue", "is_deleted", "modified", "metadata_id"};
        String sql = this.createUpdateSQL("ss_metadata", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, meta.getUserId());
            stmt.setString(2, meta.getKey());
            stmt.setString(3, meta.getValue());
            stmt.setInt(4, meta.isDeleted() ? 1 : 0);
            stmt.setTimestamp(5, new Timestamp(meta.getDateModified()));
            stmt.setString(6, meta.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.util.List<Module> getModules() throws SQLException {
        ArrayList<Module> arrayList;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<Module> list = new ArrayList<Module>();
        String sql = "SELECT module_id, name, alias, classname FROM ss_modules";
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                list.add(new Module(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaData findMetaDataEntry(String referenceId, String key) throws SQLException {
        MetaData metaData;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        MetaData m = null;
        String sql = "SELECT m.metadata_id, m.document_id, m.user_id, m.datakey, m.datavalue, m.created, m.modified, m.is_deleted FROM ss_metadata m WHERE m.is_deleted = 0 AND m.document_id = ? AND m.datakey = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, referenceId);
            stmt.setString(2, key);
            rs = stmt.executeQuery();
            if (rs.next()) {
                m = new MetaData(rs);
            }
            rs.close();
            metaData = m;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMessageTemplate(MessageTemplate mt) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"template_id", "title", "description", "subject", "body", "category_id", "is_deleted", "created", "modified"};
        String sql = this.createInsertSQL("ss_messagetemplates", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, mt.getId());
            stmt.setString(2, mt.getTitle());
            stmt.setString(3, mt.getDescription());
            stmt.setString(4, mt.getSubject());
            stmt.setString(5, mt.getBody());
            stmt.setString(6, mt.getCategoryId());
            stmt.setInt(7, mt.isDeleted() ? 1 : 0);
            stmt.setTimestamp(8, new Timestamp(mt.getDateCreated()));
            stmt.setTimestamp(9, new Timestamp(mt.getDateModified()));
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMessageTemplate(MessageTemplate mt) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"title", "description", "subject", "body", "category_id", "is_deleted", "modified", "template_id"};
        String sql = this.createUpdateSQL("ss_messagetemplates", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, mt.getTitle());
            stmt.setString(2, mt.getDescription());
            stmt.setString(3, mt.getSubject());
            stmt.setString(4, mt.getBody());
            stmt.setString(5, mt.getCategoryId());
            stmt.setInt(6, mt.isDeleted() ? 1 : 0);
            stmt.setTimestamp(7, new Timestamp(mt.getDateModified()));
            stmt.setString(8, mt.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageTemplate getMessageTemplate(String templateId) throws SQLException {
        MessageTemplate messageTemplate;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        MessageTemplate mt = null;
        String sql = "SELECT m.template_id, m.title, m.description, m.subject, m.body, m.category_id, l.subject AS categoryName, m.is_deleted,m.created, m.modified FROM ss_messagetemplates m INNER JOIN ss_listitems l ON l.item_id = m.category_id WHERE m.template_id = ? AND m.is_deleted = 0 ORDER BY m.subject";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, templateId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                mt = new MessageTemplate(rs);
                mt.setBody(rs.getString("body"));
                mt.setCategoryName(rs.getString("categoryName"));
            }
            rs.close();
            messageTemplate = mt;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return messageTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.util.List<MessageTemplate> getMessageTemplates() throws SQLException {
        ArrayList<MessageTemplate> arrayList;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<MessageTemplate> templates = new ArrayList<MessageTemplate>();
        String sql = "SELECT m.template_id, m.title, m.description, m.subject, m.category_id, l.subject AS categoryName, m.is_deleted,m.created, m.modified, COUNT(t.template_id) AS usageCount FROM ss_messagetemplates m INNER JOIN ss_listitems l ON l.item_id = m.category_id LEFT JOIN ss_formtemplates t ON m.template_id = t.message_id GROUP BY m.template_id, m.title, m.description, m.subject, m.category_id, l.subject, m.is_deleted, m.created, m.modified ORDER BY m.subject";
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                MessageTemplate mt = new MessageTemplate(rs);
                mt.setCategoryName(rs.getString("categoryName"));
                mt.setUsageCount(rs.getInt("usageCount"));
                templates.add(mt);
            }
            rs.close();
            arrayList = templates;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }
}

