/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.agents;

import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdFile;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.CompletedFormDocument;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.exceptions.CaseException;
import net.gopro.selfservice.exceptions.SaveConflictException;
import net.gopro.selfservice.filters.DocumentFilter;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.SearchService;
import net.gopro.selfservice.util.ImpersonationUtil;
import net.gopro.selfservice.util.LocaleUtil;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DataRetentionPolicyAgent
implements Job {
    private static final Logger logger = Logger.getLogger(DataRetentionPolicyAgent.class);
    private static final String birdCustomPdfFileName = "retention";
    private int deletedCases = 0;
    private int deletedFiles = 0;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            ImpersonationUtil.impersonate();
            logger.info((Object)"Data Retention Policy Agent running");
            if (this.isEnabled()) {
                int daysOfRetention = this.getRetentionDays();
                if (daysOfRetention > 0) {
                    logger.info((Object)String.format("Data Retention Policy Agent running. Cases and files more than %d days old will be purged.", daysOfRetention));
                    this.doRetention(daysOfRetention);
                    logger.info((Object)String.format("Agent completed. Deleted cases: %d, deleted documents: %d", this.deletedCases, this.deletedFiles));
                } else {
                    logger.warn((Object)"Data Retention Policy Agent days in misconfigured.  Please check selfservice-config.xml");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)ex);
            throw new JobExecutionException((Throwable)ex);
        }
        finally {
            ImpersonationUtil.destroy();
        }
    }

    private void doRetention(int daysOfRetention) throws SelfServiceException, CaseException, SaveConflictException {
        List<Organization> organizationList = ConfigService.getOrganizations();
        for (Organization org : organizationList) {
            logger.info((Object)String.format("Running retention agent for organization: %s", org.getSubject()));
            this.doRetention(daysOfRetention, org.getId());
        }
    }

    private void doRetention(int daysOfRetention, String organisationId) throws SelfServiceException, CaseException, SaveConflictException {
        Calendar calTo = Calendar.getInstance();
        calTo.add(6, -daysOfRetention);
        DateFormat df = LocaleUtil.getDateFormat();
        logger.info((Object)String.format("Deleting cases and documents created before: %s", df.format(calTo.getTime())));
        DocumentFilter filter = new DocumentFilter();
        filter.addDocumentType(BaseCase.class);
        filter.setOrganizationId(organisationId);
        filter.setDeletionStatus(DocumentFilter.DeletionStatus.NOT_DELETED);
        filter.setCreatedDateTo(calTo.getTime());
        List<BaseDocument> caseList = SearchService.getDocuments(filter);
        Attachment replacementFile = this.getRetentionPDFFile();
        logger.info((Object)String.format("Found %d cases to be deleted.", caseList.size()));
        for (BaseDocument baseCase : caseList) {
            String refNumber = ((BaseCase)baseCase).getReferenceNumber();
            logger.info((Object)String.format("\tCase %s, creation date: %s deleted by Data Retention Agent.", refNumber, df.format(baseCase.getDateCreated())));
            List<SubDocument> caseDocuments = CaseService.getCaseDocuments(baseCase.getId(), false);
            if (caseDocuments.size() > 0) {
                logger.info((Object)String.format("\tFound %d response documents for case %s that will be deleted.", caseDocuments.size(), refNumber));
                for (SubDocument sub : caseDocuments) {
                    if (sub instanceof Attachment || sub instanceof CompletedFormDocument) {
                        ExternalDocument doc = (ExternalDocument)sub;
                        doc.setStream(replacementFile.getStream());
                        doc.setFilesize(replacementFile.getFilesize());
                        doc.setDeleted(true);
                        CaseService.updateSubDocument(sub);
                    } else {
                        CaseService.deleteSubDocument(sub.getId());
                    }
                    logger.debug((Object)String.format("Updating file %s (id=%s)", sub.getSubject(), sub.getId()));
                    ++this.deletedFiles;
                }
            }
            CaseService.deleteCase(baseCase.getId());
            ++this.deletedCases;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Attachment getRetentionPDFFile() throws SelfServiceException {
        try {
            BirdDatabase db = SelfServiceEngine.getBirdSession().getDatabase();
            BirdFile pdfFile = db.getFileByName(birdCustomPdfFileName);
            if (pdfFile != null && "retention.pdf".equalsIgnoreCase(pdfFile.getFilename())) {
                logger.info((Object)String.format("Found Custom PDF Retention file (%s) in BIRD files", birdCustomPdfFileName));
                Attachment att = new Attachment();
                att.setStream(IOUtils.toByteArray((InputStream)pdfFile.getBody()));
                att.setFilesize(att.getStream().length);
                return att;
            }
            Locale defaultLocale = LocaleUtil.getDefaultLocale();
            logger.info((Object)("Default Language Code .. " + defaultLocale.getLanguage()));
            String internalPdfFileName = "retention.en.pdf";
            if (defaultLocale != null && "is".equalsIgnoreCase(defaultLocale.getLanguage())) {
                internalPdfFileName = "retention.is.pdf";
            }
            logger.info((Object)String.format("No Custom PDF Retention file found in BIRD files. Using internal file %s", internalPdfFileName));
            try (InputStream in = null;){
                in = DataRetentionPolicyAgent.class.getResourceAsStream("files/" + internalPdfFileName);
                if (in != null) {
                    Attachment att = new Attachment();
                    att.setStream(IOUtils.toByteArray((InputStream)in));
                    att.setFilesize(att.getStream().length);
                    Attachment attachment = att;
                    return attachment;
                }
                throw new SelfServiceException(String.format("Could not load PDF retention file \"%s\" from JAR file!", internalPdfFileName));
            }
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
        catch (BirdException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
    }

    private boolean isEnabled() {
        return "true".equalsIgnoreCase(SelfServiceEngine.getConfig("data.retention.enabled"));
    }

    private int getRetentionDays() {
        String days = SelfServiceEngine.getConfig("data.retention.days");
        try {
            return Integer.parseInt(days);
        }
        catch (Exception ex) {
            logger.warn((Object)"DATA_RETENTION_DAYS is not properly set in the selfservice-config.xml file.");
            return -1;
        }
    }
}

