/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice;

import java.util.Hashtable;
import java.util.List;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.AccessControl;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.CaseList;
import net.gopro.selfservice.data.CaseTemplate;
import net.gopro.selfservice.data.CheckoutTicket;
import net.gopro.selfservice.data.Contact;
import net.gopro.selfservice.data.Email;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.IAccessControlled;
import net.gopro.selfservice.data.Memo;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.exceptions.CaseException;
import net.gopro.selfservice.exceptions.SaveConflictException;
import net.gopro.selfservice.filters.CaseListFilter;

public interface ICaseEngine {
    public void createCase(BaseCase var1) throws CaseException, SelfServiceException;

    public void updateCase(BaseCase var1) throws CaseException, SelfServiceException;

    public void deleteCase(String var1) throws CaseException, SaveConflictException, SelfServiceException;

    public BaseCase getCase(String var1) throws SelfServiceException;

    public BaseCase getCaseByGoProId(String var1, String var2) throws SelfServiceException;

    public List<BaseCase> getCases() throws SelfServiceException;

    public List<BaseCase> getCases(String var1) throws SelfServiceException;

    public CaseList getCases(String var1, CaseListFilter var2) throws SelfServiceException;

    public List<FormCase> getCasesByFormTemplate(String var1) throws SelfServiceException;

    public List<FormCase> getCasesByFormTemplate(String var1, String var2) throws SelfServiceException;

    public List<BaseCase> getCasesByOrganization(String var1) throws SelfServiceException;

    public List<BaseCase> getCasesByCaseTemplate(String var1, String var2) throws SelfServiceException;

    public List<SubDocument> getCaseDocuments(String var1, boolean var2) throws SelfServiceException;

    public void createSubDocument(SubDocument var1) throws CaseException, SelfServiceException;

    public void updateSubDocument(SubDocument var1) throws CaseException, SaveConflictException, SelfServiceException;

    public void updateSubdocumentStatus(SubDocument var1) throws SelfServiceException;

    public void deleteSubDocument(String var1) throws CaseException, SaveConflictException, SelfServiceException;

    public SubDocument getSubDocument(String var1, boolean var2) throws SelfServiceException;

    public List<SubDocument> getSubdocuments(String var1) throws SelfServiceException;

    public SubDocument getSubDocumentByGoProId(String var1) throws SelfServiceException;

    public ExternalDocument getExternalDocument(String var1, boolean var2) throws SelfServiceException;

    public Memo getMemo(String var1) throws SelfServiceException;

    public Email getEmail(String var1, boolean var2) throws SelfServiceException;

    public Hashtable<String, String> getCaseTypesInUse(String var1) throws SelfServiceException;

    public void createCaseTemplate(CaseTemplate var1) throws CaseException, SelfServiceException;

    public void updateCaseTemplate(CaseTemplate var1) throws CaseException, SelfServiceException;

    public CaseTemplate getCaseTemplate(String var1) throws SelfServiceException;

    public List<CaseTemplate> getCaseTemplates() throws SelfServiceException;

    public void deleteCaseTemplate(String var1) throws CaseException, SelfServiceException;

    public String cloneCase(String var1, boolean var2) throws SelfServiceException, CaseException;

    public CheckoutTicket checkOutDocument(String var1, String var2) throws SelfServiceException;

    public boolean checkInDocument(String var1) throws SelfServiceException;

    public List<SubDocument> getCheckedOutDocuments() throws SelfServiceException;

    public List<BaseCase> getCasesByCompany(String var1) throws SelfServiceException;

    public void updateAccessControl(IAccessControlled var1) throws SelfServiceException;

    public void createAccessControlEntry(AccessControl var1) throws SelfServiceException;

    public void purgeContactAccessControl(Contact var1) throws SelfServiceException;

    public List<BaseCase> getCasesByParentId(String var1) throws SelfServiceException;

    public List<CaseTemplate> getPrimaryCaseTemplates() throws SelfServiceException;

    public void updateCaseStatus(BaseCase var1) throws SelfServiceException;
}

