var Organization = {

    id: null,
    locale: {},
    isCertificate: false,
    action: null,

    initialize: function () {
        if (Prototype.Browser.IE) {
            $('s-broker-pickup').hide();
        }
        this.setServerInput($('servertype'));
        if (this.isCertificate) {
            this.__getCertificateDetails();
        }
        
        if (this.action == 'edit') {
        	this.disableRoutingEdit();
        }
    },

    disableRoutingEdit: function() {
    	$('servertype').disabled = true;
    	var fields = new Array('broker-destination-id','servertype','hostname','username','password');
        fields.each(function(item) {
        	$(item).writeAttribute('readonly','readonly');
        });
        
    },
    
    editRouting: function() {
    	jQuery("#modal-change-connection").modal('show').css({
            'margin-left': function () {
                return -(jQuery(this).width() / 2);
            }
        });
    },
    
    enableRouting: function() {
    	jQuery("#modal-change-connection").modal('hide');
    	$('servertype').disabled = false;
    	var fields = new Array('broker-destination-id','servertype','hostname','username','password');
        fields.each(function(item) {
        	$(item).writeAttribute('readonly',null);
        });
        $('chbutton').remove();
    },
    
    createAjaxImage: function() {
        var img = new Image();
        img.src = 'files/loader/loader.gif';
        img.id = 'ajaximg';
        img.setAttribute('border',0);
        img.setAttribute('hspace',10);
        return img;
    },


    setServerInput: function(obj) {
        var broker   = 'GOPRO_BROKER';
        var gpnet    = 'GOPRO_NET';
        var gpcase   = 'GOPRO_CASE';
        var gpportal = 'GOPRO_PORTAL';
        var selItem = $(obj).value;

        if (selItem == gpnet || selItem == gpportal || selItem == gpcase) {
            $('s-hostname').show();
            $('s-connection').show();
            $('s-destination').hide();
            $('s-username').show();
            $('s-password').show();
            if (selItem == gpnet) {
                $('i-hostname').update(this.locale.netinfo);
            } else if (selItem == gpportal) {
                $('i-hostname').update(this.locale.portinfo);
            } else if (selItem == gpcase) {
                $('i-hostname').update(this.locale.caseinfo);
            }

        } else if (selItem == broker) {
            $('s-hostname').show();
            $('s-connection').show();
            $('s-username').hide();
            $('s-password').hide();
            $('s-destination').show();
            $('i-hostname').update(this.locale.brokinfo);
        } else {
            $('s-hostname').hide();
            $('s-username').hide();
            $('s-password').hide();
            $('s-destination').hide();
            $('s-connection').hide();
        }
    },


    toggleConnectionFields: function () {
        var status = ($('tcbutton').disabled == true);
        var fields = new Array('tcbutton','servertype','hostname','username','password');
        if (status) {
            fields.each(function(item) {
                $(item).disabled = false;
            });
        } else {
            fields.each(function(item) {
                $(item).disabled = true;
            });
        }
    },

    testConnection: function () {
        Organization.toggleConnectionFields();
        var img = this.createAjaxImage();
        $('sloader').appendChild(img);

        var g = {
            type:$('servertype').value,
            host:$('hostname').value,
            user:$('username').value,
            pass:$('password').value
        };

        new Ajax.Request('ss_xml.html?action=checkconnection', {
            method: 'post',
            onSuccess: Organization.testConnectionResults,
            parameters: {data: Object.toJSON(g)}
        });
    },


    testConnectionResults: function(transport) {
        var ajaximg = $('ajaximg');
        if (ajaximg != null) {
            ajaximg.remove();
        }
        Organization.toggleConnectionFields();
        var obj = transport.responseJSON;
        var error = obj.data.error;
        if (!Object.isUndefined(error)) {
            alert("Error: " + error);
        } else {
            var msg = Organization.locale.connect;
            alert(msg);
        }
    },


    showCssFiles: function () {
        $('cssfile').hide();
        $('birdcssfile').show();
    },

    setCssFile: function (obj, target) {
        var f = $(obj).value;
        target.setValue(f);
        $(obj).hide();
        target.show();
    },

    __getCertificateDetails: function () {
        var id = this.id;
        new Ajax.Request('ss_xml.html?action=certificate', {
            method: 'post',
            onSuccess: Organization.__showCertificateDetails,
            parameters: {oid:id}
        });
    },


    __showCertificateDetails: function (transport) {
        var obj = transport.responseJSON;
        var error = obj.data.error;
        if (!Object.isUndefined(error)) {
            alert("Error: " + error);
            return;
        }

        var cert = obj.data.certificate;

        $('cert-issuer').update(cert.issuer);
        $('cert-subject').update(cert.subject);
        $('cert-valid-from').update(cert.validfrom);
        $('cert-valid-to').update(cert.validto);
        $('cert-serial').update(cert.serial);
    },


    doAction: function (id, action) {
        var url = window.location.pathname+'?edit&id='+id+'&do='+action;
        location.href = url;
    }


}

var User = {

    resetMessage: null,
    deleteMessage: null,
    letterMessage : null,
    winErrMessage: null,
    caseCount: 0,
    casesVisible: false,
    referencesVisible: false,

    initialize: function () {
       if (this.caseCount > 0) {
           $('btnapp').enable();
       }
       // Stupid IE
       if (Prototype.Browser.IE) {
           $('casediv').hide();
       }
    },

    resetPassword: function(uid) {
        if (confirm(this.resetMessage)) {

            if (confirm(this.letterMessage)) {
                location.href='ss_user.html?edit&id='+uid+'&do=reset&letter=true';
            } else {
                location.href='ss_user.html?edit&id='+uid+'&do=reset';
            }

        }
    },

    showPasswordResetWindow: function(uid, pw) {
        var path = 'ss_userpassword.html?uid='+uid+'&pw='+pw;
        var win = window.open(path,'userpass','left=20,top=20,width=600,height=650,toolbar=0,resizable=1');
        if (win == null) {
            alert(this.winErrMessage);
        }
    },

    getCaseFiles: function(id, type) {
        var url = 'ss_user.html?download=true&type='+type+'&id='+id;
        location.href = url;
    },

    showClientReferenceList: function(btn) {
        var items = ['userdiv','addressdiv','rolediv','companydiv'];
        if (this.referencesVisible) {
            $(items).each(function(item) {
                if ($(item) != null) {
                    $(item).show();
                }
            });
        } else {
            if (!this.casesVisible) {
                $(items).each(function(item) {
                    if ($(item) != null) {
                        $(item).hide();
                    }
                });
            } else {
                this.casesVisible = false;
            }

            if ($('casediv') != null) {
                $('casediv').hide();
            }
        }
        $('refdiv').toggle();
        this.referencesVisible = !(this.referencesVisible);


    },

    
    deleteContact: function(contactId) {
    	if (confirm(this.deleteMessage)) {
    	
	        new Ajax.Request('ss_xml.html?action=deletecontact', {
	            method: 'post',
	            onSuccess: function(transport) {
	            	var obj = transport.responseJSON;
	                var error = obj.data.error;
	                if (!Object.isUndefined(error)) {
	                    alert("Error: " + error);
	                } else {
	                	$(obj.data.deleted_id).remove();
	                }
	            },
	            parameters: {data: Object.toJSON( {contactId: contactId} )}
	        });    	
	        
    	}
    },
    
    addContact: function(companyId, userId) {
    	
    	if (companyId != '') {
	    	new Ajax.Request('ss_xml.html?action=addcontact', {
	            method: 'post',
	            onSuccess: function(transport) {
	            	var obj = transport.responseJSON;
	                var error = obj.data.error;
	                if (!Object.isUndefined(error)) {
	                    alert("Error: " + error);
	                } else {
	                	location.href = 'ss_user.html?edit&id='+userId+'#contacts';
	                    window.location.reload(true);
	                }
	            },
	            parameters: {data: Object.toJSON( {cid: companyId, uid: userId} )}
	        });
    	}
    },

    showCaseList: function(obj) {
        var items = ['userdiv','addressdiv','rolediv','companydiv'];
        if (this.casesVisible) {
            $(items).each(function(item) {
                if ($(item) != null) {
                    $(item).show();
                }
            });
        } else {
            if (!this.referencesVisible) {
                $(items).each(function(item) {
                    if ($(item) != null) {
                        $(item).hide();
                    }
                });
            } else {
                this.referencesVisible = false;
            }
            if ($('refdiv') != null) {
                $('refdiv').hide();
            }
        }
        $('casediv').toggle();
        this.casesVisible = !(this.casesVisible);
    },

    deleteReference: function(userId, refId) {
        if (confirm(this.deleteMessage)) {
            this.deleteReferenceLink(userId, refId);
        }
    },


    deleteReferenceLink: function(userId, refId) {
        var g = {
            rid: refId,
            uid: userId
        };

        new Ajax.Request('ss_xml.html?action=deletereference', {
            method: 'post',
            onSuccess: User.onDeleteItem,
            parameters: {data: Object.toJSON(g)}
        });
    },

    onDeleteItem: function(transport) {
        var obj = transport.responseJSON;
        var error = obj.data.error;
        if (!Object.isUndefined(error)) {
            alert("Error: " + error);
        }

        var deletedId = obj.data.deleted_id;
        $(deletedId).remove();
    },


    __disable: function() {
        try {
            var form = $('userform');
            form.disable();
            $('btncancel').enable();
            $('btnreset').enable();
        } catch (ex) {
            // do nothing ..
        }
    }

}

var Company = {
		
    deleteMessage: null,

    deleteContact: function(contactId) {
    	
    	if (confirm(this.deleteMessage)) {
        
		    new Ajax.Request('ss_xml.html?action=deletecontact', {
		        method: 'post',
		        onSuccess: Company.onDeleteItem,
		        parameters: {data: Object.toJSON( {contactId: contactId} )}
		    });
        
    	}
    },
    
    confirmContact: function(link, contactId) {
    	new Ajax.Request('ss_xml.html?action=confirmcontact', {
	        method: 'post',
	        onSuccess: function(transport) {
	        	$(link).remove();
	        },
	        parameters: {data: Object.toJSON( {contactId: contactId} )}
	    });
    },
    
    toggleManager: function(link, contactId) {
    	
	    new Ajax.Request('ss_xml.html?action=togglecontactmanager', {
	        method: 'post',
	        onSuccess: function(transport) {
	        	var obj = transport.responseJSON;
	            var error = obj.data.error;
	            if (!Object.isUndefined(error)) {
	                alert("Error: " + error);
	            } else {
	            
	            	var el = $(link).down("i");
	            	var status = obj.data.manager;
	            	if (status) {
	            		$(el).setStyle({color: 'green'});
	            		$(el).writeAttribute('title', $(el).readAttribute('data-off'));
	            	} else {
	            		$(el).setStyle({color: '#c0c0c0'});
	            		$(el).writeAttribute('title', $(el).readAttribute('data-on'));
	            	}
	            	
	            }

	            
	        },
	        parameters: {data: Object.toJSON( {contactId: contactId} )}
	    });
        
    	
    },

    onDeleteItem: function(transport) {
        var obj = transport.responseJSON;
        var error = obj.data.error;
        if (!Object.isUndefined(error)) {
            alert("Error: " + error);
        }

        var deletedId = obj.data.deleted_id;
        $(deletedId).remove();
    }

}

var TargetGroupList = {

    setFilter: function(key,value) {
        var url  = window.location.pathname;
        url += '?filter=true&filterkey='+key+'&filtervalue='+value+'#userlist';
        location.href = url;
    }
}

var UserList = {

    setSearch: function(key) {
        if (key == null || key == '') {
            return false;
        } else {
            var url = window.location.pathname;
            url += '?filter=true&filterkey=search&filtervalue='+key;
            location.href = url;
            return false;
        }
    },

    setUnconfirmed: function() {
        var url = window.location.pathname;
        url += '?filter=true&filterkey=unconfirmed&filtervalue=true';
        location.href = url;
    },

    setLetter: function (l) {
        var url = window.location.pathname;
        url += '?filter=true&filterkey=letter&filtervalue='+l;
        location.href = url;
    }

}

var List = {

    initialize: function () {
        // Stupid IE
        if (Prototype.Browser.IE) {
            setTimeout(this.cancelListItem, 200);
            setTimeout(this.cancelListItemUpdate, 200);
         }
    },

    deleteItem: function(list, id) {

        var g = {lid:list, id:id};

        new Ajax.Request('ss_xml.html?action=deletelistitem', {
            method: 'post',
            onSuccess: List.onDeleteItem,
            parameters: {data: Object.toJSON(g)}
        });

    },

    onDeleteItem: function(transport) {
        var obj = transport.responseJSON;
        var error = obj.data.error;
        if (!Object.isUndefined(error)) {
            alert("Error: " + error);
        }

        var deletedId = obj.data.deleted_id;
        var defaultId = obj.data.default_id;

        $(deletedId).remove();
        var objDefault = $('default_id');
        if (objDefault.getValue() != defaultId) {
            for(var i=0; i < objDefault.options.length; i++) {
                if (objDefault.options[i].value == defaultId) {
                    objDefault.options[i].setAttribute('selected','selected');
                    break;
                }
            }
        }
    },


    /* Retrieve ListItem that should be edited */
    editListItem: function(item_id) {
        var g = {itemId:item_id};
        new Ajax.Request('ss_xml.html?action=getlistitem', {
            method: 'post',
            onSuccess: List.onEditListItem,
            parameters: { itemId:item_id }
        });
    },

    /* After ListItem is retrieved, show the info in the 'update-listitem' panel, so that user can edit it */
    onEditListItem: function(transport) {
        var obj = transport.responseJSON;
        var error = obj.data.error;
        if (!Object.isUndefined(error)) {
            alert("Error: " + error);
            return;
        }

        Effect.toggle('update-listitem', 'appear');
        var subject = obj.data.listItem.subject;
        var alias = obj.data.listItem.alias;
        var itemid = obj.data.listItem.id;

        $('itemname_update').setValue(subject);
        $('itemalias_update').setValue(alias);
        $('id_update').setValue(itemid);

        try {

            var status = obj.data.listItem.status;
            $('status_type_update').setValue(status);

        } catch (ex) {
            //  Do nothing
        }
    },

    /* Hide panel for updating ListItem */
    cancelListItemUpdate: function() {
        var id = 'update-listitem';
        Effect.toggle(id, 'appear');
        $('itemname_update').clear();
        $('itemalias_update').clear();
    },

    /* Update list item */
    updateListItem: function() {
        var _name  = $('itemname_update').getValue();
        var _alias = $('itemalias_update').getValue();
        var _itemid = $('id_update').getValue();
        var _status = '';

        if ($('status_type_update') != null) {
            _status = $('status_type_update').getValue();
        }

        var g = {
            name:_name,
            alias:_alias,
            status:_status,
            lid:_itemid
        };

        new Ajax.Request('ss_xml.html?action=updatelistitem', {
            method: 'post',
            onSuccess: List.onUpdateListItem,
            parameters: {data: Object.toJSON(g)}
        });

    },

    /* after list item update - check for errors and hide panel */
    onUpdateListItem: function(transport) {

        var obj = transport.responseJSON;
        var error = obj.data.error;
        if (!Object.isUndefined(error)) {
            alert("Error: " + error);
            return;
        }
        List.cancelListItemUpdate();

        $('save_action').setValue('save');
        $('listform').submit();

    },

    showListItemPanel: function() {
        var id = 'create-listitem';
        Effect.toggle(id, 'appear');
        setTimeout(
            function() {
                if ( $(id).visible() ) {  $('itemname').activate();	}
            }, 1000);
    },

    saveListItem: function(list_id) {
        var _name  = $('itemname').getValue();
        var _alias = $('itemalias').getValue();
        var _status = '';

        if ($('status_type') != null) {
            _status = $('status_type').getValue();
        }

        var g = {
            name:_name,
            alias:_alias,
            status:_status,
            lid:list_id
        };
        new Ajax.Request('ss_xml.html?action=addlistitem', {
            method: 'post',
            onSuccess: List.onSaveListItem,
            parameters: {data: Object.toJSON(g)}
        });
    },

    onSaveListItem:function(transport) {
        var obj = transport.responseJSON;
        var error = obj.data.error;
        if (!Object.isUndefined(error)) {
            alert("Error: " + error);
            return;
        }

        List.cancelListItem();
        $('save_action').setValue('save');
        $('listform').submit();
    },

    cancelListItem: function() {
        var id = 'create-listitem';
        Effect.toggle(id, 'appear');
        $('itemname').clear();
        $('itemalias').clear();
    },

    setItemAlias: function(obj) {
        $('itemalias').value = obj.getValue().toLowerCase();
    }

}

var ConfigurationList = {

    deleteMessage: null,

    doDelete: function(id, ref) {
        var url = window.location.pathname;
        url += '?delete=true&id='+id;
        if (ref != null && ref != '') {
            url += '&ref='+ref;
        }
        if (confirm(this.deleteMessage)) {
            location.href = url;
        }
    }

}

var QueueList = {

    messageDelete: null,
    strTitle: null,
    isStartDate: true,
    locale: 'en',

    calendars: [ 'calendarFrom', 'calendarTo'],
    calendarFormat: '%m/%d/%y',

    initialize: function () {
        // Create calendar instances
        this.calendars.calendarFrom = new dhtmlxCalendarObject('startdate', true, {
            isYearEditable: true, isTimeEditable: false
        });
        this.calendars.calendarTo = new dhtmlxCalendarObject('enddate', true, {
            isYearEditable: true, isTimeEditable: false
        });

        this.calendars['calendarFrom'].setDateFormat(this.calendarFormat);
        this.calendars['calendarTo'].setDateFormat(this.calendarFormat);
        if (this.locale != 'en') {
            this.calendars['calendarFrom'].loadUserLanguage(this.locale);
            this.calendars['calendarTo'].loadUserLanguage(this.locale);
        }
        if (this.isStartDate == false) {
            $('startdate').setValue(this.calendars['calendarFrom'].getFormatedDate());
            $('enddate').setValue(this.calendars['calendarFrom'].getFormatedDate());
        }

        jQuery('span[data-toggle=tooltip]').tooltip();
    },

    routeDetails: function (id) {
        var url = 'ss_route.html?id='+id;
        var w = document.viewport.getWidth()-50;
        Modalbox.show(url, {title: QueueList.strTitle, width: w});
    },


    doDelete: function (id) {
        if (confirm(QueueList.messageDelete)) {
            new Ajax.Request('ss_xml.html?action=queueremoval', {
                method: 'post',
                parameters: { id: id }
            });
            $(id).remove();
        }
    }

}

var FormTemplateList = {

    initialize: function () {

        $$('.template-icon-list a').each(function(link) {
            if (link.readAttribute('data-from') != null) {
                $(link).title = $(link).title.replace('{0}',link.readAttribute('data-from')).replace('{1}',link.readAttribute('data-to'));
            }
            if (link.readAttribute('data-targetgroup') != null) {
                $(link).title = $(link).title.replace('{0}',link.readAttribute('data-targetgroup'));
            }
            if (link.readAttribute('data-agent') != null) {
                $(link).title = $(link).title.replace('{0}',link.readAttribute('data-agent'));
            }
            if (link.readAttribute('data-alias') != null) {
                $(link).title = $(link).title.replace('{0}',link.readAttribute('data-alias'));
            }
            if (link.readAttribute('data-filecount') != null) {
                $(link).title = $(link).title.replace('{0}',link.readAttribute('data-filecount'));
            }
            if (link.readAttribute('data-trans-count') != null) {
            	var transcount = link.readAttribute('data-trans-count');
            	var langs = [];
            	for (var i=1; i <= transcount; i++) {
            		langs.push(link.readAttribute('data-lang-'+i));
            	}
            	
            	$(link).title = $(link).title.replace('{0}', transcount).replace('{1}', langs.join(', '))
            }

        });

        jQuery('#main').tooltip({
            selector: "a[data-toggle=tooltip]"
        })
    }

}

var CaseTemplate = {
	isSecondary: false,
	
	initialize: function () {
		
		for (var i = 0; i <= 365; i++) { 
        	FormCommon.addOption(i, i, $('secondary-timelimit'));
        }
                
        jQuery('#btn-add-secondary').click(CaseTemplate.addSecondaryApplication);
        
        // Delegate the remove button
        jQuery('#table-secondary tbody').delegate('button.btn-sec-remove', 'click', CaseTemplate.removeSecondaryApplication);
        jQuery('span[data-toggle=tooltip]').tooltip();
	},
	
	addSecondaryApplication: function() {
    	
		var application = jQuery('#secondary-applications :selected').text();
    	var applicationId = jQuery('#secondary-applications').val();
    	
    	var status = jQuery('#secondary-status :selected').text();
    	var statusId = jQuery('#secondary-status').val();
    	
    	var limit = jQuery('#secondary-timelimit').val();
    	
    	var tb = jQuery('#table-secondary tbody');
    	
    	// Check for existing record for the same applicationId and the same status Id
    	var existingCount = jQuery(tb).find('tr[data-application-id="'+applicationId+'"][data-status-id="'+statusId+'"]').length;
    	
    	if (existingCount == 0) {
    		
    		// Add the selected entry to the table
        	var tpl = '<tr data-application-id="'+applicationId+'" data-status-id="'+statusId+'" data-limit="'+limit+'"><td>'+application+'</td><td>'+status+'</td><td>'+limit+'</td><td><button type="button" class="btn btn-mini btn-danger btn-sec-remove">X</button></td></tr>';
        	jQuery(tpl).appendTo(tb);
        	jQuery('#table-secondary').show();
    	}
        
    },
    
    removeSecondaryApplication: function() {
    	jQuery(this).parents('tr').remove();
    	if (jQuery('#table-secondary tbody tr').length == 0) {
    		jQuery('#table-secondary').hide();
    	}
    },
    
    submit: function () {
        
    	// Set secondary applications if checked
        if (jQuery('#is-secondary-enabled').is(':checked')) {
        	
        	var list = [];
        	jQuery('#table-secondary tbody > tr').each(function() { 
        		var aid = jQuery(this).data('application-id');
        		var	sid = jQuery(this).data('status-id');
        		var	lim = jQuery(this).data('limit');
        		list.push({id: aid, sid: sid, limit:lim});
        	});
        	
        	jQuery('#secondary-payload').val(JSON.stringify(list));
        	
        }
    }
}

var FormTemplate = {
    
    action: '',
    id: '',
    
    calendars: [ 'calendarFrom', 'calendarTo'],
    lists: ['status-list-available', 'status-list'],
    calendarFormat: '%m/%d/%y',
    locale: 'en',
    
    isDateRestriction: false,
    isResend: false,
    isSecondary: false,
    secondaryTimeLimit: 0,
    minAttachments: 0,
    hourFrom: '',
    hourTo: '',
    minuteFrom: '',
    minuteTo: '',
    
    
    initialize: function () {
        
        // Create calendar instances
        this.calendars.calendarFrom = new dhtmlxCalendarObject('from-date', true, {
            isYearEditable: true
        });
        this.calendars['calendarFrom'].setDateFormat(this.calendarFormat);

        this.calendars.calendarTo = new dhtmlxCalendarObject('to-date', true, {
            isYearEditable: true
        });
        this.calendars['calendarTo'].setDateFormat(this.calendarFormat);

        if (this.locale != 'en') {
            this.calendars['calendarFrom'].loadUserLanguage(this.locale);
            this.calendars['calendarTo'].loadUserLanguage(this.locale);
        }

        // Populate select fields
        for (var i = 0; i < 60; i++) {
            if (i < 11) {
                FormCommon.addOption(i, i, $('min-attachments'));
            }
            if (i < 24) {
                FormCommon.addOption(i, i, $('from-hour'));
                FormCommon.addOption(i, i, $('to-hour'));
            }
            FormCommon.addOption(i, i, $('from-minute'));
            FormCommon.addOption(i, i, $('to-minute'));
        }
        
        for (var i = 0; i <= 365; i++) { 
        	FormCommon.addOption(i, i, $('secondary-timelimit'));
        }
                
        // Create the Sortable Status list
        this.createSortableLists();
        
        jQuery('#payment-currency').change(function() { jQuery('#currency').html( jQuery(this).val()) });
        jQuery('#btn-add-secondary').click(FormTemplate.addSecondaryApplication);
        
        // Delegate the remove button
        jQuery('#table-secondary tbody').delegate('button.btn-sec-remove', 'click', FormTemplate.removeSecondaryApplication);
        
        try {
        	$('secondary-status').options[0].writeAttribute('disabled','disabled');
        } catch (ex) {}
        
        
        if (this.action == 'create') {
            
        } else {
        	this.setFormData();
        }
        
        jQuery('span[data-toggle=tooltip]').tooltip();
    },
    
    submit: function () {
    
        // Set the status list values
        this.setStatusListValues();
        
        // Set secondary applications if checked
        if (jQuery('#is-secondary-enabled').is(':checked')) {
        	
        	var list = [];
        	jQuery('#table-secondary tbody > tr').each(function() { 
        		var aid = jQuery(this).data('application-id');
        		var	sid = jQuery(this).data('status-id');
        		var	lim = jQuery(this).data('limit');
        		list.push({id: aid, sid: sid, limit:lim});
        	});
        	
        	jQuery('#secondary-payload').val(JSON.stringify(list));
        	
        }
    },
    
    addSecondaryApplication: function() {
    	
    	if (jQuery('#secondary-status').prop('selectedIndex') > 0) {
    	
    		var application = jQuery('#secondary-applications :selected').text();
        	var applicationId = jQuery('#secondary-applications').val();
        	
        	var status = jQuery('#secondary-status :selected').text();
        	var statusId = jQuery('#secondary-status').val();
        	
        	var limit = jQuery('#secondary-timelimit').val();
        	
        	var tb = jQuery('#table-secondary tbody');
        	
        	// Check for existing record for the same applicationId
        	var existingCount = jQuery(tb).find('tr[data-application-id="'+applicationId+'"][data-status-id="'+statusId+'"]').length;
        	
        	if (existingCount == 0) {
        		
        		// Add the selected entry to the table
            	var tpl = '<tr data-application-id="'+applicationId+'" data-status-id="'+statusId+'" data-limit="'+limit+'"><td>'+application+'</td><td>'+status+'</td><td>'+limit+'</td><td><button type="button" class="btn btn-mini btn-danger btn-sec-remove">X</button></td></tr>';
            	jQuery(tpl).appendTo(tb);
            	jQuery('#table-secondary').show();
        	}
        	
        	    		
    	}
    },
    
    removeSecondaryApplication: function() {
    	jQuery(this).parents('tr').remove();
    	if (jQuery('#table-secondary tbody tr').length == 0) {
    		jQuery('#table-secondary').hide();
    	}
    },
    
    setFormData: function () {
        this.setListValue('min-attachments', this.minAttachments);
                
        this.setListValue('secondary-timelimit', this.secondaryTimeLimit);
        
        this.setFormtype($('formtype'));
        
        if (this.isDateRestriction == 1 || this.isDateRestriction == 'true') {
            var _dr = $('is-date-restricted');
            _dr.checked = true;
            this.setDateRestriction(_dr);
            
            this.setListValue('from-hour', this.hourFrom);
            this.setListValue('from-minute', this.minuteFrom);
            this.setListValue('to-hour', this.hourTo);
            this.setListValue('to-minute', this.minuteTo);
        }
    },
    
    createSortableLists: function () {
    
        // Include the list style sheet
        document.getElementsByTagName('head')[0].appendChild(
        	new Element('link', { 'rel': 'stylesheet', 'type' : 'text/css', href: 'files/bird/sortable-lists/sortable-lists.css' })  
        );
        
    
        Sortable.create("status-list-available", {
            dropOnEmpty: true,
            containment: this.lists,
            constraint: false,
            only: 'sortable',
            onUpdate: FormTemplate.statusListUpdated
        });
        
        
        Sortable.create("status-list", {
            dropOnEmpty: true,
            containment: this.lists,
            constraint: false,
            only: 'sortable',
            onUpdate: FormTemplate.statusListUpdated,
            onChange: FormTemplate.statusListUpdated
        });
    },
    
    statusListUpdated: function(list) {
    	var resendList = $('resend-status');
    	var secondaryList = $('secondary-status');
    	
    	// Clear the list
    	$(resendList).options.length = 0;
    	$(secondaryList).options.length = 0;
    	
    	// Add the new items
    	var items = $('status-list').select('li.sortable');
    	items.each(function (item) {
            FormCommon.addOption(item.innerHTML, item.id, resendList);
            FormCommon.addOption(item.innerHTML, item.id, secondaryList);
        });
    	
    	// Disable item nr. 1 and 2 in the list
    	try {
    		
    		$('resend-status').options[0].writeAttribute('disabled','disabled');
    		$('resend-status').options[1].writeAttribute('disabled','disabled');
    		$('secondary-status').options[0].writeAttribute('disabled','disabled');
    		
    	} catch (ex) {}
    	
    },
    
    setStatusListValues: function() {
        var list = $('status-list');
        var selectBox = $('statuses');
        var items = list.select('li.sortable');
        items.each(function (item) {
            FormCommon.addOption(item.id, item.id, selectBox);
        });
        
        // Then we need to set all options as selected
        for (var i=0;i<selectBox.options.length;i++) {
	    	selectBox.options[i].selected = true;
	    }        
    },
        
    showJsFiles: function () {
        $('jsfile').hide();
        $('birdjsfile').show();
    },
    
    setJsFile: function (obj, target) {
        var f = $(obj).value;
        target.setValue(f);
        $(obj).hide();
        target.show();
    },
    
    setInternal: function (obj) {
        var tr1 = $('row1');
        var tr2 = $('row2');
        if (obj.checked) {
            FormCommon.toggle(tr1, false);
            FormCommon.toggle(tr2, false);
        } else {
            FormCommon.toggle(tr1, true);
            FormCommon.toggle(tr2, true);
        }
    },
    
    setFormtype: function (obj) {
        var key = obj.options[obj.selectedIndex].text;
        var tr1 = $('row1');
        var tr2 = $('row2');
        var tri = $('internal-xsl');
        var type1 = $('filetype1');
        var useInternal = $('is-internal-xsl').checked;
        
        if (key == 'LotusFormTemplate') {
            FormCommon.toggle(tr1, false);
            FormCommon.toggle(tr2, false);
            FormCommon.toggle(tri, false);
            type1.selectedIndex = 0;
        } else if (key == 'GoProFormTemplate') {
            type1.selectedIndex = 1;
            FormCommon.toggle(tri, true);
            if (! useInternal) {
                FormCommon.toggle(tr1, true);
                FormCommon.toggle(tr2, true);
            }
        }
    },
    
    setListValue: function (listId, selected) {
        var filter = 'select#' + listId + ' option';
        $$(filter).each(function (o) {
            if (o.value == selected) {
                o.selected = true;
                return;
            }
        });
    },
    
    getTemplate: function (templateId, fileId) {
        var url = window.location.pathname + '?download=true&tid=' + templateId + "&fid=" + fileId;
        location.href = url;
    },
    
    
    setDateRestriction: function (obj) {
        var span = $('datefields');
        FormCommon.toggle(span, obj.checked);
    },
    
    toggleResendStatus: function (obj) {
        var div = $('div-resend-status');
        FormCommon.toggle(div, obj.checked);
    },
    
    toggleSecondary: function(obj) {
    	var div = $('div-secondary');
        FormCommon.toggle(div, obj.checked);
    },
        
    newGuidance: function (id) {
        var url = 'ss_guidance.html?create&template_id=' + id;
        location.href = url;
    },
    
    caseNamer: function (id) {
        var url = 'ss_casenamer.html?create&template_id=' + id;
        location.href = url;
    },
    
    translate: function (id) {
        var url = 'ss_translationlist.html?template_id=' + id;
        location.href = url;
    },
    
    deleteGuidance: function (id) {
        new Ajax.Request('ss_xml.html?action=deleteguidance', {
            method: 'post',
            parameters: {
                tid: this.id, gid: id
            }
        });
        $(id).remove();
    },
    
    pdfPreview: function (id, oid) {
        var orgs = $('organizations').getValue();
        if (orgs.length == 0) {
            var msg = 'No organization has been selected';
            alert(msg);
            return;
        }
        
        var url = window.location.pathname;
        url += '?download=true&tid=' + id + '&type=pdf';
        
        if (oid != null && oid != '') {
            jQuery("#div-organizations").modal('hide');
            url += '&oid=' + oid;
            location.href = url;
        } else if (orgs.length > 1) {
            // Populate the dropdown
            var nl = $('pdf-organization');
            nl.options.length = 0;
            var o = $('organizations');
            for (var i = 0; i < o.options.length; i++) {
                var el = o.options[i];
                if (el.selected) {
                    $(nl).insert(new Element('option', {
                        value: el.value
                    }).update(el.text));
                }
            }

            jQuery("#div-organizations").modal('show').css({
                'margin-left': function () {
                    return -(jQuery(this).width() / 2);
                }
            });


        } else {
            url += '&oid=' + orgs[0];
            location.href = url;
        }
    }
}

var QueueLog = {
	
	showError: function(link, id, rowindex) {
	
		var status = $(link).readAttribute('data-log');
		
		if (status == 'on') {
			
			$('error-'+id).remove();
			$(link).writeAttribute('data-log', 'off');
			
		} else {
		
			var data = {queue_id: id, index: rowindex};
			
			new Ajax.Request('ss_xml.html?action=queuelog', {
	            method: 'post',
	            onSuccess: QueueLog._showErrorCallBack,
	            parameters: { data: Object.toJSON(data)}
	        });
			
			$(link).writeAttribute('data-log', 'on');
			
		}
	
	},
	
	_showErrorCallBack: function(transport) {
		 var obj = transport.responseJSON;
	     var error = obj.data.error;
	        
	     if (!Object.isUndefined(error)) {
	        alert(error);
	        return;
	     }
	     
	     var rowIndex = obj.data.index;
	     var log = obj.data.log;
	     if (log != null) {
	    	 var tbl = $('qtable');
	    	 // Delete other rows
	    	 $(tbl).select('tr.errorlog').each(Element.remove);
	    	 var tr = tbl.insertRow(rowIndex+1);
	    	 $(tr).writeAttribute('class','errorlog');
	    	 $(tr).writeAttribute('id','error-'+log.id);
	    	 var td = tr.insertCell(-1);
	    	 $(td).writeAttribute('colspan', 10);
	    	 $(td).setStyle( {'backgroundColor': '#ffcccc', 'color':'#990000', 'borderTop':'1px solid #F2F2F2'} );
	    	 
	    	 var msg = '<b>Error:</b> ' + log.message;
	    	 if (log.stacktrace != null) {
	    		 msg += ' <br/><b>Stacktrace:</b><pre class="pre-scrollable" style="font-size:11px;background-color: rgb(255, 204, 204); color: rgb(153, 0, 0); border: 0px"> ' + log.stacktrace + '</pre>';
	    	 }
	    	 $(td).update(msg);
	    	 
	     }
	     
		
	}
		
}

var TargetGroup = {

    userlist: [],

    setTargetGroupUsers: function() {
        TargetGroup.userlist.update()
    },

    setPopulation: function(obj) {
        var sel = $(obj).value;
        if (sel == 'manual') {
            $('populate-handpicked').show();
            $('populate-class').hide();
            $('div-interval').hide();
        } else if (sel == 'class') {
            $('populate-handpicked').hide();
            $('populate-class').show();
            $('div-interval').show();
        }
    },

    setClassInfo: function() {
        TargetGroup.classLookup($('classname'));
        $('preview').show();
    },

    classLookup: function(obj) {
        
        var data = {className: obj.value};
		
		new Ajax.Request('ss_xml.html?action=targetgroupclass', {
            method: 'post',
            onSuccess: TargetGroup._classLookupCallback,
            parameters: { data: Object.toJSON(data)}
        });
    
    },
    
    _classLookupCallback: function(transport) {
    
        var obj = transport.responseJSON;
        var error = obj.data.error;
        
        if (! Object.isUndefined(error)) {
            //alert(error);
            return;
        }
    
        var div = $('div-class-params');
        $('preview').show();
        
        var params = obj.data.params.param;
        if (params != null) {

			if (!Object.isArray(params)) {
				params = [params];
			}

            var ptext = '<ul>';
            params.each(function(item) {
               ptext += '<li>' + item.key + ' : <span style="color:#686767"> ' + item.content + '</span></li>';
            });
            ptext += '</ul>';
            $(div).update(ptext);
            $(div).show();
        }
        
    
    },
    
    previewUsers: function() {
        var className = $('classname').value;
        var params = $('classparams').value;
        
        var data = {className: className, params: params};
		
		new Ajax.Request('ss_xml.html?action=targetgroupuserpreview', {
            method: 'post',
            onSuccess: TargetGroup._previewUsersCallback,
            parameters: { data: Object.toJSON(data)}
        });
    
        
    },
    
    _previewUsersCallback: function(transport) {
        var obj = transport.responseJSON;
        var error = obj.data.error;
        
        if (! Object.isUndefined(error)) {
            alert('Error: ' + error);
            return;
        }
     
        $('users').update('');
        var users = obj.data.user;
        
        if (!Object.isUndefined(users) && !Object.isArray(users)) {
        	users = [users];
        }
        
        if (users != null && Object.isArray(users)) {
            $('user-preview').show();
            var ul = new Element('ul', {});
            $('users').appendChild(ul);
            users.each(function(item) {
                var li = new Element('li', {}).update(item.fullname +  ' - '  + item.email);
                $(ul).appendChild(li);               
            });
        }
     
    }

}

var MessageTemplate = {
		
	initialize: function(locale) {

        new Ajax.Request('ss_xml.html?action=computedlist', {
            method: 'post',
            onSuccess: function(transport) {

                var obj = transport.responseJSON;

                var options = {
                    // mode : "textareas",
                    selector: "textarea#body",
                    theme : "modern",
                    toolbar: "undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | computed",

                    setup: function(editor) {
                        editor.addButton('computed', {
                            type: 'listbox',
                            text: 'Computed',
                            icon: false,
                            onselect: function(e) {
                                editor.insertContent(this.value());
                            },
                            values: MessageTemplate.createMenu(obj.data)
                        });
                    }
                };
                
                if (locale != '' && locale != 'en') {
            		options.language = locale;
            	}
                
                tinyMCE.init(options);

            }
        });

    },

    createMenu: function(list) {
        var values = [];
        for (var section in list) {
            var sm = [];
            list[section].item.each(function(item) {
                sm.push({
                    text: item.value,
                    value: '['+item.key+']'
                });
            });
            values.push({
                text: list[section].title,
                menu: sm
            });
        }
        return values;
    }
		
}

var Announcement = {

    message: null,
    isReadOnlyMode: false,

    initialize: function(locale) {

        new Ajax.Request('ss_xml.html?action=computedlist', {
            method: 'post',
            onSuccess: function(transport) {

                var obj = transport.responseJSON;

                var options = {
                    mode : "textareas",
                    theme : "modern",
                    toolbar: "undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | computed",

                    setup: function(editor) {
                        editor.addButton('computed', {
                            type: 'listbox',
                            text: 'Computed',
                            icon: false,
                            onselect: function(e) {
                                editor.insertContent(this.value());
                            },
                            values: Announcement.createMenu(obj.data)
                        });
                    }
                };
                
                if (locale != '' && locale != 'en') {
            		options.language = locale;
            	}
                
                tinyMCE.init(options);

            }
        });



        if (this.isReadOnlyMode) {
            this.setReadOnly();
        }
    },

    createMenu: function(list) {
        var values = [];
        for (var section in list) {
        	if (section !== 'case') {
	            var sm = [];
	            list[section].item.each(function(item) {
	                sm.push({
	                    text: item.value,
	                    value: '['+item.key+']'
	                });
	            });
	            values.push({
	                text: list[section].title,
	                menu: sm
	            });
        	}
        }
        return values;
    },

    sendMessage: function(send) {
       if (send) {
            $('amForm').submit();
            $('smessage').update(this.message);
        } else {
            $('sendit').value = 'false';
            $('amForm').submit();
        }

        var img = this.createAjaxImage();
        $('sloader').appendChild(img);
        $('amForm').disable();
    },


    createAjaxImage: function() {
        var img = new Image();
        img.src = 'files/loader/loader.gif';
        img.id = 'ajaximg';
        img.setAttribute('border',0);
        img.setAttribute('hspace',10);
        return img;
    },

    setReadOnly: function() {
        $('amForm').disable();
        $('btncancel').enable();
    }

}

var EventLog = {

    isUserFilter: false,
    searchField: null,
    locale: 'en',

    calendars: [ 'calendarFrom', 'calendarTo'],
    calendarFormat: '%m/%d/%y',

    initialize: function() {

        this.calendars.calendarFrom = new dhtmlxCalendarObject('startdate', true, {
            isYearEditable: true, isTimeEditable: false
        });
        this.calendars.calendarTo = new dhtmlxCalendarObject('enddate', true, {
            isYearEditable: true, isTimeEditable: false
        });

        this.calendars['calendarFrom'].setDateFormat(this.calendarFormat);
        this.calendars['calendarTo'].setDateFormat(this.calendarFormat);
        if (this.locale != 'en') {
            this.calendars['calendarFrom'].loadUserLanguage(this.locale);
            this.calendars['calendarTo'].loadUserLanguage(this.locale);
        }

        jQuery('span[data-toggle=tooltip]').tooltip();
    },

    lockToCase: function (obj) {

        var sel = $('filter-datatype');
        if (obj.getValue() == '') {
            $(sel).disabled = false;
        } else {
            FormCommon.setListValue('filter-datatype', 'CASE');        
            $(sel).disabled = true;        
        }
        
    },
    
    search: function(btn) {
        $('is-excel').value = '0';
        $('filter-document-id').value = '';
        $(btn).disabled = true;
        $('event-form').submit();
    },
    
    toExcel: function()  {
        var documentId = $('excel-document-id').getValue();
        if (documentId != '') {
            $('filter-document-id').value = documentId;
        }
        $('is-excel').value = '1';
        $('event-form').submit();
        $('is-excel').value = '0';
    },
    
    drilldown: function(id, type) {
        $('filter-document-id').value = id;
        $('event-form').submit();
    },  

    userLookup: function () {
        var id = 'usersearch';
        new Autocomplete(id, {
            serviceUrl: 'ss_xml.html?action=logusersearch',
            minChars: 2,
            maxHeight: 400,
            width: 300,
            deferRequestBy: 100,
            // callback function:
            onSelect: function (value, data) {
                EventLog.userLookupCallback(value, data);
            }
        });
    },
    
    
    userLookupCallback: function (value, data) {

        var userinfo = data.user.fullname + ' (' + data.user.email + ')';

        $('usersearch').value = data.user.fullname;
        $('usersearch').title = userinfo;

        $('filter-user-info').value = userinfo;
        $('filter-user-id').value = data.user.id;

        $('usersearch').disable();
        $('user-icon').removeClassName('icon-user');
        $('user-icon').addClassName('icon-remove').observe('click', EventLog.userLookupReset);

    },
    
    userLookupReset: function() {

        $('user-icon').removeClassName('icon-remove').addClassName('icon-user')
        
        $('filter-user-id').value = '';
        $('filter-user-info').value = '';
        $('usersearch').enable();
        $('usersearch').title = '';
        $('usersearch').value = '';
        $('usersearch').focus();
    }

}

var TranslationList = {

    doStatus: function(id) {
        var url = window.location.pathname + '?action=status&id='+id;
        location.href = url;
    }
}

var Graphs = {
    isLoading: true,
    period: null,

    initialize: function() {
        this.drawGraphs();
        this.isLoading = false;

        Event.observe(window, 'resize', function() {
            if (!Graphs.isLoading) {
                Graphs.isLoading = true;
                $('main').update('');
                Graphs.drawGraphs();
                Graphs.isLoading = false;
            }
        });
    },

    showGraph: function (type) {
        var width = $('main').getWidth() - 40;
        var src = 'reports?type='+type+'&period='+this.period+'&w='+width;
        var img = new Element('img', { 'src': src, 'border': 0, 'hspace': 5, 'vspace': 5 });
        $('main').appendChild(img);
    },

    drawGraphs:function() {
        this.showGraph('users');
        this.showGraph('registrations');
        this.showGraph('cases');
        this.showGraph('subdocuments');
        this.showGraph('casetypes');
    }

}

var FormCommon = {
    
    toggle: function (obj, show) {
        if (show == true) {
            obj.style.visibility = 'visible';
            if (obj.tagName == 'TR') {
                obj.style.display = 'table-row';
            } else {
                obj.style.display = 'block';
            }
        } else if (show == false) {
            obj.style.visibility = 'hidden';
            obj.style.display = 'none';
        }
    },
    
    setListValue: function (listId, selected) {
        var filter = 'select#' + listId + ' option';
        $$(filter).each(function (o) {
            if (o.value == selected) {
                o.selected = true;
                return;
            }
        });
    },
    
    addOption: function (text, value, el) {
        var _text = new String(text);
        if (_text.length == 1) {
            _text = "0" + text;
        }
        $(el).insert(new Element('option', {
            value: value
        }).update(_text));
    },

    toExcel: function () {
        location.href = window.location + '&excel=true';
    },

    tblFilter: function(phrase, _id) {
    	var words = phrase.value.toLowerCase().split(" ");
    	var table = document.getElementById(_id);
    	var ele;
    	for (var r=1; r < table.rows.length; r++) {
    		ele = table.rows[r].innerHTML.replace(/<[^>]+>/g,"");
    	    var displayStyle = 'none';
    	    for (var i = 0; i < words.length; i++) {
    		    if (ele.toLowerCase().indexOf(words[i])>=0)
    			displayStyle = '';
    		    else {
    			displayStyle = 'none';
    			break;
    		   }
    	    }
    		table.rows[r].style.display = displayStyle;
    	}
    },
    
    setFilter: function(obj) {
        var url  = window.location.pathname;
        if (obj.value != 'null' && obj.value != '') {
            url += '?filter=true&filterkey='+obj.name+'&filtervalue='+obj.value;
        }
        location.href = url;
    }
}