SELECT d.document_id, d.case_id, d.parent_id, d.gopro_id, d.createdby_id, d.status_id,
	d.subject, d.body, s.stream, d.is_sent, d.is_fromgopro, d.filesize, d.filename, 
	d.mimetype, d.is_deleted, d.created, d.modified, d.completed, d.classname,
	d.is_signed, d.is_signaturepending, d.is_sensitive,
	d.savecounter, d.responsecount, c.formtemplate_id, d.modifiedby_id, d.completedby_id 
FROM ss_documents d 
INNER JOIN ss_cases c ON c.case_id = d.case_id
INNER JOIN ss_streams s ON d.stream_id = s.stream_id
WHERE (d.gopro_id = ? OR d.gopro_id = ?) AND d.document_id IN (

	-- User ACL
	SELECT a.document_id 
 	FROM ss_acl a 
  	WHERE a.entity_id = ? AND a.entity_type = 1 
	
	UNION
 
 	-- Target groups ACL 
	SELECT a.document_id 
	FROM ss_acl a
	INNER JOIN ss_targetgroups t ON t.targetgroup_id = a.entity_id
	INNER JOIN ss_targetgroupusers tu ON t.targetgroup_id = tu.targetgroup_id
	WHERE t.is_deleted = 0 AND tu.user_id = ? AND a.entity_type = 2
	
	UNION
	
  	-- Company ACL 
 	SELECT a.document_id
 	FROM ss_acl a 
    INNER JOIN ss_companies com ON com.company_id = a.entity_id
    INNER JOIN ss_contacts co ON com.company_id = co.company_id
    WHERE co.user_id = ? AND com.is_deleted = 0 AND co.is_deleted = 0 
    	AND co.is_confirmed = 1 AND a.entity_type = 3
	
	UNION 
 	
 	-- Role ACL
	SELECT a.document_id
  	FROM ss_acl a
    INNER JOIN ss_userroles r ON r.role_id = a.entity_id
    INNER JOIN ss_userrolemap rm ON r.role_id = rm.role_id
    WHERE r.is_deleted = 0 AND rm.user_id = ? AND a.entity_type = 4

)  