/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.webservice;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.WebServiceContext;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.SelfServicePrincipal;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateExtras;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.data.GoProFormTemplate;
import net.gopro.selfservice.data.ListItem;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.StatusListItem;
import net.gopro.selfservice.exceptions.FormException;
import net.gopro.selfservice.forms.util.FormsUtil;
import net.gopro.selfservice.pdf.FOPTransformer;
import net.gopro.selfservice.pdf.PDFProperties;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.FormQueryUtil;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import net.gopro.selfservice.webservice.FormServiceAuthentication;
import net.gopro.selfservice.webservice.FormTemplateReference;
import org.dom4j.Document;
import org.dom4j.Element;

@WebService(targetNamespace="http://gopro/selfservice/formtemplateservice/", serviceName="FormTemplateService")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
public class FormTemplateService {
    private static final String NS = "http://gopro/selfservice/formtemplateservice/";
    @Resource(type=Object.class)
    protected WebServiceContext wsContext;

    public FormTemplateService() {
        System.setProperty("com.sun.xml.ws.fault.SOAPFaultBuilder.disableCaptureStackTrace", "true");
    }

    @WebMethod(operationName="authenticate")
    public void authenticate(@WebParam(name="username") String username, @WebParam(name="password") String password) {
        try {
            boolean results = FormServiceAuthentication.validatePassword(username, password);
            if (!results) {
                throw new SelfServiceException("Authentication failed!");
            }
            this.getOrganization(username);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @WebMethod(operationName="createFormTemplate", action="http://gopro/selfservice/formtemplateservice/createFormTemplate")
    @WebResult(name="createFormTemplateResult", targetNamespace="http://gopro/selfservice/formtemplateservice/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String createFormTemplate(@WebParam(name="template") FormTemplateReference template) {
        try {
            FormsUtil.FormType formType;
            SelfServicePrincipal principal = FormServiceAuthentication.createCredentials(this.wsContext.getMessageContext());
            this.assertCredentials(principal);
            Organization org = this.getOrganization(principal.getName());
            GoProFormTemplate form = new GoProFormTemplate();
            form.setSubject(template.getSubject());
            form.setCategory(template.getCategory());
            form.setDescription(template.getDescription());
            form.setTemplateFiles(template.getTemplateFiles());
            form.getOrganizations().add(org);
            form.setExtendedData(new FormTemplateExtras());
            LinkedList<StatusListItem> list = form.getExtendedData().getCaseStatusList();
            net.gopro.selfservice.data.List statusList = ConfigService.getList("00ED1DFEB2098F050000012274E564AF");
            MetaData metaNotSubmitted = statusList.getMetaDataByKey("caselist.notsubmitted");
            MetaData metaSubmitted = statusList.getMetaDataByKey("caselist.submitted");
            if (metaNotSubmitted != null && metaSubmitted != null) {
                ListItem listItemNotSubmitted = statusList.getListItem(metaNotSubmitted.getValue());
                ListItem listItemSubmitted = statusList.getListItem(metaSubmitted.getValue());
                if (listItemNotSubmitted != null && listItemSubmitted != null) {
                    list.add((StatusListItem)listItemNotSubmitted);
                    list.add((StatusListItem)listItemSubmitted);
                }
            }
            if (list.isEmpty()) {
                ListItem defaultStatus = statusList.getDefaultListItem();
                if (defaultStatus != null) {
                    list.add((StatusListItem)defaultStatus);
                }
                for (ListItem statusItem : statusList.getListItems()) {
                    StatusListItem status = (StatusListItem)statusItem;
                    if (StatusListItem.Status.ACTIVE.equals((Object)status.getStatus()) || status.equals(defaultStatus)) continue;
                    list.add(status);
                    break;
                }
            }
            form.setSchemaVersion(FormsUtil.getSchemaVersion(form.getFormTemplateFile(FormTemplateFile.Tag.DATA)));
            for (FormTemplateFile ff : template.getTemplateFiles()) {
                ff.setDateCreated(new Date().getTime());
                ff.setDateModified(ff.getDateCreated());
            }
            FormsUtil.FormType formType2 = formType = form.getSchemaVersion() < 2.0 ? FormsUtil.FormType.GOPRO_FORM_V1 : FormsUtil.FormType.GOPRO_FORM_V2;
            if (form.getFormTemplateFile(FormTemplateFile.Tag.READ) == null) {
                form.getTemplateFiles().add(FormsUtil.getInternalXslFile(FormTemplateFile.Tag.READ, formType));
            }
            if (form.getFormTemplateFile(FormTemplateFile.Tag.EDIT) == null) {
                form.getTemplateFiles().add(FormsUtil.getInternalXslFile(FormTemplateFile.Tag.EDIT, formType));
            }
            FormService.createFormTemplate(form);
            return form.getId();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @WebMethod(operationName="getPdfPreview", action="http://gopro/selfservice/formtemplateservice/getPdfPreview")
    @WebResult(name="getPdfPreviewResult", targetNamespace="http://gopro/selfservice/formtemplateservice/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public byte[] getPdfPreview(@WebParam(name="data") byte[] data) {
        try {
            SelfServicePrincipal principal = FormServiceAuthentication.createCredentials(this.wsContext.getMessageContext());
            this.assertCredentials(principal);
            Organization org = this.getOrganization(principal.getName());
            return this.getPdfVersion(data, org);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @WebMethod(operationName="updateFormTemplate", action="http://gopro/selfservice/formtemplateservice/updateFormTemplate")
    @WebResult(name="updateFormTemplateResult", targetNamespace="http://gopro/selfservice/formtemplateservice/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String updateFormTemplate(@WebParam(name="template") FormTemplateReference template) {
        try {
            SelfServicePrincipal principal = FormServiceAuthentication.createCredentials(this.wsContext.getMessageContext());
            this.assertCredentials(principal);
            Organization org = this.getOrganization(principal.getName());
            FormTemplate updateTemplate = FormService.getFormTemplate(template.getId(), true);
            if (updateTemplate == null) {
                throw new SelfServiceException("Cannot update template, template Id not found in database!");
            }
            if (!(updateTemplate instanceof GoProFormTemplate)) {
                throw new SelfServiceException("The specified formtemplate is not a GoPro Form Template!");
            }
            if (!this.isAssociated(org, updateTemplate)) {
                throw new SelfServiceException("The template your are trying to update is not associated with your account!");
            }
            for (FormTemplateFile file : updateTemplate.getTemplateFiles()) {
                FormTemplateFile updatedFile = template.getFormTemplateFile(file.getTag());
                if (updatedFile == null || updatedFile.getStream() == null || updatedFile.getStream().length <= 0) continue;
                file.setStream(updatedFile.getStream());
                if (StringUtil.isValid(updatedFile.getFilename())) {
                    file.setFilename(updatedFile.getFilename());
                }
                file.setDirty(true);
            }
            FormService.updateFormTemplate(updateTemplate);
            return template.getId();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @WebMethod(operationName="getFormTemplates", action="http://gopro/selfservice/formtemplateservice/getFormtemplates")
    @WebResult(name="getFormtemplatesResult", targetNamespace="http://gopro/selfservice/formtemplateservice/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public List<FormTemplateReference> getFormtemplates() {
        try {
            SelfServicePrincipal principal = FormServiceAuthentication.createCredentials(this.wsContext.getMessageContext());
            this.assertCredentials(principal);
            Organization org = this.getOrganization(principal.getName());
            List<FormTemplate> templates = FormService.getFormTemplates(org.getId());
            ArrayList<GoProFormTemplate> list = new ArrayList<GoProFormTemplate>();
            for (FormTemplate template : templates) {
                if (!(template instanceof GoProFormTemplate)) continue;
                list.add((GoProFormTemplate)template);
            }
            ArrayList<FormTemplateReference> returnList = new ArrayList<FormTemplateReference>();
            for (GoProFormTemplate form : list) {
                FormTemplateReference ref = new FormTemplateReference();
                ref.setId(form.getId());
                ref.setSubject(form.getSubject());
                ref.setCategory(form.getCategory());
                ref.setDescription(form.getDescription());
                ref.setVisible(form.isVisible());
                ref.setTemplateFiles(form.getTemplateFiles());
                ref.setDateCreated(new Date(form.getDateCreated()));
                ref.setDateModified(new Date(form.getDateModified()));
                returnList.add(ref);
            }
            return returnList;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @WebMethod(operationName="getFormTemplate", action="http://gopro/selfservice/formtemplateservice/getFormTemplate")
    @WebResult(name="getFormTemplateResult", targetNamespace="http://gopro/selfservice/formtemplateservice/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public FormTemplateReference getFormTemplate(@WebParam(name="templateId") String templateId) {
        try {
            SelfServicePrincipal principal = FormServiceAuthentication.createCredentials(this.wsContext.getMessageContext());
            this.assertCredentials(principal);
            Organization org = this.getOrganization(principal.getName());
            FormTemplate template = FormService.getFormTemplate(templateId, true);
            if (template == null) {
                throw new SelfServiceException("The specified form template was not found!");
            }
            if (!this.isAssociated(org, template)) {
                throw new SelfServiceException("The specified form template is not associated with your account!");
            }
            if (!(template instanceof GoProFormTemplate)) {
                throw new SelfServiceException("The specified template is not a GoPro Form template.");
            }
            FormTemplateReference ref = new FormTemplateReference();
            ref.setId(template.getId());
            ref.setSubject(template.getSubject());
            ref.setCategory(template.getCategory());
            ref.setDescription(template.getDescription());
            ref.setVisible(template.isVisible());
            ref.setTemplateFiles(template.getTemplateFiles());
            ref.setDateCreated(new Date(template.getDateCreated()));
            ref.setDateModified(new Date(template.getDateModified()));
            return ref;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @WebMethod(operationName="getFormTemplateFiles", action="http://gopro/selfservice/formtemplateservice/getFormTemplateFiles")
    @WebResult(name="getFormTemplateFilesResult", targetNamespace="http://gopro/selfservice/formtemplateservice/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public List<FormTemplateFile> getFormTemplateFiles(@WebParam(name="templateId") String templateId) {
        try {
            SelfServicePrincipal principal = FormServiceAuthentication.createCredentials(this.wsContext.getMessageContext());
            this.assertCredentials(principal);
            FormTemplate template = FormService.getFormTemplate(templateId, true);
            if (template == null) {
                throw new SelfServiceException("The Form template specified was not found!");
            }
            return template.getTemplateFiles();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private final void assertCredentials(SelfServicePrincipal principal) throws SelfServiceException {
        if (!FormServiceAuthentication.validateCredentials(principal)) {
            throw new SelfServiceException("Authentication failed!");
        }
    }

    private final boolean isAssociated(Organization org, FormTemplate template) {
        for (String id : template.getOrganizationIds()) {
            if (!id.equals(org.getId())) continue;
            return true;
        }
        return false;
    }

    private Organization getOrganization(String organizationId) throws SelfServiceException {
        Organization org = ConfigService.getOrganization(organizationId);
        if (org == null) {
            throw new SelfServiceException("The specified organization was not found!");
        }
        if (org.isDeleted()) {
            throw new SelfServiceException("The specified organization has been deleted!");
        }
        if (!org.isRemoteTemplatesEnabled()) {
            throw new SelfServiceException("Remote access for this organization has been disabled!");
        }
        return org;
    }

    private byte[] getPdfVersion(byte[] stream, Organization org) throws SelfServiceException {
        try {
            byte[] results = null;
            if (stream != null && org != null) {
                String xpathQuery;
                Document xmlDoc = FormsUtil.createDocument(stream);
                List<Element> list = FormQueryUtil.selectNodes(xmlDoc, xpathQuery = "//SECTIONS/SECTION/FIELDS//VALUE", false);
                if (list != null && list.size() > 0) {
                    for (Element el : list) {
                        String val = el.getText();
                        if (val == null || !val.startsWith("[") || !val.endsWith("]")) continue;
                        el.setText("");
                    }
                }
                DateFormat df = LocaleUtil.getTimeFormat();
                xmlDoc.getRootElement().addAttribute("SUBMITTED", df.format(new Date()));
                xmlDoc.getRootElement().addAttribute("ORGANIZATION", org.getSubject());
                PDFProperties props = new PDFProperties();
                FOPTransformer fop = new FOPTransformer(props);
                results = fop.transFormToPDF(xmlDoc, FormTemplateExtras.XSLFoType.SINGLE, GoProFormTemplate.GoProFormType.GOPRO_FORM_V1);
            }
            return results;
        }
        catch (FormException ex) {
            throw new SelfServiceException(ex);
        }
    }
}

