/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.webservice;

import com.sun.xml.ws.transport.Headers;
import is.hugvit.bird.licence.LicenceService;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.handler.MessageContext;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.SelfServicePrincipal;
import net.gopro.selfservice.util.SignatureUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public final class FormServiceAuthentication {
    public static SelfServicePrincipal createCredentials(MessageContext messageContext) {
        Headers headers = (Headers)messageContext.get((Object)"javax.xml.ws.http.request.headers");
        List authorization = headers.get((Object)"Authorization");
        if (authorization != null) {
            String str = StringUtils.join((Object[])authorization.toArray(new String[authorization.size()]));
            if (str.startsWith("Basic ")) {
                String userPassPair = new String(Base64.decodeBase64((String)str.substring(6)));
                int divIndex = userPassPair.indexOf(58);
                if (divIndex > 0) {
                    String username = userPassPair.substring(0, divIndex);
                    String password = userPassPair.substring(divIndex + 1);
                    ArrayList roles = new ArrayList();
                    SelfServicePrincipal principal = new SelfServicePrincipal(username, password, roles);
                    return principal;
                }
                messageContext.put((Object)"javax.xml.ws.http.response.code", (Object)401);
                throw new RuntimeException("Cannot parse the authentication header");
            }
            messageContext.put((Object)"javax.xml.ws.http.response.code", (Object)401);
            throw new RuntimeException("Unsupported authentication header");
        }
        messageContext.put((Object)"javax.xml.ws.http.response.code", (Object)401);
        Headers responseHeader = new Headers();
        responseHeader.add("WWW-Authenticate", "BASIC Realm=GoPro Self Service");
        messageContext.put((Object)"javax.xml.ws.http.response.headers", (Object)responseHeader);
        throw new RuntimeException("Missing authentication header - no authentication performed");
    }

    public static final boolean validateCredentials(SelfServicePrincipal principal) throws SelfServiceException {
        String organizationId = principal.getName();
        String token = principal.getPassword();
        return FormServiceAuthentication.validatePassword(organizationId, token);
    }

    public static final boolean validatePassword(String username, String token) {
        try {
            String passKey = LicenceService.getServerId() + "_G0$Pro#.S3lf";
            String decrypted = SignatureUtil.decryptString(token, passKey);
            return decrypted.equals(username);
        }
        catch (Exception ex) {
            return false;
        }
    }
}

