/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.webquery;

import is.hugvit.bird.WebContext;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.gopro.selfservice.IWebFormQuery;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Message;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.FormQueryException;
import net.gopro.selfservice.services.MessageService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.ThreadContext;
import org.dom4j.Element;
import org.json.JSONException;
import org.json.JSONObject;

public class StatusQuery
implements IWebFormQuery {
    @Override
    public void setContext(WebContext context) {
    }

    @Override
    public void doAction(Element el, String action, JSONObject data) throws FormQueryException {
        try {
            User currentUser = UserService.getUser(ThreadContext.getCurrentUser().getUserId());
            long now = new Date().getTime();
            long lastcheck = new Date().getTime();
            if (data.has("lastcheck")) {
                lastcheck = data.getLong("lastcheck");
            } else {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(lastcheck);
                cal.add(13, -10);
                lastcheck = cal.getTimeInMillis();
            }
            Date date = new Date();
            date.setTime(lastcheck);
            boolean isUpdate = false;
            List<Message> messageList = MessageService.getMessages(currentUser.getId(), date);
            if (messageList.size() > 0) {
                Element messageRoot = el.addElement("messages");
                isUpdate = true;
                for (Message m : messageList) {
                    messageRoot.add(m.getXml());
                }
            }
            el.addElement("checktime").setText(String.valueOf(now));
            el.addElement("update").setText(String.valueOf(isUpdate));
        }
        catch (JSONException ex) {
            el.addElement("error").setText(ex.getMessage());
            ex.printStackTrace();
        }
        catch (SelfServiceException ex) {
            el.addElement("error").setText(ex.getMessage());
            ex.printStackTrace();
        }
    }
}

