/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.webquery;

import is.hugvit.bird.WebContext;
import net.gopro.selfservice.IWebFormQuery;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.Case;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.gopro.RemoteGoPro;
import net.gopro.selfservice.exceptions.FormQueryException;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.util.Dom4JUtil;
import org.dom4j.Element;
import org.dom4j.Node;
import org.json.JSONException;
import org.json.JSONObject;

public class CaseQuery
implements IWebFormQuery {
    @Override
    public void setContext(WebContext context) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doAction(Element el, String action, JSONObject data) throws FormQueryException {
        try {
            Organization org;
            SubDocument sub;
            String caseNumber = data.getString("case_id");
            if (!"casestatus".equals(action)) return;
            BaseCase bc = CaseService.getCase(caseNumber);
            if (bc == null && (sub = CaseService.getSubDocument(caseNumber, false)) != null) {
                bc = CaseService.getCase(sub.getCaseId());
            }
            if (bc == null) {
                throw new FormQueryException("The requested Case was not found.");
            }
            Dom4JUtil.addElement(el, "subject", bc.getSubject());
            Dom4JUtil.addElement(el, "casenumber", bc.getGoProCaseNumber());
            Dom4JUtil.addElement(el, "refnumber", bc.getReferenceNumber());
            if (bc.getStatus() != null) {
                Dom4JUtil.addElement(el, "status", bc.getStatus().getSubject());
            }
            if ((org = ConfigService.getOrganization(bc.getOrganizationId())) != null) {
                Dom4JUtil.addElement(el, "organization", org.getSubject());
                if (!RemoteGoPro.GoPro.BROKER_PICKUP.equals((Object)org.getEndpoint().getGoproType())) {
                    Dom4JUtil.addElement(el, "gopro", org.getEndpoint().getGoProTypeName());
                }
            }
            if (bc == null) return;
            if (bc instanceof FormCase) {
                FormCase fc = (FormCase)bc;
                ApplicationForm form = fc.getApplicationForm();
                if (form == null) return;
                el.addElement("case_id").setText(caseNumber);
                Element xel = fc.getXml();
                Node statusNode = xel.selectSingleNode("statusflow");
                if (statusNode == null) return;
                statusNode = statusNode.detach();
                el.add(statusNode);
                return;
            }
            if (!(bc instanceof Case)) return;
        }
        catch (SelfServiceException ex) {
            throw new FormQueryException(ex);
        }
        catch (JSONException ex) {
            throw new FormQueryException((Exception)((Object)ex));
        }
    }
}

