/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.webquery;

import is.hugvit.bird.WebContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.gopro.selfservice.IWebFormQuery;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.AccessControl;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.CaseTemplate;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.FormQueryException;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.DocumentSecurityUtil;
import net.gopro.selfservice.util.ThreadContext;
import org.dom4j.Element;
import org.json.JSONObject;

public class CaseListQuery
implements IWebFormQuery {
    private CaseType caseType = CaseType.FormCase;
    private WebContext context;
    private boolean isWriteAccessRequired = false;

    @Override
    public void setContext(WebContext context) {
        this.context = context;
    }

    @Override
    public void doAction(Element el, String action, JSONObject data) throws FormQueryException {
        block23: {
            try {
                if (action == null || !"list".equals(action)) break block23;
                if (data.has("id")) {
                    Object caseTemplate;
                    Object caseTemplates;
                    if (data.has("type") && "case".equals(data.getString("type"))) {
                        this.caseType = CaseType.Case;
                    } else if (data.has("type") && "all".equals(data.getString("type"))) {
                        this.caseType = CaseType.All;
                    }
                    if (data.has("access") && "write".equalsIgnoreCase(data.getString("access"))) {
                        this.isWriteAccessRequired = true;
                    }
                    List<Object> caseList = new ArrayList();
                    String id = data.getString("id");
                    if (CaseType.All.equals((Object)this.caseType)) {
                        caseTemplates = CaseService.getCaseTemplates();
                        Iterator<CaseTemplate> iterator = caseTemplates.iterator();
                        while (iterator.hasNext()) {
                            caseTemplate = iterator.next();
                            if (!((CaseTemplate)caseTemplate).getSubject().equalsIgnoreCase(id)) continue;
                            caseList = CaseService.getCasesByCaseTemplate(((BaseDocument)caseTemplate).getId(), ThreadContext.getCurrentUser().getUserId());
                            break;
                        }
                        List<FormTemplate> list = FormService.getFormTemplates();
                        for (FormTemplate formTemplate : list) {
                            if (!formTemplate.getSubject().equalsIgnoreCase(id)) continue;
                            caseList.addAll(CaseService.getCasesByFormTemplate(formTemplate.getId()));
                            break;
                        }
                    } else if (CaseType.FormCase.equals((Object)this.caseType)) {
                        if (id.length() == 32) {
                            for (FormCase formCase : CaseService.getCasesByFormTemplate(id)) {
                                caseList.add(formCase);
                            }
                        } else {
                            List<FormTemplate> formTemplates = FormService.getFormTemplates();
                            for (FormTemplate formTemplate : formTemplates) {
                                if (!formTemplate.getSubject().equalsIgnoreCase(id)) continue;
                                for (FormCase fc : CaseService.getCasesByFormTemplate(formTemplate.getId())) {
                                    caseList.add(fc);
                                }
                                break;
                            }
                        }
                    } else if (id.length() == 32) {
                        caseList = CaseService.getCasesByCaseTemplate(id, ThreadContext.getCurrentUser().getUserId());
                    } else {
                        caseTemplates = CaseService.getCaseTemplates();
                        Iterator<CaseTemplate> iterator = caseTemplates.iterator();
                        while (iterator.hasNext()) {
                            caseTemplate = iterator.next();
                            if (!((CaseTemplate)caseTemplate).getSubject().equalsIgnoreCase(id)) continue;
                            caseList = CaseService.getCasesByCaseTemplate(((BaseDocument)caseTemplate).getId(), ThreadContext.getCurrentUser().getUserId());
                            break;
                        }
                    }
                    BaseDocumentUtil.removeDeletedDocuments(caseList);
                    el.addElement("status").setText("success");
                    Element elCases = el.addElement("list");
                    User user = UserService.getUser(ThreadContext.getCurrentUser().getUserId());
                    for (BaseCase baseCase : caseList) {
                        if (this.isWriteAccessRequired) {
                            BaseCase bcx = CaseService.getCase(baseCase.getId());
                            if (!DocumentSecurityUtil.getDocumentPermission(AccessControl.Permission.WRITE, user, bcx)) continue;
                            elCases.add(bcx.getXml());
                            continue;
                        }
                        elCases.add(baseCase.getXml());
                    }
                    break block23;
                }
                throw new SelfServiceException("No Id was provided.");
            }
            catch (SelfServiceException ex) {
                throw new FormQueryException(ex);
            }
        }
    }

    private static enum CaseType {
        FormCase,
        Case,
        All;

    }
}

