/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.webelement;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import is.hugvit.log.Log;
import is.hugvit.util.Cache;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.util.SaxReader;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.codec.digest.DigestUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class RssReader
extends WebElementBase {
    private static int RSS_CACHE_TIME = 240;
    private static Cache cache;
    private static final String defaultInputDateFormat = "E, dd MMM yyyy hh:mm:ss z";
    private static final String defaultOutputDateFormat;
    private static final Log log;
    private String id;
    private String url;
    private String dateFormat;
    private int maxItems = -1;
    private boolean stripHtml = false;

    public void doGet(WebContext context) throws BirdException {
        this.id = context.getParameter("id");
        this.url = context.getParameter("url");
        this.dateFormat = context.getParameter("dateformat", defaultInputDateFormat);
        this.maxItems = context.getParameterInt("max", 100);
        this.stripHtml = context.getParameter("striphtml", "false").equalsIgnoreCase("true");
        if (StringUtil.isValid(this.id) && StringUtil.isValid(this.url)) {
            Element el = null;
            Node node = context.getRootElement().selectSingleNode("//rss-feeds");
            el = node != null ? (Element)node : context.getRootElement().addElement("rss-feeds");
            this.createRssElement(el);
        } else {
            log.error("Cannot add the RSS feed, either the \"id\" or the \"url\" parameter is missing.");
        }
    }

    private final void createRssElement(Element root) {
        Node node;
        String m5dSum = DigestUtils.md5Hex((String)this.url);
        Document doc = null;
        Object o = null;
        if (cache != null) {
            o = cache.get((Object)m5dSum);
        }
        if (o == null) {
            try {
                URL rssUrl = new URL(this.url);
                SAXReader reader = SaxReader.createReader();
                doc = reader.read(rssUrl);
                cache.put((Object)m5dSum, (Object)((Document)doc.clone()));
            }
            catch (MalformedURLException ex) {
                log.warn("Error fetching rss: " + ex.getMessage());
            }
            catch (DocumentException ex) {
                log.warn("Error loading rss: " + ex.getMessage());
            }
            catch (SAXException ex) {
                log.warn("Could not create saxreader: " + ex.getMessage());
            }
        } else {
            Document cacheDoc = (Document)o;
            if (cacheDoc != null) {
                doc = (Document)cacheDoc.clone();
            }
        }
        if (doc != null && (node = doc.selectSingleNode("//rss/channel")) != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
            SimpleDateFormat outFormat = new SimpleDateFormat(defaultOutputDateFormat);
            node = node.detach();
            ((Element)node).addAttribute("id", this.id);
            List itemList = node.selectNodes("item");
            Iterator it = itemList.iterator();
            int itemCounter = 1;
            while (it.hasNext()) {
                Node descNode;
                Node current = (Node)it.next();
                if (itemCounter > this.maxItems) {
                    current.detach();
                    continue;
                }
                try {
                    Node dateNode = current.selectSingleNode("pubDate");
                    if (dateNode != null) {
                        String pubDate = dateNode.getText();
                        Date outDate = sdf.parse(pubDate);
                        dateNode.getParent().addElement("ssDate").setText(outFormat.format(outDate));
                    }
                }
                catch (Exception ex) {
                    log.warn("Error parsing date, check the dateformat settings for this feed. " + ex.getMessage());
                }
                if (this.stripHtml && (descNode = current.selectSingleNode("description")) != null) {
                    descNode.setText(StringUtil.stripHTML(descNode.getText()));
                }
                ++itemCounter;
            }
            root.addElement("feed").add(node);
        }
    }

    static {
        log = SelfServiceEngine.getLogger();
        cache = new Cache(5, RSS_CACHE_TIME);
        defaultOutputDateFormat = SelfServiceEngine.getConfig("web.locale.dateformat");
    }
}

